/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.VariableElement;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class FieldAccessNode
extends Node {
    protected Tree tree;
    protected VariableElement element;
    protected String field;
    protected Node receiver;

    public FieldAccessNode(Tree tree, Node receiver) {
        super(InternalUtils.typeOf(tree));
        assert (TreeUtils.isFieldAccess(tree));
        this.tree = tree;
        this.receiver = receiver;
        this.field = TreeUtils.getFieldName(tree);
        if (tree instanceof MemberSelectTree) {
            this.element = (VariableElement)TreeUtils.elementFromUse((MemberSelectTree)tree);
        } else {
            assert (tree instanceof IdentifierTree);
            this.element = (VariableElement)TreeUtils.elementFromUse((IdentifierTree)tree);
        }
    }

    public FieldAccessNode(Tree tree, VariableElement element, Node receiver) {
        super(element.asType());
        this.tree = tree;
        this.element = element;
        this.receiver = receiver;
        this.field = element.getSimpleName().toString();
    }

    public VariableElement getElement() {
        return this.element;
    }

    public Node getReceiver() {
        return this.receiver;
    }

    public String getFieldName() {
        return this.field;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitFieldAccess(this, p);
    }

    public String toString() {
        return this.getReceiver() + "." + this.field;
    }

    public boolean isStatic() {
        return ElementUtils.isStatic(this.getElement());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FieldAccessNode)) {
            return false;
        }
        FieldAccessNode other = (FieldAccessNode)obj;
        return this.getReceiver().equals(other.getReceiver()) && this.getFieldName().equals(other.getFieldName());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getReceiver(), this.getFieldName());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.receiver);
    }
}

