/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeLock;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.mutex.SqlJetEmptyMutex;

public class SqlJetBtreeShared {
    public static final byte PTRMAP_ROOTPAGE = 1;
    public static final byte PTRMAP_FREEPAGE = 2;
    public static final byte PTRMAP_OVERFLOW1 = 3;
    public static final byte PTRMAP_OVERFLOW2 = 4;
    public static final byte PTRMAP_BTREE = 5;
    ISqlJetPager pPager;
    ISqlJetDbHandle db;
    SqlJetBtreeCursor pCursor;
    SqlJetMemPage pPage1;
    boolean inStmt;
    boolean readOnly;
    boolean pageSizeFixed;
    boolean autoVacuum;
    boolean incrVacuum;
    int pageSize;
    int usableSize;
    int maxLocal;
    int minLocal;
    int maxLeaf;
    int minLeaf;
    SqlJetBtree.TransMode inTransaction = SqlJetBtree.TransMode.NONE;
    int nTransaction;
    Object pSchema;
    ISqlJetMutex mutex = new SqlJetEmptyMutex();
    int nRef;
    SqlJetBtreeShared pNext;
    List<SqlJetBtreeLock> pLock = new LinkedList<SqlJetBtreeLock>();
    SqlJetBtree pExclusive;
    ISqlJetMemoryPointer pTmpSpace;

    public int PENDING_BYTE_PAGE() {
        return (int)(0x40000000L / (long)this.pageSize) + 1;
    }

    public int MX_CELL_SIZE() {
        return this.pageSize - 8;
    }

    public int MX_CELL() {
        return (this.pageSize - 8) / 6;
    }

    public int PTRMAP_PAGENO(int pgno) {
        return this.ptrmapPageno(pgno);
    }

    boolean PTRMAP_ISPAGE(int pgno) {
        return this.PTRMAP_PAGENO(pgno) == pgno;
    }

    private int PTRMAP_PTROFFSET(int pgptrmap, int pgno) {
        return 5 * (pgno - pgptrmap - 1);
    }

    public void invalidateAllOverflowCache() {
        assert (this.mutex.held());
        SqlJetBtreeCursor p = this.pCursor;
        while (p != null) {
            p.aOverflow = null;
            p = p.pNext;
        }
    }

    int getPageCount() throws SqlJetException {
        assert (this.pPage1 != null);
        return this.pPager.getPageCount();
    }

    private int ptrmapPageno(int pgno) {
        assert (this.mutex.held());
        int nPagesPerMapPage = this.usableSize / 5 + 1;
        int iPtrMap = (pgno - 2) / nPagesPerMapPage;
        int ret = iPtrMap * nPagesPerMapPage + 2;
        if (ret == this.PENDING_BYTE_PAGE()) {
            ++ret;
        }
        return ret;
    }

    public void ptrmapPut(int key, short eType, int parent) throws SqlJetException {
        assert (this.mutex.held());
        assert (!this.PTRMAP_ISPAGE(this.PENDING_BYTE_PAGE()));
        assert (this.autoVacuum);
        if (key == 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        int iPtrmap = this.PTRMAP_PAGENO(key);
        ISqlJetPage pDbPage = this.pPager.getPage(iPtrmap);
        int offset = this.PTRMAP_PTROFFSET(iPtrmap, key);
        ISqlJetMemoryPointer pPtrmap = pDbPage.getData();
        if (eType != SqlJetUtility.getUnsignedByte(pPtrmap, offset) || SqlJetUtility.get4byte(pPtrmap, offset + 1) != parent) {
            SqlJetBtree.TRACE("PTRMAP_UPDATE: %d->(%d,%d)\n", key, eType, parent);
            pDbPage.write();
            SqlJetUtility.putUnsignedByte(pPtrmap, offset, eType);
            SqlJetUtility.put4byte(pPtrmap, offset + 1, parent);
        }
        pDbPage.unref();
    }

    public void ptrmapGet(int key, short[] pEType, int[] pPgno) throws SqlJetException {
        assert (this.mutex.held());
        int iPtrmap = this.PTRMAP_PAGENO(key);
        ISqlJetPage pDbPage = this.pPager.acquirePage(iPtrmap, true);
        ISqlJetMemoryPointer pPtrmap = pDbPage.getData();
        int offset = this.PTRMAP_PTROFFSET(iPtrmap, key);
        assert (pEType != null && pEType.length > 0);
        pEType[0] = (short)SqlJetUtility.getUnsignedByte(pPtrmap, offset);
        if (pPgno != null && pPgno.length > 0) {
            pPgno[0] = SqlJetUtility.get4byte(pPtrmap, offset + 1);
        }
        pDbPage.unref();
        if (pEType[0] < 1 || pEType[0] > 5) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private SqlJetMemPage pageFromDbPage(ISqlJetPage pDbPage, int pgno) {
        if (null == pDbPage.getExtra()) {
            pDbPage.setExtra(new SqlJetMemPage());
        }
        SqlJetMemPage pPage = (SqlJetMemPage)pDbPage.getExtra();
        pPage.aData = pDbPage.getData();
        pPage.pDbPage = pDbPage;
        pPage.pBt = this;
        pPage.pgno = pgno;
        pPage.hdrOffset = (byte)(pPage.pgno == 1 ? 100 : 0);
        return pPage;
    }

    public SqlJetMemPage getPage(int pgno, boolean noContent) throws SqlJetException {
        assert (this.mutex.held());
        ISqlJetPage pDbPage = this.pPager.acquirePage(pgno, !noContent);
        return this.pageFromDbPage(pDbPage, pgno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlJetMemPage allocatePage(int[] pPgno, int nearby, boolean exact) throws SqlJetException {
        SqlJetMemPage ppPage = null;
        SqlJetMemPage pTrunk = null;
        SqlJetMemPage pPrevTrunk = null;
        assert (this.mutex.held());
        long n = SqlJetUtility.get4byteUnsigned(this.pPage1.aData, 36);
        try {
            if (n > 0L) {
                boolean searchList = false;
                if (exact && nearby <= this.getPageCount()) {
                    short[] eType = new short[]{0};
                    assert (nearby > 0);
                    assert (this.autoVacuum);
                    this.ptrmapGet(nearby, eType, null);
                    if (eType[0] == 2) {
                        searchList = true;
                    }
                    pPgno[0] = nearby;
                }
                this.pPage1.pDbPage.write();
                SqlJetUtility.put4byteUnsigned(this.pPage1.aData, 36, n - 1L);
                do {
                    int iTrunk = (pPrevTrunk = pTrunk) != null ? SqlJetUtility.get4byte(pPrevTrunk.aData, 0) : SqlJetUtility.get4byte(this.pPage1.aData, 32);
                    try {
                        pTrunk = this.getPage(iTrunk, false);
                    }
                    catch (SqlJetException e) {
                        pTrunk = null;
                        throw e;
                    }
                    int k = SqlJetUtility.get4byte(pTrunk.aData, 4);
                    if (k == 0 && !searchList) {
                        assert (pPrevTrunk == null);
                        pTrunk.pDbPage.write();
                        pPgno[0] = iTrunk;
                        SqlJetUtility.memcpy(this.pPage1.aData, 32, pTrunk.aData, 0, 4);
                        ppPage = pTrunk;
                        pTrunk = null;
                        SqlJetBtree.TRACE("ALLOCATE: %d trunk - %d free pages left\n", pPgno[0], n - 1L);
                    } else {
                        if (k > this.usableSize / 4 - 2) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        if (searchList && nearby == iTrunk) {
                            assert (pPgno[0] == iTrunk);
                            ppPage = pTrunk;
                            searchList = false;
                            pTrunk.pDbPage.write();
                            if (k == 0) {
                                if (pPrevTrunk == null) {
                                    SqlJetUtility.memcpy(this.pPage1.aData, 32, pTrunk.aData, 0, 4);
                                } else {
                                    SqlJetUtility.memcpy(pPrevTrunk.aData, 0, pTrunk.aData, 0, 4);
                                }
                            } else {
                                int iNewTrunk = SqlJetUtility.get4byte(pTrunk.aData, 8);
                                SqlJetMemPage pNewTrunk = this.getPage(iNewTrunk, false);
                                try {
                                    pNewTrunk.pDbPage.write();
                                }
                                catch (SqlJetException e) {
                                    SqlJetMemPage.releasePage(pNewTrunk);
                                    throw e;
                                }
                                SqlJetUtility.memcpy(pNewTrunk.aData, 0, pTrunk.aData, 0, 4);
                                SqlJetUtility.put4byte(pNewTrunk.aData, 4, k - 1);
                                SqlJetUtility.memcpy(pNewTrunk.aData, 8, pTrunk.aData, 12, (k - 1) * 4);
                                SqlJetMemPage.releasePage(pNewTrunk);
                                if (pPrevTrunk == null) {
                                    SqlJetUtility.put4byte(this.pPage1.aData, 32, iNewTrunk);
                                } else {
                                    pPrevTrunk.pDbPage.write();
                                    SqlJetUtility.put4byte(pPrevTrunk.aData, 0, iNewTrunk);
                                }
                            }
                            pTrunk = null;
                            SqlJetBtree.TRACE("ALLOCATE: %d trunk - %d free pages left\n", pPgno[0], n - 1L);
                        } else {
                            int closest;
                            ISqlJetMemoryPointer aData = pTrunk.aData;
                            pTrunk.pDbPage.write();
                            if (nearby > 0) {
                                closest = 0;
                                int dist = SqlJetUtility.get4byte(aData, 8) - nearby;
                                if (dist < 0) {
                                    dist = -dist;
                                }
                                for (int i = 1; i < k; ++i) {
                                    int d2 = SqlJetUtility.get4byte(aData, 8 + i * 4) - nearby;
                                    if (d2 < 0) {
                                        d2 = -d2;
                                    }
                                    if (d2 >= dist) continue;
                                    closest = i;
                                    dist = d2;
                                }
                            } else {
                                closest = 0;
                            }
                            int iPage = SqlJetUtility.get4byte(aData, 8 + closest * 4);
                            if (!searchList || iPage == nearby) {
                                pPgno[0] = iPage;
                                int nPage = this.getPageCount();
                                if (pPgno[0] > nPage) {
                                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                                }
                                SqlJetBtree.TRACE("ALLOCATE: %d was leaf %d of %d on trunk %d: %d more free pages\n", pPgno[0], closest + 1, k, pTrunk.pgno, n - 1L);
                                if (closest < k - 1) {
                                    SqlJetUtility.memcpy(aData, 8 + closest * 4, aData, 4 + k * 4, 4);
                                }
                                SqlJetUtility.put4byte(aData, 4, k - 1);
                                ppPage = this.getPage(pPgno[0], true);
                                ppPage.pDbPage.dontRollback();
                                try {
                                    ppPage.pDbPage.write();
                                }
                                catch (SqlJetException e) {
                                    SqlJetMemPage.releasePage(ppPage);
                                }
                                searchList = false;
                            }
                        }
                    }
                    SqlJetMemPage.releasePage(pPrevTrunk);
                    pPrevTrunk = null;
                } while (searchList);
            } else {
                int nPage = this.getPageCount();
                pPgno[0] = nPage + 1;
                if (this.autoVacuum && this.PTRMAP_ISPAGE(pPgno[0])) {
                    SqlJetBtree.TRACE("ALLOCATE: %d from end of file (pointer-map page)\n", pPgno[0]);
                    assert (pPgno[0] != this.PENDING_BYTE_PAGE());
                    pPgno[0] = pPgno[0] + 1;
                    if (pPgno[0] == this.PENDING_BYTE_PAGE()) {
                        pPgno[0] = pPgno[0] + 1;
                    }
                }
                assert (pPgno[0] != this.PENDING_BYTE_PAGE());
                ppPage = this.getPage(pPgno[0], false);
                try {
                    ppPage.pDbPage.write();
                }
                catch (SqlJetException e) {
                    SqlJetMemPage.releasePage(ppPage);
                }
                SqlJetBtree.TRACE("ALLOCATE: %d from end of file\n", pPgno[0]);
            }
            assert (pPgno[0] != this.PENDING_BYTE_PAGE());
            Object var19_23 = null;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            SqlJetMemPage.releasePage(pTrunk);
            SqlJetMemPage.releasePage(pPrevTrunk);
            throw throwable;
        }
        SqlJetMemPage.releasePage(pTrunk);
        SqlJetMemPage.releasePage(pPrevTrunk);
        if (ppPage.pDbPage.getRefCount() > 1) {
            SqlJetMemPage.releasePage(ppPage);
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        ppPage.isInit = false;
        return ppPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relocatePage(SqlJetMemPage pDbPage, short s2, int iPtrPage, int iFreePage, boolean isCommit) throws SqlJetException {
        int iDbPage = pDbPage.pgno;
        assert (s2 == 4 || s2 == 3 || s2 == 5 || s2 == 1);
        assert (this.mutex.held());
        assert (pDbPage.pBt == this);
        SqlJetBtree.TRACE("AUTOVACUUM: Moving %d to free page %d (ptr page %d type %d)\n", iDbPage, iFreePage, iPtrPage, s2);
        pDbPage.pDbPage.move(iFreePage, isCommit);
        pDbPage.pgno = iFreePage;
        if (s2 == 5 || s2 == 1) {
            pDbPage.setChildPtrmaps();
        } else {
            int nextOvfl = SqlJetUtility.get4byte(pDbPage.aData);
            if (nextOvfl != 0) {
                this.ptrmapPut(nextOvfl, (short)4, iFreePage);
            }
        }
        if (s2 != 1) {
            SqlJetMemPage pPtrPage = this.getPage(iPtrPage, false);
            try {
                pPtrPage.pDbPage.write();
            }
            catch (SqlJetException e) {
                SqlJetMemPage.releasePage(pPtrPage);
                throw e;
            }
            try {
                pPtrPage.modifyPagePointer(iDbPage, iFreePage, s2);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                SqlJetMemPage.releasePage(pPtrPage);
                throw throwable;
            }
            SqlJetMemPage.releasePage(pPtrPage);
            this.ptrmapPut(iFreePage, s2, iPtrPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrVacuumStep(int nFin, int iLastPg) throws SqlJetException {
        assert (this.mutex.held());
        if (!this.PTRMAP_ISPAGE(iLastPg) && iLastPg != this.PENDING_BYTE_PAGE()) {
            int[] iFreePg;
            short[] eType = new short[]{0};
            int[] iPtrPage = new int[]{0};
            int nFreeList = SqlJetUtility.get4byte(this.pPage1.aData, 36);
            if (nFreeList == 0 || nFin == iLastPg) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.ptrmapGet(iLastPg, eType, iPtrPage);
            if (eType[0] == 1) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            if (eType[0] == 2) {
                if (nFin == 0) {
                    iFreePg = new int[1];
                    SqlJetMemPage pFreePg = this.allocatePage(iFreePg, iLastPg, true);
                    assert (iFreePg[0] == iLastPg);
                    SqlJetMemPage.releasePage(pFreePg);
                }
            } else {
                iFreePg = new int[1];
                SqlJetMemPage pLastPg = this.getPage(iLastPg, false);
                do {
                    SqlJetMemPage pFreePg;
                    try {
                        pFreePg = this.allocatePage(iFreePg, 0, false);
                    }
                    catch (SqlJetException e) {
                        SqlJetMemPage.releasePage(pLastPg);
                        throw e;
                    }
                    SqlJetMemPage.releasePage(pFreePg);
                } while (nFin != 0 && iFreePg[0] > nFin);
                assert (iFreePg[0] < iLastPg);
                pLastPg.pDbPage.write();
                try {
                    this.relocatePage(pLastPg, eType[0], iPtrPage[0], iFreePg[0], nFin != 0);
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    SqlJetMemPage.releasePage(pLastPg);
                    throw throwable;
                }
                SqlJetMemPage.releasePage(pLastPg);
                {
                }
            }
        }
        if (nFin == 0) {
            --iLastPg;
            while (iLastPg == this.PENDING_BYTE_PAGE() || this.PTRMAP_ISPAGE(iLastPg)) {
                --iLastPg;
            }
            this.pPager.truncateImage(iLastPg);
        }
    }

    public void autoVacuumCommit() throws SqlJetException {
        int nref = this.pPager.getRefCount();
        assert (this.mutex.held());
        this.invalidateAllOverflowCache();
        assert (this.autoVacuum);
        if (!this.incrVacuum) {
            int pgsz = this.pageSize;
            int nOrig = this.getPageCount();
            if (this.PTRMAP_ISPAGE(nOrig)) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            if (nOrig == this.PENDING_BYTE_PAGE()) {
                --nOrig;
            }
            int nFree = SqlJetUtility.get4byte(this.pPage1.aData, 36);
            int nPtrmap = (nFree - nOrig + this.PTRMAP_PAGENO(nOrig) + pgsz / 5) / (pgsz / 5);
            int nFin = nOrig - nFree - nPtrmap;
            if (nOrig > this.PENDING_BYTE_PAGE() && nFin <= this.PENDING_BYTE_PAGE()) {
                --nFin;
            }
            while (this.PTRMAP_ISPAGE(nFin) || nFin == this.PENDING_BYTE_PAGE()) {
                --nFin;
            }
            try {
                block14: {
                    try {
                        for (int iFree = nOrig; iFree > nFin; --iFree) {
                            this.incrVacuumStep(nFin, iFree);
                        }
                    }
                    catch (SqlJetException e) {
                        if (e.getErrorCode() == SqlJetErrorCode.DONE) break block14;
                        throw e;
                    }
                }
                if (nFree > 0) {
                    this.pPage1.pDbPage.write();
                    SqlJetUtility.put4byte(this.pPage1.aData, 32, 0L);
                    SqlJetUtility.put4byte(this.pPage1.aData, 36, 0L);
                    this.pPager.truncateImage(nFin);
                }
            }
            catch (SqlJetException e) {
                this.pPager.rollback();
                throw e;
            }
        }
        assert (nref == this.pPager.getRefCount());
    }

    public void unlockBtreeIfUnused() throws SqlJetException {
        assert (this.mutex.held());
        if (this.inTransaction == SqlJetBtree.TransMode.NONE && this.pCursor == null && this.pPage1 != null) {
            if (this.pPager.getRefCount() >= 1) {
                assert (this.pPage1.aData != null);
                SqlJetMemPage.releasePage(this.pPage1);
            }
            this.pPage1 = null;
            this.inStmt = false;
        }
    }

    public boolean saveAllCursors(int iRoot, SqlJetBtreeCursor pExcept) throws SqlJetException {
        assert (this.mutex.held());
        assert (pExcept == null || pExcept.pBt == this);
        SqlJetBtreeCursor p = this.pCursor;
        while (p != null) {
            if (!(p == pExcept || 0 != iRoot && p.pgnoRoot != iRoot || p.eState != SqlJetBtreeCursor.CursorState.VALID || p.saveCursorPosition())) {
                return false;
            }
            p = p.pNext;
        }
        return true;
    }

    public int countWriteCursors() {
        int r = 0;
        SqlJetBtreeCursor pCur = this.pCursor;
        while (pCur != null) {
            if (pCur.wrFlag && pCur.eState != SqlJetBtreeCursor.CursorState.FAULT) {
                ++r;
            }
            pCur = pCur.pNext;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDatabasePage(int pgno, boolean freePageFlag, int[] pnChange) throws SqlJetException {
        SqlJetMemPage pPage = null;
        assert (this.mutex.held());
        if (pgno > this.pPager.getPageCount()) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        try {
            pPage = this.getAndInitPage(pgno);
            for (int i = 0; i < pPage.nCell; ++i) {
                ISqlJetMemoryPointer pCell = pPage.findCell(i);
                if (!pPage.leaf) {
                    this.clearDatabasePage(SqlJetUtility.get4byte(pCell), true, pnChange);
                }
                pPage.clearCell(pCell);
            }
            if (!pPage.leaf) {
                this.clearDatabasePage(SqlJetUtility.get4byte(pPage.aData, 8), true, pnChange);
            } else if (pnChange != null) {
                assert (pPage.intKey);
                pnChange[0] = pnChange[0] + pPage.nCell;
            }
            if (freePageFlag) {
                pPage.freePage();
            } else {
                pPage.pDbPage.write();
                pPage.zeroPage(SqlJetUtility.getUnsignedByte(pPage.aData, 0) | 8);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SqlJetMemPage.releasePage(pPage);
            throw throwable;
        }
        SqlJetMemPage.releasePage(pPage);
    }

    SqlJetMemPage getAndInitPage(int pgno) throws SqlJetException {
        ISqlJetPage pDbPage = null;
        SqlJetMemPage pPage = null;
        assert (this.mutex.held());
        if (pgno == 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        try {
            pDbPage = this.pPager.lookupPage(pgno);
            if (pDbPage != null) {
                pPage = this.pageFromDbPage(pDbPage, pgno);
            } else {
                if (pgno > this.pPager.getPageCount()) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                pPage = this.getPage(pgno, false);
            }
            if (!pPage.isInit) {
                pPage.initPage();
            }
        }
        catch (SqlJetException e) {
            SqlJetMemPage.releasePage(pPage);
            throw e;
        }
        return pPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getOverflowPage(int ovfl, SqlJetMemPage[] ppPage, int[] pPgnoNext) throws SqlJetException {
        int next = 0;
        assert (this.mutex.held());
        if (!($assertionsDisabled || ppPage != null && ppPage.length != 0)) {
            if (pPgnoNext == null) throw new AssertionError();
            if (pPgnoNext.length == 0) {
                throw new AssertionError();
            }
        }
        if (pPgnoNext == null || pPgnoNext.length == 0 || pPgnoNext[0] == 0) {
            ppPage[0] = this.getPage(ovfl, true);
            return;
        }
        if (this.autoVacuum) {
            int iGuess;
            int[] pgno = new int[]{0};
            short[] eType = new short[]{0};
            for (iGuess = ovfl + 1; this.PTRMAP_ISPAGE(iGuess) || iGuess == this.PENDING_BYTE_PAGE(); ++iGuess) {
            }
            if (iGuess <= this.pPager.getPageCount()) {
                this.ptrmapGet(iGuess, eType, pgno);
                if (eType[0] == 4 && pgno[0] == ovfl) {
                    next = iGuess;
                }
            }
        }
        if (next == 0 || ppPage != null && ppPage.length != 0) {
            SqlJetMemPage pPage;
            block15: {
                pPage = null;
                try {
                    pPage = this.getPage(ovfl, next != 0);
                    Object var9_8 = null;
                    if (next != 0 || pPage == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (next == 0 && pPage != null) {
                        next = SqlJetUtility.get4byte(pPage.aData, 0);
                    }
                    if (ppPage != null && ppPage.length != 0) {
                        ppPage[0] = pPage;
                        throw throwable;
                    }
                    SqlJetMemPage.releasePage(pPage);
                    throw throwable;
                }
                next = SqlJetUtility.get4byte(pPage.aData, 0);
            }
            if (ppPage != null && ppPage.length != 0) {
                ppPage[0] = pPage;
            } else {
                SqlJetMemPage.releasePage(pPage);
            }
        }
        pPgnoNext[0] = next;
    }

    public void allocateTempSpace() {
        if (this.pTmpSpace == null) {
            this.pTmpSpace = SqlJetUtility.allocatePtr(this.pageSize);
        }
    }

    public void ptrmapPutOvflPtr(SqlJetMemPage pPage, ISqlJetMemoryPointer pCell) throws SqlJetException {
        assert (pCell != null);
        SqlJetBtreeCellInfo info = pPage.parseCellPtr(pCell);
        assert ((long)info.nData + (pPage.intKey ? 0L : info.nKey) == (long)info.nPayload);
        if (info.iOverflow > 0) {
            int ovfl = SqlJetUtility.get4byte(pCell.getMoved(info.iOverflow));
            pPage.pBt.ptrmapPut(ovfl, (short)3, pPage.pgno);
        }
    }
}

