/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNCommandEnvironment;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNewDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffStatus;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffCommand
extends SVNXMLCommand
implements ISVNDiffStatusHandler {
    private SVNPath anchor;

    public SVNDiffCommand() {
        super("diff", new String[]{"di"});
    }

    @Override
    public boolean acceptsRevisionRange() {
        return true;
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.CHANGE);
        options.add(SVNOption.OLD);
        options.add(SVNOption.NEW);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.DIFF_CMD);
        options.add(SVNOption.EXTENSIONS);
        options.add(SVNOption.NO_DIFF_DELETED);
        options.add(SVNOption.NO_DIFF_ADDED);
        options.add(SVNOption.NOTICE_ANCESTRY);
        options.add(SVNOption.SHOW_COPIES_AS_ADDS);
        options.add(SVNOption.SUMMARIZE);
        options.add(SVNOption.CHANGELIST);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.XML);
        options.add(SVNOption.GIT_DIFF_FORMAT);
        options.add(SVNOption.PROPERTIES_ONLY);
        options.add(SVNOption.IGNORE_PROPERTIES);
        return options;
    }

    @Override
    public void run() throws SVNException {
        if (this.getSVNEnvironment().isXML()) {
            if (!this.getSVNEnvironment().isSummarize()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "'--xml' option only valid with '--summarize' option");
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            this.printXMLHeader("diff");
            StringBuffer buffer = this.openXMLTag("paths", 1, null, null);
            this.getSVNEnvironment().getOut().print(buffer.toString());
        }
        List<Object> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        SVNPath oldTarget = null;
        SVNPath newTarget = null;
        SVNRevision start = this.getSVNEnvironment().getStartRevision();
        SVNRevision end = this.getSVNEnvironment().getEndRevision();
        boolean peggedDiff = false;
        if (targets.size() == 2 && this.getSVNEnvironment().getOldTarget() == null && this.getSVNEnvironment().getNewTarget() == null && SVNCommandUtil.isURL((String)targets.get(0)) && SVNCommandUtil.isURL((String)targets.get(1)) && this.getSVNEnvironment().getStartRevision() == SVNRevision.UNDEFINED && this.getSVNEnvironment().getEndRevision() == SVNRevision.UNDEFINED) {
            oldTarget = new SVNPath((String)targets.get(0), true);
            newTarget = new SVNPath((String)targets.get(1), true);
            start = oldTarget.getPegRevision();
            end = newTarget.getPegRevision();
            targets.clear();
            if (start == SVNRevision.UNDEFINED) {
                start = SVNRevision.HEAD;
            }
            if (end == SVNRevision.UNDEFINED) {
                end = SVNRevision.HEAD;
            }
        } else if (this.getSVNEnvironment().getOldTarget() != null) {
            targets.clear();
            targets.add(this.getSVNEnvironment().getOldTarget());
            targets.add(this.getSVNEnvironment().getNewTarget() != null ? this.getSVNEnvironment().getNewTarget() : this.getSVNEnvironment().getOldTarget());
            oldTarget = new SVNPath((String)targets.get(0), true);
            newTarget = new SVNPath((String)targets.get(1), true);
            start = this.getSVNEnvironment().getStartRevision();
            end = this.getSVNEnvironment().getEndRevision();
            if (oldTarget.getPegRevision() != SVNRevision.UNDEFINED) {
                start = oldTarget.getPegRevision();
            }
            if (newTarget.getPegRevision() != SVNRevision.UNDEFINED) {
                end = newTarget.getPegRevision();
            }
            if (start == SVNRevision.UNDEFINED) {
                SVNRevision sVNRevision = oldTarget.isURL() ? SVNRevision.HEAD : (start = this.getSVNEnvironment().getNewTarget() != null ? SVNRevision.WORKING : SVNRevision.BASE);
            }
            if (end == SVNRevision.UNDEFINED) {
                end = newTarget.isURL() ? SVNRevision.HEAD : SVNRevision.WORKING;
            }
            targets = this.getSVNEnvironment().combineTargets(null, true);
        } else if (this.getSVNEnvironment().getNewTarget() != null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "'--new' option only valid with '--old' option");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        } else {
            if (targets.isEmpty()) {
                targets.add("");
            }
            oldTarget = new SVNPath("");
            newTarget = new SVNPath("");
            boolean hasURLs = false;
            boolean hasWCs = false;
            for (int i = 0; i < targets.size(); ++i) {
                SVNPath target = new SVNPath((String)targets.get(i));
                hasURLs |= target.isURL();
                hasWCs |= target.isFile();
            }
            if (hasURLs && hasWCs) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Target lists to diff may not contain both working copy paths and URLs");
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            start = this.getSVNEnvironment().getStartRevision();
            end = this.getSVNEnvironment().getEndRevision();
            if (start == SVNRevision.UNDEFINED && hasWCs) {
                start = SVNRevision.BASE;
            }
            if (end == SVNRevision.UNDEFINED) {
                end = hasWCs ? SVNRevision.WORKING : SVNRevision.HEAD;
            }
            boolean bl = peggedDiff = start != SVNRevision.BASE && start != SVNRevision.WORKING || end != SVNRevision.BASE && end != SVNRevision.WORKING;
        }
        if (targets.isEmpty()) {
            targets.add("");
        }
        SVNDiffClient client = this.getSVNEnvironment().getClientManager().getDiffClient();
        SVNCommandEnvironment environment = (SVNCommandEnvironment)this.getEnvironment();
        client.setShowCopiesAsAdds(environment.isShowCopiesAsAdds());
        client.setGitDiffFormat(environment.isGitDiffFormat());
        SvnNewDiffGenerator generator = SVNDiffCommand.createDiffGenerator(this.getSVNEnvironment());
        client.setDiffGenerator(generator);
        PrintStream ps = this.getSVNEnvironment().getOut();
        Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
        for (int i = 0; i < targets.size(); ++i) {
            String targetName = (String)targets.get(i);
            if (!peggedDiff) {
                SVNPath target1 = new SVNPath(SVNPathUtil.append(oldTarget.getTarget(), targetName));
                SVNPath target2 = new SVNPath(SVNPathUtil.append(newTarget.getTarget(), targetName));
                if (this.getSVNEnvironment().isSummarize()) {
                    this.anchor = target1;
                    if (target1.isURL() && target2.isURL()) {
                        client.doDiffStatus(target1.getURL(), start, target2.getURL(), end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (ISVNDiffStatusHandler)this);
                        continue;
                    }
                    if (target1.isURL()) {
                        client.doDiffStatus(target1.getURL(), start, target2.getFile(), end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (ISVNDiffStatusHandler)this);
                        continue;
                    }
                    if (target2.isURL()) {
                        client.doDiffStatus(target1.getFile(), start, target2.getURL(), end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (ISVNDiffStatusHandler)this);
                        continue;
                    }
                    client.doDiffStatus(target1.getFile(), start, target2.getFile(), end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (ISVNDiffStatusHandler)this);
                    continue;
                }
                if (target1.isURL() && target2.isURL()) {
                    client.doDiff(target1.getURL(), start, target2.getURL(), end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (OutputStream)ps);
                    continue;
                }
                if (target1.isURL()) {
                    client.doDiff(target1.getURL(), start, target2.getFile(), end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (OutputStream)ps, (Collection<String>)changeLists);
                    continue;
                }
                if (target2.isURL()) {
                    client.doDiff(target1.getFile(), start, target2.getURL(), end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (OutputStream)ps, (Collection<String>)changeLists);
                    continue;
                }
                client.doDiff(target1.getFile(), start, target2.getFile(), end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (OutputStream)ps, (Collection<String>)changeLists);
                continue;
            }
            SVNPath target = new SVNPath(targetName, true);
            SVNRevision pegRevision = target.getPegRevision();
            if (pegRevision == SVNRevision.UNDEFINED) {
                SVNRevision sVNRevision = pegRevision = target.isURL() ? SVNRevision.HEAD : SVNRevision.WORKING;
            }
            if (this.getSVNEnvironment().isSummarize()) {
                this.anchor = target;
                if (target.isURL()) {
                    client.doDiffStatus(target.getURL(), start, end, pegRevision, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (ISVNDiffStatusHandler)this);
                    continue;
                }
                client.doDiffStatus(target.getFile(), start, end, pegRevision, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (ISVNDiffStatusHandler)this);
                continue;
            }
            if (target.isURL()) {
                client.doDiff(target.getURL(), pegRevision, start, end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (OutputStream)ps);
                continue;
            }
            client.doDiff(target.getFile(), pegRevision, start, end, this.getSVNEnvironment().getDepth(), this.getSVNEnvironment().isNoticeAncestry(), (OutputStream)ps, (Collection<String>)changeLists);
        }
        if (this.getSVNEnvironment().isXML()) {
            StringBuffer buffer = this.closeXMLTag("paths", null);
            this.getSVNEnvironment().getOut().print(buffer.toString());
            this.printXMLFooter("diff");
        }
    }

    static SvnNewDiffGenerator createDiffGenerator(SVNCommandEnvironment svnEnvironment) throws SVNException {
        SvnDiffGenerator diffGenerator = new SvnDiffGenerator();
        if (svnEnvironment.getDiffCommand() != null) {
            diffGenerator.setExternalDiffCommand(svnEnvironment.getDiffCommand());
            diffGenerator.setRawDiffOptions((List)svnEnvironment.getExtensions());
        } else {
            diffGenerator.setDiffOptions(svnEnvironment.getDiffOptions());
        }
        diffGenerator.setDiffDeleted(!svnEnvironment.isNoDiffDeleted());
        diffGenerator.setDiffAdded(!svnEnvironment.isNoDiffAdded());
        diffGenerator.setForcedBinaryDiff(svnEnvironment.isForce());
        diffGenerator.setBasePath(new File("").getAbsoluteFile());
        diffGenerator.setFallbackToAbsolutePath(true);
        diffGenerator.setOptions(svnEnvironment.getOptions());
        diffGenerator.setDiffDeleted(!svnEnvironment.isNoDiffDeleted());
        diffGenerator.setPropertiesOnly(svnEnvironment.isPropertiesOnly());
        diffGenerator.setIgnoreProperties(svnEnvironment.isIgnoreProperties());
        return new SvnNewDiffGenerator(diffGenerator);
    }

    @Override
    public void handleDiffStatus(SVNDiffStatus diffStatus) throws SVNException {
        if (diffStatus.getModificationType() == SVNStatusType.STATUS_NONE && !diffStatus.isPropertiesModified()) {
            return;
        }
        SVNPath anchor = this.anchor;
        String path = diffStatus.getPath();
        if (anchor != null) {
            if (anchor.isURL()) {
                path = diffStatus.getURL() != null ? diffStatus.getURL().toString() : SVNPathUtil.append(anchor.getTarget(), diffStatus.getPath());
            } else {
                path = this.getSVNEnvironment().getRelativePath(diffStatus.getFile());
                path = SVNCommandUtil.getLocalPath(path);
            }
        }
        if (this.getSVNEnvironment().isXML()) {
            StringBuffer buffer = new StringBuffer();
            SVNHashMap attrs = new SVNHashMap();
            attrs.put("kind", diffStatus.getKind().toString());
            String modificationKind = "none";
            if (diffStatus.getModificationType() == SVNStatusType.STATUS_MODIFIED) {
                modificationKind = "modified";
            } else if (diffStatus.getModificationType() == SVNStatusType.STATUS_ADDED) {
                modificationKind = "added";
            } else if (diffStatus.getModificationType() == SVNStatusType.STATUS_DELETED) {
                modificationKind = "deleted";
            }
            attrs.put("item", modificationKind);
            attrs.put("props", diffStatus.isPropertiesModified() ? "modified" : "none");
            buffer = this.openXMLTag("path", 2, attrs, buffer);
            buffer.append(SVNEncodingUtil.xmlEncodeCDATA(path));
            buffer = this.closeXMLTag("path", buffer);
            this.getSVNEnvironment().getOut().print(buffer.toString());
        } else {
            this.getSVNEnvironment().getOut().print(diffStatus.getModificationType().getCode() + (diffStatus.isPropertiesModified() ? "M" : " ") + "      " + path + "\n");
            this.getSVNEnvironment().getOut().flush();
        }
    }
}

