/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.framework.qual.FromByteCode;
import org.checkerframework.qualframework.base.TypeMirrorConverter;

public final class JWhich {
    private static @MonotonicNonNull @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String CLASSPATH;

    @FromByteCode
    private JWhich() {
        JWhich.getClasspath();
    }

    @EnsuresNonNull(value={"CLASSPATH"})
    @FromByteCode
    public static void which(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String className) {
        URL classUrl = JWhich.findClass(className);
        if (classUrl == null) {
            System.out.println("\nClass '" + className + "' not found.");
        } else {
            System.out.println("\nClass '" + className + "' found in \n'" + classUrl.getFile() + "'");
        }
        JWhich.validate();
        JWhich.printClasspath();
    }

    @FromByteCode
    public static @Nullable @UnknownKeyFor @NonRaw @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown URL findClass(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String className) {
        return JWhich.class.getResource(JWhich.asResourceName(className));
    }

    @FromByteCode
    protected static @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String asResourceName(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        resource = resource.replace('.', '/');
        resource = resource + ".class";
        return resource;
    }

    @EnsuresNonNull(value={"CLASSPATH"})
    @FromByteCode
    public static void validate() {
        StringTokenizer tokenizer = new StringTokenizer(JWhich.getClasspath(), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            File f = new File(element);
            if (!f.exists()) {
                System.out.println("\nClasspath element '" + element + "' does not exist.");
                continue;
            }
            if (f.isDirectory() || element.toLowerCase().endsWith(".jar") || element.toLowerCase().endsWith(".zip")) continue;
            System.out.println("\nClasspath element '" + element + "' is not a directory, .jar file, or .zip file.");
        }
    }

    @EnsuresNonNull(value={"CLASSPATH"})
    @FromByteCode
    public static void printClasspath() {
        System.out.println("\nClasspath:");
        StringTokenizer tokenizer = new StringTokenizer(JWhich.getClasspath(), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            System.out.println(tokenizer.nextToken());
        }
    }

    @EnsuresNonNull(value={"CLASSPATH"})
    @FromByteCode
    public static void setClasspath(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String classpath) {
        CLASSPATH = classpath;
    }

    @EnsuresNonNull(value={"CLASSPATH"})
    @FromByteCode
    protected static @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String getClasspath() {
        if (CLASSPATH == null) {
            String classpath = System.getProperty("java.class.path");
            JWhich.setClasspath(classpath);
        }
        return CLASSPATH;
    }

    @FromByteCode
    private static void instanceMain(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] args) {
        if (args.length == 0) {
            JWhich.printUsage();
        }
        for (int cmdIndex = 0; cmdIndex < args.length; ++cmdIndex) {
            String cmd = args[cmdIndex];
            if ("-help".equals(cmd)) {
                JWhich.printUsage();
                continue;
            }
            JWhich.which(cmd);
        }
    }

    @FromByteCode
    private static void printUsage() {
        System.out.println("\nSyntax: java JWhich [options] className");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-help     Prints usage information.");
        System.out.println("");
        System.out.println("Examples:");
        System.out.println("\tjava JWhich MyClass");
        System.out.println("\tjava JWhich my.package.MyClass");
        System.exit(0);
    }

    @FromByteCode
    public static void main(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] args) {
        JWhich.instanceMain(args);
    }
}

