/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.index.qual.LengthOf;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class IndexMethodIdentifier {
    private final ExecutableElement mathRandom;
    private final ExecutableElement randomNextDouble;
    private final ExecutableElement randomNextInt;
    private final ExecutableElement stringLength;
    private final List<ExecutableElement> mathMinMethods;
    private final List<ExecutableElement> mathMaxMethods;
    private final AnnotatedTypeFactory factory;

    public IndexMethodIdentifier(AnnotatedTypeFactory factory) {
        this.factory = factory;
        ProcessingEnvironment processingEnv = factory.getProcessingEnv();
        this.mathRandom = TreeUtils.getMethod("java.lang.Math", "random", 0, processingEnv);
        this.randomNextDouble = TreeUtils.getMethod("java.util.Random", "nextDouble", 0, processingEnv);
        this.randomNextInt = TreeUtils.getMethod("java.util.Random", "nextInt", 1, processingEnv);
        this.stringLength = TreeUtils.getMethod("java.lang.String", "length", 0, processingEnv);
        this.mathMinMethods = TreeUtils.getMethods("java.lang.Math", "min", 2, processingEnv);
        this.mathMaxMethods = TreeUtils.getMethods("java.lang.Math", "max", 2, processingEnv);
    }

    public boolean isMathMin(Tree methodTree) {
        ProcessingEnvironment processingEnv = this.factory.getProcessingEnv();
        return TreeUtils.isMethodInvocation(methodTree, this.mathMinMethods, processingEnv);
    }

    public boolean isMathMax(Tree methodTree) {
        ProcessingEnvironment processingEnv = this.factory.getProcessingEnv();
        return TreeUtils.isMethodInvocation(methodTree, this.mathMaxMethods, processingEnv);
    }

    public boolean isMathRandom(Tree tree, ProcessingEnvironment processingEnv) {
        return TreeUtils.isMethodInvocation(tree, this.mathRandom, processingEnv);
    }

    public boolean isRandomNextDouble(Tree tree, ProcessingEnvironment processingEnv) {
        return TreeUtils.isMethodInvocation(tree, this.randomNextDouble, processingEnv);
    }

    public boolean isRandomNextInt(Tree tree, ProcessingEnvironment processingEnv) {
        return TreeUtils.isMethodInvocation(tree, this.randomNextInt, processingEnv);
    }

    public boolean isLengthOfMethodInvocation(Tree tree) {
        if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        return this.isLengthOfMethodInvocation(TreeUtils.elementFromUse((MethodInvocationTree)tree));
    }

    public boolean isLengthOfMethodInvocation(ExecutableElement ele) {
        if (this.stringLength.equals(ele)) {
            return true;
        }
        AnnotationMirror len = this.factory.getDeclAnnotation(ele, LengthOf.class);
        if (len == null) {
            return false;
        }
        List<String> values = AnnotationUtils.getElementValueArray(len, "value", String.class, false);
        return values.contains("this");
    }

    public boolean isLengthOfMethodInvocation(Node node) {
        if (node instanceof MethodInvocationNode) {
            MethodInvocationNode methodInvocationNode = (MethodInvocationNode)node;
            MethodAccessNode methodAccessNode = methodInvocationNode.getTarget();
            ExecutableElement ele = methodAccessNode.getMethod();
            return this.isLengthOfMethodInvocation(ele);
        }
        return false;
    }
}

