/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.util.TreePath;
import org.checkerframework.checker.index.upperbound.OffsetEquation;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.dependenttypes.DependentTypesError;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.framework.util.dependenttypes.DependentTypesTreeAnnotator;
import org.checkerframework.javacutil.TreeUtils;

public class OffsetDependentTypesHelper
extends DependentTypesHelper {
    public OffsetDependentTypesHelper(AnnotatedTypeFactory factory) {
        super(factory);
    }

    @Override
    protected String standardizeString(String expression, FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, boolean useLocalScope) {
        if (DependentTypesError.isExpressionError(expression)) {
            return expression;
        }
        if (expression.indexOf(45) == -1 && expression.indexOf(43) == -1) {
            Object constant;
            FlowExpressions.Receiver result;
            try {
                result = FlowExpressionParseUtil.parse(expression, context, localScope, useLocalScope);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                return new DependentTypesError(expression, e).toString();
            }
            if (result == null) {
                return new DependentTypesError(expression, " ").toString();
            }
            if (result instanceof FlowExpressions.FieldAccess && ((FlowExpressions.FieldAccess)result).isFinal() && (constant = ((FlowExpressions.FieldAccess)result).getField().getConstantValue()) != null && !(constant instanceof String)) {
                return constant.toString();
            }
            return result.toString();
        }
        OffsetEquation equation = OffsetEquation.createOffsetFromJavaExpression(expression);
        if (equation.hasError()) {
            return equation.getError();
        }
        try {
            equation.standardizeAndViewpointAdaptExpressions(context, localScope, useLocalScope, this.factory);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
            return new DependentTypesError(expression, e).toString();
        }
        return equation.toString();
    }

    @Override
    public TreeAnnotator createDependentTypesTreeAnnotator(AnnotatedTypeFactory factory) {
        return new DependentTypesTreeAnnotator(factory, this){

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
                if (TreeUtils.isArrayLengthAccess(tree)) {
                    return null;
                }
                return super.visitMemberSelect(tree, type);
            }
        };
    }
}

