/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.samelen;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationUtils;

public class SameLenTransfer
extends CFTransfer {
    private SameLenAnnotatedTypeFactory aTypeFactory;
    private AnnotationMirror UNKNOWN;

    public SameLenTransfer(CFAnalysis analysis) {
        super(analysis);
        this.aTypeFactory = (SameLenAnnotatedTypeFactory)analysis.getTypeFactory();
        this.UNKNOWN = this.aTypeFactory.UNKNOWN;
    }

    private Node getLengthReceiver(Node lengthNode) {
        if (this.isArrayLengthAccess(lengthNode)) {
            FieldAccessNode lengthFieldAccessNode = (FieldAccessNode)lengthNode;
            return lengthFieldAccessNode.getReceiver();
        }
        if (this.aTypeFactory.getMethodIdentifier().isLengthOfMethodInvocation(lengthNode)) {
            MethodInvocationNode lengthMethodInvocationNode = (MethodInvocationNode)lengthNode;
            return lengthMethodInvocationNode.getTarget().getReceiver();
        }
        return null;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssignment(AssignmentNode node, TransferInput<CFValue, CFStore> in) {
        Node lengthNode;
        Node lengthNodeReceiver;
        ArrayCreationNode acNode;
        TransferResult<CFValue, CFStore> result = super.visitAssignment(node, in);
        if (node.getExpression() instanceof ArrayCreationNode && (acNode = (ArrayCreationNode)node.getExpression()).getDimensions().size() == 1 && (lengthNodeReceiver = this.getLengthReceiver(lengthNode = acNode.getDimension(0))) != null) {
            FlowExpressions.Receiver targetRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getTarget());
            FlowExpressions.Receiver otherRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), lengthNodeReceiver);
            AnnotationMirror lengthNodeAnnotation = this.aTypeFactory.getAnnotatedType(lengthNodeReceiver.getTree()).getAnnotationInHierarchy(this.UNKNOWN);
            AnnotationMirror combinedSameLen = this.aTypeFactory.createCombinedSameLen(targetRec, otherRec, this.UNKNOWN, lengthNodeAnnotation);
            this.propagateCombinedSameLen(combinedSameLen, node, result.getRegularStore());
            return result;
        }
        AnnotationMirror rightAnno = this.aTypeFactory.getAnnotatedType(node.getExpression().getTree()).getAnnotationInHierarchy(this.UNKNOWN);
        FlowExpressions.Receiver targetRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getTarget());
        FlowExpressions.Receiver exprRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getExpression());
        if (IndexUtil.isSequenceType(node.getTarget().getType()) || rightAnno != null && AnnotationUtils.areSameByClass(rightAnno, SameLen.class)) {
            AnnotationMirror rightAnnoOrUnknown = rightAnno == null ? this.UNKNOWN : rightAnno;
            AnnotationMirror combinedSameLen = this.aTypeFactory.createCombinedSameLen(targetRec, exprRec, this.UNKNOWN, rightAnnoOrUnknown);
            this.propagateCombinedSameLen(combinedSameLen, node, result.getRegularStore());
        }
        return result;
    }

    private void propagateCombinedSameLen(AnnotationMirror sameLenAnno, Node node, CFStore store) {
        TreePath currentPath = this.aTypeFactory.getPath(node.getTree());
        if (currentPath == null) {
            return;
        }
        for (String expr : IndexUtil.getValueOfAnnotationWithStringArgument(sameLenAnno)) {
            FlowExpressions.Receiver recS;
            try {
                recS = this.aTypeFactory.getReceiverFromJavaExpressionString(expr, currentPath);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                continue;
            }
            store.clearValue(recS);
            store.insertValue(recS, sameLenAnno);
        }
    }

    private boolean isArrayLengthAccess(Node node) {
        return node instanceof FieldAccessNode && ((FieldAccessNode)node).getFieldName().equals("length") && ((FieldAccessNode)node).getReceiver().getType().getKind() == TypeKind.ARRAY;
    }

    private void refineEq(Node left, Node right, CFStore store) {
        ArrayList<FlowExpressions.Receiver> receivers = new ArrayList<FlowExpressions.Receiver>();
        ArrayList<AnnotationMirror> annos = new ArrayList<AnnotationMirror>();
        for (Node internal : this.splitAssignments(left)) {
            receivers.add(FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), internal));
            annos.add(this.getAnno(internal));
        }
        for (Node internal : this.splitAssignments(right)) {
            receivers.add(FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), internal));
            annos.add(this.getAnno(internal));
        }
        AnnotationMirror combinedSameLen = this.aTypeFactory.createCombinedSameLen(receivers, annos);
        this.propagateCombinedSameLen(combinedSameLen, left, store);
    }

    AnnotationMirror getAnno(Node n) {
        if (n.isLValue()) {
            return this.aTypeFactory.getAnnotatedType(n.getTree()).getAnnotationInHierarchy(this.UNKNOWN);
        }
        CFValue cfValue = (CFValue)this.analysis.getValue(n);
        if (cfValue == null) {
            return this.UNKNOWN;
        }
        return this.aTypeFactory.getQualifierHierarchy().findAnnotationInHierarchy(cfValue.getAnnotations(), this.UNKNOWN);
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> result, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        CFStore elseStore = result.getElseStore();
        CFStore thenStore = result.getThenStore();
        CFStore equalStore = notEqualTo ? elseStore : thenStore;
        Node firstLengthReceiver = this.getLengthReceiver(firstNode);
        Node secondLengthReceiver = this.getLengthReceiver(secondNode);
        if (firstLengthReceiver != null && secondLengthReceiver != null) {
            this.refineEq(firstLengthReceiver, secondLengthReceiver, equalStore);
        } else if (IndexUtil.isSequenceType(firstNode.getType()) || IndexUtil.isSequenceType(secondNode.getType())) {
            this.refineEq(firstNode, secondNode, equalStore);
        }
        return new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), thenStore, elseStore);
    }

    @Override
    protected void addInformationFromPreconditions(CFStore info, AnnotatedTypeFactory factory, UnderlyingAST.CFGMethod method, MethodTree methodTree, ExecutableElement methodElement) {
        super.addInformationFromPreconditions(info, factory, method, methodTree, methodElement);
        List<? extends VariableTree> paramTrees = methodTree.getParameters();
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<AnnotatedTypeMirror> params = new ArrayList<AnnotatedTypeMirror>();
        for (VariableTree variableTree : paramTrees) {
            paramNames.add(variableTree.getName().toString());
            params.add(this.aTypeFactory.getAnnotatedType(variableTree));
        }
        for (int index = 0; index < params.size(); ++index) {
            AnnotatedTypeMirror annotatedTypeMirror = (AnnotatedTypeMirror)params.get(index);
            AnnotationMirror anm = annotatedTypeMirror.getAnnotation(SameLen.class);
            if (anm == null) continue;
            List<String> values = IndexUtil.getValueOfAnnotationWithStringArgument(anm);
            for (String value : values) {
                int otherParamIndex = paramNames.indexOf(value);
                if (otherParamIndex == -1) continue;
                AnnotationMirror newSameLen = this.aTypeFactory.createSameLen(Collections.singletonList(paramNames.get(index)));
                FlowExpressions.Receiver otherParamRec = null;
                try {
                    otherParamRec = FlowExpressionParseUtil.internalReprOfVariable(this.aTypeFactory, paramTrees.get(otherParamIndex));
                }
                catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
                    // empty catch block
                }
                if (otherParamRec == null) continue;
                info.insertValue(otherParamRec, newSameLen);
            }
        }
    }
}

