/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.nullness.KeyForAnalysis;
import org.checkerframework.checker.nullness.KeyForAnnotatedTypeFactory;
import org.checkerframework.checker.nullness.KeyForStore;
import org.checkerframework.checker.nullness.KeyForValue;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;

public class KeyForTransfer
extends CFAbstractTransfer<KeyForValue, KeyForStore, KeyForTransfer> {
    public KeyForTransfer(KeyForAnalysis analysis) {
        super(analysis);
    }

    @Override
    public TransferResult<KeyForValue, KeyForStore> visitMethodInvocation(MethodInvocationNode node, TransferInput<KeyForValue, KeyForStore> in) {
        TransferResult<KeyForValue, KeyForStore> result = super.visitMethodInvocation(node, in);
        KeyForAnnotatedTypeFactory factory = (KeyForAnnotatedTypeFactory)this.analysis.getTypeFactory();
        if (factory.isMapContainsKey(node) || factory.isMapPut(node)) {
            Node receiver = node.getTarget().getReceiver();
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf((AnnotationProvider)factory, receiver);
            String mapName = internalReceiver.toString();
            FlowExpressions.Receiver keyReceiver = FlowExpressions.internalReprOf((AnnotationProvider)factory, node.getArgument(0));
            LinkedHashSet<String> keyForMaps = new LinkedHashSet<String>();
            keyForMaps.add(mapName);
            KeyForValue previousKeyValue = in.getValueOfSubNode(node.getArgument(0));
            if (previousKeyValue != null) {
                for (AnnotationMirror prevAm : previousKeyValue.getAnnotations()) {
                    if (prevAm == null || !AnnotationUtils.areSameByClass(prevAm, KeyFor.class)) continue;
                    keyForMaps.addAll(this.getKeys(prevAm));
                }
            }
            AnnotationMirror am = factory.createKeyForAnnotationMirrorWithValue(keyForMaps);
            if (factory.isMapContainsKey(node)) {
                result.getThenStore().insertValue(keyReceiver, am);
            } else {
                result.getThenStore().insertValue(keyReceiver, am);
                result.getElseStore().insertValue(keyReceiver, am);
            }
        }
        return result;
    }

    private Set<String> getKeys(AnnotationMirror keyFor) {
        if (keyFor.getElementValues().isEmpty()) {
            return new LinkedHashSet<String>();
        }
        return new LinkedHashSet<String>(AnnotationUtils.getElementValueArray(keyFor, "value", String.class, true));
    }
}

