/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.subtyping;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.subtyping.SubtypingAnnotationClassLoader;
import org.checkerframework.common.subtyping.qual.Unqualified;
import org.checkerframework.framework.qual.DefaultFor;
import org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.checkerframework.framework.qual.SubtypeOf;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotationClassLoader;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.UserError;

public class SubtypingAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public SubtypingAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.postInit();
    }

    @Override
    protected AnnotationClassLoader createAnnotationClassLoader() {
        return new SubtypingAnnotationClassLoader(this.checker);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        this.loader = this.createAnnotationClassLoader();
        LinkedHashSet<Class<? extends Annotation>> qualSet = new LinkedHashSet<Class<? extends Annotation>>();
        String qualNames = this.checker.getOption("quals");
        String qualDirectories = this.checker.getOption("qualDirs");
        if (qualNames == null && qualDirectories == null) {
            throw new UserError("SubtypingChecker: missing required option. Use -Aquals or -AqualDirs.");
        }
        if (qualNames != null) {
            for (String qualName : qualNames.split(",")) {
                Class<? extends Annotation> anno = this.loader.loadExternalAnnotationClass(qualName);
                if (anno == null) {
                    throw new UserError("Qualifier specified in -Aquals not found: " + (String)qualName);
                }
                qualSet.add(anno);
            }
        }
        if (qualDirectories != null) {
            for (String dirName : qualDirectories.split(":")) {
                Set<Class<? extends Annotation>> annos = this.loader.loadExternalAnnotationClassesFromDirectory(dirName);
                if (annos.isEmpty()) {
                    throw new UserError("Directory specified in -AqualsDir contains no qualifiers: " + (String)dirName);
                }
                qualSet.addAll(annos);
            }
        }
        if (qualSet.isEmpty()) {
            throw new UserError("SubtypingChecker: no qualifiers specified via -Aquals or -AqualDirs");
        }
        for (Class clazz : qualSet) {
            SubtypeOf subtypeOfAnnotation = clazz.getAnnotation(SubtypeOf.class);
            if (subtypeOfAnnotation == null) continue;
            for (Class<? extends Annotation> superqual : clazz.getAnnotation(SubtypeOf.class).value()) {
                if (qualSet.contains(superqual)) continue;
                throw new UserError("SubtypingChecker: qualifier " + clazz + " was specified via -Aquals but its super-qualifier " + superqual + " was not");
            }
        }
        return qualSet;
    }

    @Override
    protected void addCheckedCodeDefaults(QualifierDefaults defs) {
        boolean foundOtherwise = false;
        for (Class<? extends Annotation> qual : this.getSupportedTypeQualifiers()) {
            DefaultFor defaultFor = qual.getAnnotation(DefaultFor.class);
            if (defaultFor != null) {
                TypeUseLocation[] locations = defaultFor.value();
                defs.addCheckedCodeDefaults(AnnotationBuilder.fromClass(this.elements, qual), locations);
                boolean bl = foundOtherwise = foundOtherwise || Arrays.asList(locations).contains((Object)TypeUseLocation.OTHERWISE);
            }
            if (qual.getAnnotation(DefaultQualifierInHierarchy.class) == null) continue;
            defs.addCheckedCodeDefault(AnnotationBuilder.fromClass(this.elements, qual), TypeUseLocation.OTHERWISE);
            foundOtherwise = true;
        }
        AnnotationMirror unqualified = AnnotationBuilder.fromClass(this.elements, Unqualified.class);
        if (!foundOtherwise && this.isSupportedQualifier(unqualified)) {
            defs.addCheckedCodeDefault(unqualified, TypeUseLocation.OTHERWISE);
        }
    }
}

