/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.element.Element;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.javacutil.TreeUtils;

public class LocalVariableNode
extends Node {
    protected final Tree tree;
    protected final Node receiver;

    public LocalVariableNode(Tree t) {
        this(t, null);
    }

    public LocalVariableNode(Tree t, Node receiver) {
        super(TreeUtils.typeOf(t));
        assert (t != null);
        assert (t instanceof IdentifierTree || t instanceof VariableTree);
        this.tree = t;
        this.receiver = receiver;
    }

    public Element getElement() {
        Element el;
        if (this.tree instanceof IdentifierTree) {
            el = TreeUtils.elementFromUse((IdentifierTree)this.tree);
        } else {
            assert (this.tree instanceof VariableTree);
            el = TreeUtils.elementFromDeclaration((VariableTree)this.tree);
        }
        return el;
    }

    public Node getReceiver() {
        return this.receiver;
    }

    public String getName() {
        if (this.tree instanceof IdentifierTree) {
            return ((IdentifierTree)this.tree).getName().toString();
        }
        return ((VariableTree)this.tree).getName().toString();
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitLocalVariable(this, p);
    }

    public String toString() {
        return this.getName().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalVariableNode)) {
            return false;
        }
        LocalVariableNode other = (LocalVariableNode)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

