/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.framework.qual.AnnotatedFor;
import scenelib.annotations.Annotation;
import scenelib.annotations.Annotations;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AExpression;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.DefException;
import scenelib.annotations.el.ElementVisitor;
import scenelib.annotations.field.ArrayAFT;
import scenelib.annotations.field.BasicAFT;
import scenelib.annotations.io.IndexFileParser;
import scenelib.annotations.io.IndexFileWriter;
import scenelib.annotations.io.ParseException;

public class AddAnnotatedFor {
    private static AnnotationDef adAnnotatedFor;
    private static ElementVisitor<Void, Set<String>> annotatedForVisitor;

    public static void main(String[] args) throws IOException, DefException, ParseException {
        InputStreamReader r;
        String filename;
        AScene scene = new AScene();
        if (args.length > 0) {
            filename = args[0];
            r = new FileReader(filename);
        } else {
            filename = "System.in";
            r = new InputStreamReader(System.in);
        }
        IndexFileParser.parse(new LineNumberReader(r), filename, scene);
        scene.prune();
        AddAnnotatedFor.addAnnotatedFor(scene);
        IndexFileWriter.write(scene, new PrintWriter(System.out, true));
    }

    public static void addAnnotatedFor(AScene scene) {
        for (AClass clazz : new HashSet(scene.classes.values())) {
            HashSet annotatedFor = new HashSet();
            clazz.accept(annotatedForVisitor, annotatedFor);
            if (annotatedFor.isEmpty()) continue;
            ArrayList annotatedForList = new ArrayList(annotatedFor);
            clazz.tlAnnotationsHere.add(new Annotation(adAnnotatedFor, Annotations.valueFieldOnly(annotatedForList)));
        }
    }

    static {
        Class<AnnotatedFor> annotatedFor = AnnotatedFor.class;
        HashSet<Annotation> annotatedForMetaAnnotations = new HashSet<Annotation>();
        annotatedForMetaAnnotations.add(Annotations.aRetentionSource);
        annotatedForMetaAnnotations.add(Annotations.createValueAnnotation(Annotations.adTarget, Arrays.asList("TYPE", "METHOD", "CONSTRUCTOR", "PACKAGE")));
        adAnnotatedFor = new AnnotationDef(annotatedFor.getCanonicalName(), annotatedForMetaAnnotations, Collections.singletonMap("value", new ArrayAFT(BasicAFT.forType(String.class))), "AddAnnotatedFor.<clinit>");
        annotatedForVisitor = new ElementVisitor<Void, Set<String>>(){

            @Override
            public Void visitAnnotationDef(AnnotationDef el, Set<String> annotatedFor) {
                return null;
            }

            @Override
            public Void visitBlock(ABlock el, Set<String> annotatedFor) {
                for (AField e : el.locals.values()) {
                    e.accept(this, annotatedFor);
                }
                return this.visitExpression((AExpression)el, annotatedFor);
            }

            @Override
            public Void visitClass(AClass el, Set<String> annotatedFor) {
                for (AElement e : el.bounds.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.extendsImplements.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.fieldInits.values()) {
                    ((AExpression)e).accept(this, annotatedFor);
                }
                for (AElement e : el.fields.values()) {
                    ((AField)e).accept(this, annotatedFor);
                }
                for (AElement e : el.instanceInits.values()) {
                    ((ABlock)e).accept(this, annotatedFor);
                }
                for (AElement e : el.methods.values()) {
                    ((AMethod)e).accept(this, annotatedFor);
                }
                for (AElement e : el.staticInits.values()) {
                    ((ABlock)e).accept(this, annotatedFor);
                }
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            @Override
            public Void visitDeclaration(ADeclaration el, Set<String> annotatedFor) {
                for (ATypeElement e : el.insertAnnotations.values()) {
                    e.accept(this, annotatedFor);
                }
                for (ATypeElement e : el.insertTypecasts.values()) {
                    ((ATypeElementWithType)e).accept(this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            @Override
            public Void visitExpression(AExpression el, Set<String> annotatedFor) {
                for (AElement e : el.calls.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.funs.values()) {
                    ((AMethod)e).accept(this, annotatedFor);
                }
                for (AElement e : el.instanceofs.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.news.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.refs.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.typecasts.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            @Override
            public Void visitField(AField el, Set<String> annotatedFor) {
                if (el.init != null) {
                    el.init.accept(this, annotatedFor);
                }
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            @Override
            public Void visitMethod(AMethod el, Set<String> annotatedFor) {
                if (el.body != null) {
                    el.body.accept(this, annotatedFor);
                }
                if (el.receiver != null) {
                    el.receiver.accept(this, annotatedFor);
                }
                if (el.returnType != null) {
                    el.returnType.accept(this, annotatedFor);
                }
                for (AElement e : el.bounds.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.parameters.values()) {
                    ((AField)e).accept(this, annotatedFor);
                }
                for (AElement e : el.throwsException.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            @Override
            public Void visitTypeElement(ATypeElement el, Set<String> annotatedFor) {
                for (ATypeElement e : el.innerTypes.values()) {
                    e.accept(this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            @Override
            public Void visitTypeElementWithType(ATypeElementWithType el, Set<String> annotatedFor) {
                return this.visitTypeElement((ATypeElement)el, annotatedFor);
            }

            @Override
            public Void visitElement(AElement el, Set<String> annotatedFor) {
                for (Annotation a : el.tlAnnotationsHere) {
                    int i;
                    String s2 = a.def().name;
                    int j = s2.indexOf(".qual.");
                    if (j <= 0 || (i = s2.lastIndexOf(46, j - 1)) <= 0 || j - i <= 1) continue;
                    annotatedFor.add(s2.substring(i + 1, j));
                }
                if (el.type != null) {
                    el.type.accept(this, annotatedFor);
                }
                return null;
            }
        };
    }
}

