/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.el;

import java.util.LinkedHashSet;
import java.util.Set;
import scenelib.annotations.Annotation;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.DefException;
import scenelib.annotations.field.AnnotationAFT;
import scenelib.annotations.field.AnnotationFieldType;

public abstract class DefCollector {
    private final Set<AnnotationDef> defs = new LinkedHashSet<AnnotationDef>();

    public DefCollector(AScene s2) throws DefException {
        this.collect(s2);
    }

    private AnnotationDef getDef(String name) {
        for (AnnotationDef def : this.defs) {
            if (!def.name.equals(name)) continue;
            return def;
        }
        return null;
    }

    private void collect(AScene s2) throws DefException {
        for (AElement p : s2.packages.values()) {
            this.collect(p);
        }
        for (AClass c : s2.classes.values()) {
            this.collect(c);
        }
    }

    private void addToDefs(AnnotationDef d) throws DefException {
        if (this.defs.contains(d)) {
            return;
        }
        AnnotationDef oldD = this.getDef(d.name);
        if (oldD == null) {
            this.defs.add(d);
        } else {
            AnnotationDef ud = AnnotationDef.unify(oldD, d);
            if (ud == null) {
                throw new DefException(d.name, oldD, d);
            }
            this.defs.remove(oldD);
            this.defs.add(ud);
        }
    }

    private void collect(AnnotationDef d) throws DefException {
        if (this.defs.contains(d)) {
            return;
        }
        for (AnnotationFieldType aft : d.fieldTypes.values()) {
            if (!(aft instanceof AnnotationAFT)) continue;
            this.collect(((AnnotationAFT)aft).annotationDef);
        }
        this.addToDefs(d);
    }

    private void collect(AElement e) throws DefException {
        for (Annotation tla : e.tlAnnotationsHere) {
            AnnotationDef tld = tla.def;
            if (this.defs.contains(tld)) continue;
            AnnotationDef d = tld;
            this.collect(d);
            this.addToDefs(d);
        }
        if (e.type != null) {
            this.collect(e.type);
        }
    }

    private void collect(ATypeElement e) throws DefException {
        this.collect((AElement)e);
        for (AElement it : e.innerTypes.values()) {
            this.collect(it);
        }
    }

    private void collect(ADeclaration d) throws DefException {
        this.collect((AElement)d);
        for (ATypeElement ia : d.insertAnnotations.values()) {
            this.collect(ia);
        }
        for (ATypeElementWithType ic : d.insertTypecasts.values()) {
            this.collect(ic);
        }
    }

    private void collect(AField f) throws DefException {
        this.collect((ADeclaration)f);
    }

    private void collect(AMethod m3) throws DefException {
        for (ATypeElement b : m3.bounds.values()) {
            this.collect(b);
        }
        this.collect((ADeclaration)m3);
        this.collect(m3.returnType);
        this.collect(m3.receiver);
        for (AElement p : m3.parameters.values()) {
            this.collect(p);
        }
        for (AField l : m3.body.locals.values()) {
            this.collect(l);
        }
        for (ATypeElement tc : m3.body.typecasts.values()) {
            this.collect(tc);
        }
        for (ATypeElement i : m3.body.instanceofs.values()) {
            this.collect(i);
        }
        for (ATypeElement n : m3.body.news.values()) {
            this.collect(n);
        }
    }

    private void collect(AClass c) throws DefException {
        this.collect((ADeclaration)c);
        for (ATypeElement b : c.bounds.values()) {
            this.collect(b);
        }
        for (ATypeElement ei : c.extendsImplements.values()) {
            this.collect(ei);
        }
        for (AMethod m3 : c.methods.values()) {
            this.collect(m3);
        }
        for (AField f : c.fields.values()) {
            this.collect(f);
        }
    }

    protected abstract void visitAnnotationDef(AnnotationDef var1);

    public final void visit() {
        for (AnnotationDef d : this.defs) {
            this.visitAnnotationDef(d);
        }
    }
}

