/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.CommonScanner;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import scenelib.annotations.el.TypeIndexLocation;

public class ExtImplsLocationCriterion
implements Criterion {
    private final String classname;
    private final Integer index;

    public ExtImplsLocationCriterion(String classname, TypeIndexLocation tyLoc) {
        this.classname = classname;
        this.index = tyLoc.typeIndex;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return false;
        }
        Tree parent = parentPath.getLeaf();
        if (parent == null) {
            return false;
        }
        boolean returnValue = false;
        if (this.index == -1 && leaf.getKind() == Tree.Kind.CLASS) {
            return ((JCTree.JCClassDecl)leaf).getExtendsClause() == null;
        }
        if (CommonScanner.hasClassKind(parent)) {
            ClassTree ct2 = (ClassTree)parent;
            if (this.index == -1) {
                Tree ext = ct2.getExtendsClause();
                if (ext == leaf) {
                    returnValue = true;
                }
            } else {
                List<? extends Tree> impls = ct2.getImplementsClause();
                if (this.index < impls.size() && impls.get(this.index) == leaf) {
                    returnValue = true;
                }
            }
        }
        if (!returnValue) {
            return this.isSatisfiedBy(parentPath);
        }
        return true;
    }

    public Integer getIndex() {
        return this.index;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.EXTIMPLS_LOCATION;
    }

    public String toString() {
        return "ExtImplsLocationCriterion: class " + this.classname + " at type index: " + this.index;
    }
}

