/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.AnnotationInsertion;
import annotator.find.Criteria;
import annotator.find.Insertion;
import annotator.find.TypedInsertion;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public class NewInsertion
extends TypedInsertion {
    private static final Pattern qualifiers = Pattern.compile("(?:\\w++\\.)*+");
    protected boolean qualifyType;

    public NewInsertion(Type type, Criteria criteria, List<Insertion> innerTypeInsertions) {
        super(type, criteria, innerTypeInsertions);
        this.annotationsOnly = false;
        this.qualifyType = false;
    }

    @Override
    protected String getText(boolean comments, boolean abbreviate) {
        if (this.annotationsOnly || this.type.getKind() != Type.Kind.ARRAY) {
            StringBuilder b = new StringBuilder();
            List<String> annotations = this.type.getAnnotations();
            if (annotations.isEmpty()) {
                return "";
            }
            for (String a : annotations) {
                b.append(' ').append(a);
            }
            AnnotationInsertion aIns = new AnnotationInsertion(b.substring(1), this.getCriteria(), this.isSeparateLine());
            String result = aIns.getText(comments, abbreviate);
            this.packageNames.addAll(aIns.getPackageNames());
            return result;
        }
        DeclaredType baseType = this.getBaseType();
        boolean commentAnnotation = comments && baseType.getName().isEmpty();
        String result = this.typeToString(this.type, commentAnnotation, abbreviate);
        if (!baseType.getName().isEmpty()) {
            Matcher matcher = qualifiers.matcher(result);
            String prefix = "";
            if (matcher.find() && matcher.start() == 0) {
                prefix = result.substring(0, matcher.end());
                result = result.substring(matcher.end());
            }
            if (this.qualifyType) {
                for (DeclaredType t = baseType; t != null; t = t.getInnerType()) {
                    result = result + t.getName() + ".";
                }
            }
            result = prefix + result;
        }
        result = "new " + result;
        if (comments) {
            result = "/*>>> " + result + " */";
        }
        return result;
    }

    public void setQualifyType(boolean qualifyType) {
        this.qualifyType = qualifyType;
    }

    @Override
    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        if ((precedingChar == '.' || precedingChar == '(') && this.getBaseType().getName().isEmpty()) {
            return false;
        }
        return super.addLeadingSpace(gotSeparateLine, pos, precedingChar);
    }

    @Override
    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        return true;
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.NEW;
    }
}

