/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class IndexUtil {
    public static boolean isSequenceType(TypeMirror type) {
        return type.getKind() == TypeKind.ARRAY || TypesUtils.isString(type);
    }

    public static ExpressionTree getLengthSequenceTree(Tree lengthTree, IndexMethodIdentifier imf, ProcessingEnvironment processingEnv) {
        if (TreeUtils.isArrayLengthAccess(lengthTree)) {
            return ((MemberSelectTree)lengthTree).getExpression();
        }
        if (imf.isLengthOfMethodInvocation(lengthTree)) {
            return TreeUtils.getReceiverTree((MethodInvocationTree)lengthTree);
        }
        return null;
    }
}

