/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.samelen;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.PolyLength;
import org.checkerframework.checker.index.qual.PolySameLen;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueCheckerUtils;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;

public class SameLenAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    private final AnnotationMirror BOTTOM;
    private final AnnotationMirror POLY;
    private final IndexMethodIdentifier imf;

    public SameLenAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationBuilder.fromClass(this.elements, SameLenUnknown.class);
        this.BOTTOM = AnnotationBuilder.fromClass(this.elements, SameLenBottom.class);
        this.POLY = AnnotationBuilder.fromClass(this.elements, PolySameLen.class);
        this.imf = new IndexMethodIdentifier(this);
        this.addAliasedAnnotation(PolyAll.class, this.POLY);
        this.addAliasedAnnotation(PolyLength.class, this.POLY);
        this.postInit();
    }

    IndexMethodIdentifier getMethodIdentifier() {
        return this.imf;
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(SameLen.class, SameLenBottom.class, SameLenUnknown.class, PolySameLen.class));
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new SameLenQualifierHierarchy(factory);
    }

    @Override
    public AnnotatedTypeMirror getAnnotatedTypeLhs(Tree tree) {
        AnnotationMirror anm;
        AnnotatedTypeMirror atm = super.getAnnotatedTypeLhs(tree);
        if (tree.getKind() == Tree.Kind.VARIABLE && (anm = atm.getAnnotation(SameLen.class)) != null) {
            FlowExpressions.Receiver r;
            try {
                r = FlowExpressionParseUtil.internalReprOfVariable(this, (VariableTree)tree);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException ex) {
                r = null;
            }
            if (r != null) {
                String varName = r.toString();
                List<String> exprs = ValueCheckerUtils.getValueOfAnnotationWithStringArgument(anm);
                if (exprs.contains(varName)) {
                    exprs.remove(varName);
                }
                if (exprs.isEmpty()) {
                    atm.replaceAnnotation(this.UNKNOWN);
                } else {
                    atm.replaceAnnotation(this.createSameLen(exprs));
                }
            }
        }
        return atm;
    }

    public static boolean mayAppearInSameLen(FlowExpressions.Receiver receiver) {
        return !receiver.containsUnknown() && !(receiver instanceof FlowExpressions.ArrayCreation) && !(receiver instanceof FlowExpressions.ClassName) && receiver.toString().length() < 1000;
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new SameLenTreeAnnotator(this));
    }

    public List<String> getSameLensFromString(String sequenceExpression, Tree tree, TreePath currentPath) {
        AnnotationMirror sameLenAnno;
        try {
            sameLenAnno = this.getAnnotationFromJavaExpressionString(sequenceExpression, tree, currentPath, SameLen.class);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
            sameLenAnno = null;
        }
        if (sameLenAnno == null) {
            return new ArrayList<String>();
        }
        return ValueCheckerUtils.getValueOfAnnotationWithStringArgument(sameLenAnno);
    }

    public AnnotationMirror createSameLen(Collection<String> exprs) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, SameLen.class);
        Object[] exprArray = exprs.toArray(new String[0]);
        builder.setValue((CharSequence)"value", exprArray);
        return builder.build();
    }

    public AnnotationMirror createCombinedSameLen(FlowExpressions.Receiver rec1, FlowExpressions.Receiver rec2, AnnotationMirror a1, AnnotationMirror a2) {
        ArrayList<FlowExpressions.Receiver> receivers = new ArrayList<FlowExpressions.Receiver>();
        receivers.add(rec1);
        receivers.add(rec2);
        ArrayList<AnnotationMirror> annos = new ArrayList<AnnotationMirror>();
        annos.add(a1);
        annos.add(a2);
        return this.createCombinedSameLen(receivers, annos);
    }

    public AnnotationMirror createCombinedSameLen(List<FlowExpressions.Receiver> receivers, List<AnnotationMirror> annos) {
        TreeSet<String> exprs = new TreeSet<String>();
        for (FlowExpressions.Receiver rec : receivers) {
            if (!SameLenAnnotatedTypeFactory.mayAppearInSameLen(rec)) continue;
            exprs.add(rec.toString());
        }
        for (AnnotationMirror anno : annos) {
            if (!AnnotationUtils.areSameByClass(anno, SameLen.class)) continue;
            exprs.addAll(ValueCheckerUtils.getValueOfAnnotationWithStringArgument(anno));
        }
        return this.createSameLen(exprs);
    }

    protected class SameLenTreeAnnotator
    extends TreeAnnotator {
        public SameLenTreeAnnotator(SameLenAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitNewArray(NewArrayTree node, AnnotatedTypeMirror type) {
            Tree dimensionTree;
            ExpressionTree sequenceTree;
            if (node.getDimensions().size() == 1 && (sequenceTree = IndexUtil.getLengthSequenceTree(dimensionTree = (Tree)node.getDimensions().get(0), SameLenAnnotatedTypeFactory.this.imf, SameLenAnnotatedTypeFactory.this.processingEnv)) != null) {
                AnnotationMirror sequenceAnno = SameLenAnnotatedTypeFactory.this.getAnnotatedType(sequenceTree).getAnnotationInHierarchy(SameLenAnnotatedTypeFactory.this.UNKNOWN);
                FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, sequenceTree);
                if (SameLenAnnotatedTypeFactory.mayAppearInSameLen(rec)) {
                    List<String> exprs;
                    int index;
                    String recString = rec.toString();
                    if (AnnotationUtils.areSameByClass(sequenceAnno, SameLenUnknown.class)) {
                        sequenceAnno = SameLenAnnotatedTypeFactory.this.createSameLen(Collections.singletonList(recString));
                    } else if (AnnotationUtils.areSameByClass(sequenceAnno, SameLen.class) && (index = Collections.binarySearch(exprs = ValueCheckerUtils.getValueOfAnnotationWithStringArgument(sequenceAnno), recString)) < 0) {
                        exprs.add(-index - 1, recString);
                        sequenceAnno = SameLenAnnotatedTypeFactory.this.createSameLen(exprs);
                    }
                }
                type.addAnnotation(sequenceAnno);
            }
            return null;
        }
    }

    private final class SameLenQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public SameLenQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
            return SameLenAnnotatedTypeFactory.this.UNKNOWN;
        }

        private Set<String> unionIfNotDisjoint(Collection<String> c1, Collection<String> c2) {
            TreeSet<String> result = new TreeSet<String>(c1);
            for (String s2 : c2) {
                if (result.add(s2)) continue;
                return null;
            }
            return result;
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.hasElementValue(a1, "value") && AnnotationUtils.hasElementValue(a2, "value")) {
                List<String> a2Val;
                List<String> a1Val = ValueCheckerUtils.getValueOfAnnotationWithStringArgument(a1);
                Set<String> exprs = this.unionIfNotDisjoint(a1Val, a2Val = ValueCheckerUtils.getValueOfAnnotationWithStringArgument(a2));
                if (exprs == null) {
                    return SameLenAnnotatedTypeFactory.this.BOTTOM;
                }
                return SameLenAnnotatedTypeFactory.this.createSameLen(exprs);
            }
            if (AnnotationUtils.areSameByClass(a1, SameLenUnknown.class)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a2, SameLenUnknown.class)) {
                return a1;
            }
            return SameLenAnnotatedTypeFactory.this.BOTTOM;
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.hasElementValue(a1, "value") && AnnotationUtils.hasElementValue(a2, "value")) {
                List<String> a2Val;
                List<String> a1Val = ValueCheckerUtils.getValueOfAnnotationWithStringArgument(a1);
                if (!Collections.disjoint(a1Val, a2Val = ValueCheckerUtils.getValueOfAnnotationWithStringArgument(a2))) {
                    a1Val.retainAll(a2Val);
                    return SameLenAnnotatedTypeFactory.this.createSameLen(a1Val);
                }
                return SameLenAnnotatedTypeFactory.this.UNKNOWN;
            }
            if (AnnotationUtils.areSameByClass(a1, SameLenBottom.class)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a2, SameLenBottom.class)) {
                return a1;
            }
            if (AnnotationUtils.areSameByClass(a1, PolySameLen.class) && AnnotationUtils.areSameByClass(a2, PolySameLen.class)) {
                return a1;
            }
            return SameLenAnnotatedTypeFactory.this.UNKNOWN;
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            List<String> superArrays;
            List<String> subArrays;
            if (AnnotationUtils.areSameByClass(subAnno, SameLenBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(superAnno, SameLenUnknown.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(subAnno, PolySameLen.class)) {
                return AnnotationUtils.areSameByClass(superAnno, PolySameLen.class);
            }
            return AnnotationUtils.hasElementValue(subAnno, "value") && AnnotationUtils.hasElementValue(superAnno, "value") && (subArrays = ValueCheckerUtils.getValueOfAnnotationWithStringArgument(subAnno)).containsAll(superArrays = ValueCheckerUtils.getValueOfAnnotationWithStringArgument(superAnno));
        }
    }
}

