/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.PluginUtil;
import org.checkerframework.javacutil.TypesUtils;

public class StubGenerator {
    private static final String INDENTION = "    ";
    private final PrintStream out;
    private String currentIndention = "";
    private String currentPackage = null;

    public StubGenerator() {
        this(System.out);
    }

    public StubGenerator(PrintStream out) {
        this.out = out;
    }

    public StubGenerator(OutputStream out) {
        this.out = new PrintStream(out);
    }

    public void stubFromField(Element elt) {
        if (elt.getKind() != ElementKind.FIELD) {
            return;
        }
        String pkg = ElementUtils.getVerboseName(ElementUtils.enclosingPackage(elt));
        if (!"".equals(pkg)) {
            this.currentPackage = pkg;
            this.currentIndention = INDENTION;
            this.indent();
        }
        VariableElement field = (VariableElement)elt;
        this.printFieldDecl(field);
    }

    public void stubFromPackage(PackageElement packageElement) {
        this.currentPackage = packageElement.getQualifiedName().toString();
        this.indent();
        this.out.print("package ");
        this.out.print(this.currentPackage);
        this.out.println(";");
        for (TypeElement element : ElementFilter.typesIn(packageElement.getEnclosedElements())) {
            if (!this.isPublicOrProtected(element)) continue;
            this.out.println();
            this.printClass(element);
        }
    }

    public void stubFromMethod(Element elt) {
        if (elt.getKind() != ElementKind.CONSTRUCTOR && elt.getKind() != ElementKind.METHOD) {
            return;
        }
        String newPackage = ElementUtils.getVerboseName(ElementUtils.enclosingPackage(elt));
        if (!newPackage.equals("")) {
            this.currentPackage = newPackage;
            this.currentIndention = INDENTION;
            this.indent();
        }
        ExecutableElement method = (ExecutableElement)elt;
        this.printMethodDecl(method);
    }

    public void stubFromType(TypeElement typeElement) {
        String fullClassName;
        String className;
        int index;
        if (typeElement.getKind() != ElementKind.CLASS && typeElement.getKind() != ElementKind.INTERFACE) {
            return;
        }
        String newPackageName = ElementUtils.getVerboseName(ElementUtils.enclosingPackage(typeElement));
        boolean newPackage = !newPackageName.equals(this.currentPackage);
        this.currentPackage = newPackageName;
        if (newPackage) {
            this.indent();
            this.out.print("package ");
            this.out.print(this.currentPackage);
            this.out.println(";");
            this.out.println();
        }
        if ((index = (className = (fullClassName = ElementUtils.getQualifiedClassName(typeElement).toString()).substring(fullClassName.indexOf(this.currentPackage) + this.currentPackage.length() + 1)).lastIndexOf(46)) == -1) {
            this.printClass(typeElement);
        } else {
            String outer = className.substring(0, index);
            this.printClass(typeElement, outer.replace('.', '$'));
        }
    }

    private void printClass(TypeElement typeElement) {
        this.printClass(typeElement, null);
    }

    private void printClass(TypeElement typeElement, String outerClass) {
        ArrayList<TypeElement> innerClass = new ArrayList<TypeElement>();
        this.indent();
        java.util.List<? extends AnnotationMirror> teannos = typeElement.getAnnotationMirrors();
        if (teannos != null && !teannos.isEmpty()) {
            for (AnnotationMirror annotationMirror : teannos) {
                this.out.println(annotationMirror);
            }
        }
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            this.out.print("interface");
        } else if (typeElement.getKind() == ElementKind.CLASS) {
            this.out.print("class");
        } else {
            return;
        }
        this.out.print(' ');
        if (outerClass != null) {
            this.out.print(outerClass + "$");
        }
        this.out.print(typeElement.getSimpleName());
        if (!typeElement.getTypeParameters().isEmpty()) {
            this.out.print('<');
            this.out.print(this.formatList(typeElement.getTypeParameters()));
            this.out.print('>');
        }
        if (typeElement.getSuperclass().getKind() != TypeKind.NONE && !TypesUtils.isObject(typeElement.getSuperclass())) {
            this.out.print(" extends ");
            this.out.print(this.formatType(typeElement.getSuperclass()));
        }
        if (!typeElement.getInterfaces().isEmpty()) {
            boolean isInterface = typeElement.getKind() == ElementKind.INTERFACE;
            this.out.print(isInterface ? " extends " : " implements ");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                arrayList.add(this.formatType(typeMirror));
            }
            this.out.print(this.formatList(arrayList));
        }
        this.out.println(" {");
        String tempIndention = this.currentIndention;
        this.currentIndention = this.currentIndention + INDENTION;
        this.printTypeMembers(typeElement.getEnclosedElements(), innerClass);
        this.currentIndention = tempIndention;
        this.indent();
        this.out.println("}");
        for (TypeElement element : innerClass) {
            this.printClass(element, typeElement.getSimpleName().toString());
        }
    }

    private void printTypeMembers(java.util.List<? extends Element> members, java.util.List<TypeElement> innerClass) {
        for (Element element : members) {
            if (!this.isPublicOrProtected(element)) continue;
            this.printMember(element, innerClass);
        }
    }

    private void printMember(Element member, java.util.List<TypeElement> innerClass) {
        if (member.getKind().isField()) {
            this.printFieldDecl((VariableElement)member);
        } else if (member instanceof ExecutableElement) {
            this.printMethodDecl((ExecutableElement)member);
        } else if (member instanceof TypeElement) {
            innerClass.add((TypeElement)member);
        }
    }

    private void printFieldDecl(VariableElement field) {
        if ("class".equals(field.getSimpleName().toString())) {
            StubGenerator.error("Cannot write class literals in stub files.");
            return;
        }
        this.indent();
        java.util.List<? extends AnnotationMirror> veannos = field.getAnnotationMirrors();
        if (veannos != null && !veannos.isEmpty()) {
            for (AnnotationMirror annotationMirror : veannos) {
                this.out.println(annotationMirror);
            }
        }
        if (field.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.out.print("protected ");
        }
        if (field.getModifiers().contains((Object)Modifier.STATIC)) {
            this.out.print("static ");
        }
        if (field.getModifiers().contains((Object)Modifier.FINAL)) {
            this.out.print("final ");
        }
        this.out.print(this.formatType(field.asType()));
        this.out.print(" ");
        this.out.print(field.getSimpleName());
        this.out.println(';');
    }

    private void printMethodDecl(ExecutableElement method) {
        this.indent();
        java.util.List<? extends AnnotationMirror> eeannos = method.getAnnotationMirrors();
        if (eeannos != null && !eeannos.isEmpty()) {
            for (AnnotationMirror annotationMirror : eeannos) {
                this.out.println(annotationMirror);
            }
        }
        if (method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.out.print("protected ");
        }
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            this.out.print("static ");
        }
        if (!method.getTypeParameters().isEmpty()) {
            this.out.print('<');
            this.out.print(this.formatList(method.getTypeParameters()));
            this.out.print("> ");
        }
        if (method.getKind() != ElementKind.CONSTRUCTOR) {
            this.out.print(this.formatType(method.getReturnType()));
            this.out.print(" ");
            this.out.print(method.getSimpleName());
        } else {
            this.out.print(method.getEnclosingElement().getSimpleName());
        }
        this.out.print('(');
        boolean isFirst = true;
        for (VariableElement variableElement : method.getParameters()) {
            if (!isFirst) {
                this.out.print(", ");
            }
            this.out.print(this.formatType(variableElement.asType()));
            this.out.print(' ');
            this.out.print(variableElement.getSimpleName());
            isFirst = false;
        }
        this.out.print(')');
        if (!method.getThrownTypes().isEmpty()) {
            this.out.print(" throws ");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TypeMirror typeMirror : method.getThrownTypes()) {
                arrayList.add(this.formatType(typeMirror));
            }
            this.out.print(this.formatList(arrayList));
        }
        this.out.println(';');
    }

    private void indent() {
        this.out.print(this.currentIndention);
    }

    private String formatList(java.util.List<?> lst) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object o : lst) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(o);
            isFirst = false;
        }
        return sb.toString();
    }

    private boolean isPublicOrProtected(Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    private String formatType(TypeMirror typeRep) {
        StringTokenizer tokenizer = new StringTokenizer(typeRep.toString(), "()<>[], ", true);
        StringBuilder sb = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 || token.lastIndexOf(46) == -1) {
                sb.append(token);
                continue;
            }
            int index = token.lastIndexOf(46);
            sb.append(token.substring(index + 1));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:");
            System.out.println("    java StubGenerator [class or package name]");
            return;
        }
        Context context = new Context();
        Options options = Options.instance(context);
        if (PluginUtil.getJreVersion() == 8) {
            options.put(Option.SOURCE, "8");
            options.put(Option.TARGET, "8");
            options.put(Option.XBOOTCLASSPATH_PREPEND, "jdk8.jar");
        }
        JavaCompiler javac2 = JavaCompiler.instance(context);
        javac2.initModules(List.nil());
        javac2.enterDone();
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(context);
        StubGenerator generator = new StubGenerator();
        if (env.getElementUtils().getPackageElement(args[0]) != null) {
            generator.stubFromPackage(env.getElementUtils().getPackageElement(args[0]));
        } else if (env.getElementUtils().getTypeElement(args[0]) != null) {
            generator.stubFromType(env.getElementUtils().getTypeElement(args[0]));
        } else {
            StubGenerator.error("Couldn't find a package or a class named " + args[0]);
        }
    }

    private static void error(String string) {
        System.err.println("StubGenerator: " + string);
    }
}

