/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.com.github.javaparser.ParseException;
import org.checkerframework.com.github.javaparser.ParseProblemException;
import org.checkerframework.com.github.javaparser.StaticJavaParser;
import org.checkerframework.com.github.javaparser.ast.CompilationUnit;
import org.checkerframework.com.github.javaparser.ast.ImportDeclaration;
import org.checkerframework.com.github.javaparser.ast.NodeList;
import org.checkerframework.com.github.javaparser.ast.PackageDeclaration;
import org.checkerframework.com.github.javaparser.ast.StubUnit;
import org.checkerframework.com.github.javaparser.ast.body.AnnotationDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.BodyDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ConstructorDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.EnumConstantDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.EnumDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.FieldDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.InitializerDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.MethodDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.Parameter;
import org.checkerframework.com.github.javaparser.ast.body.ReceiverParameter;
import org.checkerframework.com.github.javaparser.ast.body.TypeDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.VariableDeclarator;
import org.checkerframework.com.github.javaparser.ast.expr.AnnotationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.Expression;
import org.checkerframework.com.github.javaparser.ast.expr.ObjectCreationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.VariableDeclarationExpr;
import org.checkerframework.com.github.javaparser.ast.stmt.BlockStmt;
import org.checkerframework.com.github.javaparser.ast.type.ArrayType;
import org.checkerframework.com.github.javaparser.ast.type.ClassOrInterfaceType;
import org.checkerframework.com.github.javaparser.ast.type.PrimitiveType;
import org.checkerframework.com.github.javaparser.ast.type.ReferenceType;
import org.checkerframework.com.github.javaparser.ast.type.Type;
import org.checkerframework.com.github.javaparser.ast.type.TypeParameter;
import org.checkerframework.com.github.javaparser.ast.type.VoidType;
import org.checkerframework.com.github.javaparser.ast.type.WildcardType;
import org.checkerframework.com.github.javaparser.ast.visitor.GenericVisitorAdapter;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.PluginUtil;
import scenelib.annotations.Annotation;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.DefException;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.io.IndexFileParser;
import scenelib.annotations.io.IndexFileWriter;

public class ToIndexFileConverter
extends GenericVisitorAdapter<Void, AElement> {
    private static Pattern importPattern = Pattern.compile("\\bimport *+((?:[^.]*+[.] *+)*+[^ ]*) *+;");
    private final String pkgName;
    private final List<String> imports;
    private final AScene scene;

    public ToIndexFileConverter(PackageDeclaration pkgDecl, List<ImportDeclaration> importDecls, AScene scene) {
        this.scene = scene;
        String string = this.pkgName = pkgDecl == null ? "" : pkgDecl.getNameAsString();
        if (importDecls == null) {
            this.imports = Collections.emptyList();
        } else {
            ArrayList<String> imps = new ArrayList<String>(importDecls.size());
            for (ImportDeclaration decl : importDecls) {
                String s2;
                Matcher m3;
                if (decl.isStatic() || !(m3 = importPattern.matcher(decl.toString())).find() || (s2 = m3.group(1)) == null) continue;
                imps.add(s2);
            }
            imps.trimToSize();
            this.imports = Collections.unmodifiableList(imps);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java ToIndexFileConverter myfile.jaif [stubfile...]");
            System.err.println("(myfile.jaif contains needed annotation definitions)");
            System.exit(1);
        }
        AScene scene = new AScene();
        try {
            IndexFileParser.parseFile(args[0], scene);
            if (args.length == 1) {
                ToIndexFileConverter.convert(scene, System.in, System.out);
                return;
            }
            for (int i = 1; i < args.length; ++i) {
                String f0 = args[i];
                String f1 = (f0.endsWith(".astub") ? f0.substring(0, f0.length() - 6) : f0) + ".jaif";
                try (FileInputStream in = new FileInputStream(f0);
                     FileOutputStream out = new FileOutputStream(f1);){
                    ToIndexFileConverter.convert(new AScene(scene), in, out);
                    continue;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void convert(AScene scene, InputStream in, OutputStream out) throws IOException, DefException, ParseException {
        StubUnit iu;
        try {
            iu = StaticJavaParser.parseStubUnit(in);
        }
        catch (ParseProblemException e) {
            Object iu2 = null;
            throw new BugInCF("ToIndexFileConverter: exception from JavaParser.parseStubUnit for InputStream." + System.lineSeparator() + "Problem message with problems encountered: " + e.getMessage());
        }
        ToIndexFileConverter.extractScene(iu, scene);
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));){
            IndexFileWriter.write(scene, w);
        }
    }

    private static void extractScene(StubUnit iu, AScene scene) {
        for (CompilationUnit cu : iu.getCompilationUnits()) {
            NodeList<TypeDeclaration<?>> typeDecls = cu.getTypes();
            if (typeDecls == null || !cu.getPackageDeclaration().isPresent()) continue;
            NodeList<ImportDeclaration> impDecls = cu.getImports();
            PackageDeclaration pkgDecl = cu.getPackageDeclaration().get();
            for (TypeDeclaration<?> typeDecl : typeDecls) {
                ToIndexFileConverter converter = new ToIndexFileConverter(pkgDecl, impDecls, scene);
                String pkgName = converter.pkgName;
                String name = typeDecl.getNameAsString();
                if (!pkgName.isEmpty()) {
                    name = pkgName + "." + name;
                }
                typeDecl.accept(converter, (AElement)scene.classes.getVivify(name));
            }
        }
    }

    private static Annotation extractAnnotation(AnnotationExpr expr) {
        String exprName = expr.toString().substring(1);
        if (exprName.contains("+")) {
            return null;
        }
        AnnotationDef def = new AnnotationDef(exprName, "ToIndexFileConverter.extractAnnotation(" + expr + ")");
        def.setFieldTypes(Collections.emptyMap());
        return new Annotation(def, Collections.emptyMap());
    }

    @Override
    public Void visit(AnnotationDeclaration decl, AElement elem) {
        return null;
    }

    @Override
    public Void visit(BlockStmt stmt, AElement elem) {
        return null;
    }

    @Override
    public Void visit(ClassOrInterfaceDeclaration decl, AElement elem) {
        this.visitDecl(decl, (ADeclaration)elem);
        return (Void)super.visit(decl, elem);
    }

    @Override
    public Void visit(ConstructorDeclaration decl, AElement elem) {
        NodeList<Parameter> params = decl.getParameters();
        NodeList<AnnotationExpr> rcvrAnnos = decl.getAnnotations();
        BlockStmt body = decl.getBody();
        StringBuilder sb = new StringBuilder("<init>(");
        AClass clazz = (AClass)elem;
        if (params != null) {
            for (Parameter param : params) {
                Type ptype = param.getType();
                sb.append(this.getJVML(ptype));
            }
        }
        sb.append(")V");
        AMethod method = clazz.methods.getVivify(sb.toString());
        this.visitDecl(decl, method);
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Parameter param;
                param = (Parameter)params.get(i);
                AField field = method.parameters.getVivify(i);
                this.visitType(param.getType(), field.type);
            }
        }
        if (rcvrAnnos != null) {
            for (AnnotationExpr expr : rcvrAnnos) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                method.receiver.tlAnnotationsHere.add(anno);
            }
        }
        return body == null ? null : body.accept(this, method);
    }

    @Override
    public Void visit(EnumConstantDeclaration decl, AElement elem) {
        AField field = ((AClass)elem).fields.getVivify(decl.getNameAsString());
        this.visitDecl(decl, field);
        return (Void)super.visit(decl, field);
    }

    @Override
    public Void visit(EnumDeclaration decl, AElement elem) {
        this.visitDecl(decl, (ADeclaration)elem);
        return (Void)super.visit(decl, elem);
    }

    @Override
    public Void visit(FieldDeclaration decl, AElement elem) {
        for (VariableDeclarator v : decl.getVariables()) {
            AClass clazz = (AClass)elem;
            AField field = clazz.fields.getVivify(v.getNameAsString());
            this.visitDecl(decl, field);
            this.visitType(decl.getCommonType(), field.type);
        }
        return null;
    }

    @Override
    public Void visit(InitializerDeclaration decl, AElement elem) {
        BlockStmt block = decl.getBody();
        AClass clazz = (AClass)elem;
        block.accept(this, (AElement)clazz.methods.getVivify(decl.isStatic() ? "<clinit>" : "<init>"));
        return null;
    }

    @Override
    public Void visit(MethodDeclaration decl, AElement elem) {
        Type type = decl.getType();
        NodeList<Parameter> params = decl.getParameters();
        NodeList<TypeParameter> typeParams = decl.getTypeParameters();
        Optional<ReceiverParameter> rcvrParam = decl.getReceiverParameter();
        BlockStmt body = decl.getBody().orElse(null);
        StringBuilder sb = new StringBuilder(decl.getNameAsString()).append('(');
        AClass clazz = (AClass)elem;
        if (params != null) {
            for (Parameter param : params) {
                Type ptype = param.getType();
                sb.append(this.getJVML(ptype));
            }
        }
        sb.append(')').append(this.getJVML(type));
        AMethod method = clazz.methods.getVivify(sb.toString());
        this.visitDecl(decl, method);
        this.visitType(type, method.returnType);
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Parameter param;
                param = (Parameter)params.get(i);
                AField field = method.parameters.getVivify(i);
                this.visitType(param.getType(), field.type);
            }
        }
        if (rcvrParam.isPresent()) {
            for (AnnotationExpr expr : rcvrParam.get().getAnnotations()) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                method.receiver.type.tlAnnotationsHere.add(anno);
            }
        }
        if (typeParams != null) {
            for (int i = 0; i < typeParams.size(); ++i) {
                TypeParameter typeParam = (TypeParameter)typeParams.get(i);
                NodeList<ClassOrInterfaceType> bounds = typeParam.getTypeBound();
                if (bounds == null) continue;
                for (int j = 0; j < bounds.size(); ++j) {
                    ClassOrInterfaceType bound = (ClassOrInterfaceType)bounds.get(j);
                    BoundLocation loc = new BoundLocation(i, j);
                    bound.accept(this, (AElement)method.bounds.getVivify(loc));
                }
            }
        }
        return body == null ? null : body.accept(this, method);
    }

    @Override
    public Void visit(ObjectCreationExpr expr, AElement elem) {
        ClassOrInterfaceType type = expr.getType();
        AClass clazz = this.scene.classes.getVivify(type.getNameAsString());
        Expression scope = expr.getScope().orElse(null);
        List typeArgs = expr.getTypeArguments().orElse(null);
        NodeList<Expression> args = expr.getArguments();
        NodeList bodyDecls = expr.getAnonymousClassBody().orElse(null);
        if (scope != null) {
            scope.accept(this, elem);
        }
        if (args != null) {
            for (Expression arg : args) {
                arg.accept(this, elem);
            }
        }
        if (typeArgs != null) {
            for (Type typeArg : typeArgs) {
                typeArg.accept(this, elem);
            }
        }
        type.accept(this, clazz);
        if (bodyDecls != null) {
            for (BodyDeclaration decl : bodyDecls) {
                decl.accept(this, clazz);
            }
        }
        return null;
    }

    @Override
    public Void visit(VariableDeclarationExpr expr, AElement elem) {
        NodeList<AnnotationExpr> annos = expr.getAnnotations();
        AMethod method = (AMethod)elem;
        NodeList<VariableDeclarator> varDecls = expr.getVariables();
        for (int i = 0; i < varDecls.size(); ++i) {
            VariableDeclarator decl = (VariableDeclarator)varDecls.get(i);
            LocalLocation loc = new LocalLocation(decl.getNameAsString(), i);
            AField field = method.body.locals.getVivify(loc);
            this.visitType(expr.getCommonType(), field.type);
            if (annos == null) continue;
            for (AnnotationExpr annoExpr : annos) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(annoExpr);
                field.tlAnnotationsHere.add(anno);
            }
        }
        return null;
    }

    private Void visitDecl(BodyDeclaration<?> decl, ADeclaration elem) {
        NodeList<AnnotationExpr> annoExprs = decl.getAnnotations();
        if (annoExprs != null) {
            for (AnnotationExpr annoExpr : annoExprs) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(annoExpr);
                elem.tlAnnotationsHere.add(anno);
            }
        }
        return null;
    }

    private Void visitType(Type type, ATypeElement elem) {
        NodeList<AnnotationExpr> exprs = type.getAnnotations();
        if (exprs != null) {
            for (AnnotationExpr expr : exprs) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                if (anno == null) continue;
                elem.tlAnnotationsHere.add(anno);
            }
        }
        ToIndexFileConverter.visitInnerTypes(type, elem);
        return null;
    }

    private static Void visitInnerTypes(Type type, final ATypeElement elem) {
        return type.accept(new GenericVisitorAdapter<Void, InnerTypeLocation>(){

            @Override
            public Void visit(ClassOrInterfaceType type, InnerTypeLocation loc) {
                if (type.getTypeArguments().isPresent()) {
                    List typeArgs = type.getTypeArguments().get();
                    for (int i = 0; i < typeArgs.size(); ++i) {
                        Type inner = (Type)typeArgs.get(i);
                        InnerTypeLocation ext = this.extendedTypePath(loc, 3, i);
                        this.visitInnerType(inner, ext);
                    }
                }
                return null;
            }

            @Override
            public Void visit(ArrayType type, InnerTypeLocation loc) {
                InnerTypeLocation ext = loc;
                int n = type.getArrayLevel();
                Type currentType = type;
                for (int i = 0; i < n; ++i) {
                    ext = this.extendedTypePath(ext, 1, 0);
                    for (AnnotationExpr expr : currentType.getAnnotations()) {
                        ATypeElement typeElem = elem.innerTypes.getVivify(ext);
                        Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                        typeElem.tlAnnotationsHere.add(anno);
                    }
                    currentType = currentType.getComponentType();
                }
                return null;
            }

            @Override
            public Void visit(WildcardType type, InnerTypeLocation loc) {
                InnerTypeLocation ext;
                ReferenceType lower = type.getExtendedType().orElse(null);
                ReferenceType upper = type.getSuperType().orElse(null);
                if (lower != null) {
                    ext = this.extendedTypePath(loc, 2, 0);
                    this.visitInnerType(lower, ext);
                }
                if (upper != null) {
                    ext = this.extendedTypePath(loc, 2, 0);
                    this.visitInnerType(upper, ext);
                }
                return null;
            }

            private void visitInnerType(Type type, InnerTypeLocation loc) {
                ATypeElement typeElem = elem.innerTypes.getVivify(loc);
                for (AnnotationExpr expr : type.getAnnotations()) {
                    Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                    typeElem.tlAnnotationsHere.add(anno);
                    type.accept(this, loc);
                }
            }

            private InnerTypeLocation extendedTypePath(InnerTypeLocation loc, int tag, int arg) {
                ArrayList<TypeAnnotationPosition.TypePathEntry> path = new ArrayList<TypeAnnotationPosition.TypePathEntry>(loc.location.size() + 1);
                path.addAll(loc.location);
                path.add(TypeAnnotationPosition.TypePathEntry.fromBinary(tag, arg));
                return new InnerTypeLocation(path);
            }
        }, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
    }

    private String getJVML(Type type) {
        return type.accept(new GenericVisitorAdapter<String, Void>(){

            @Override
            public String visit(ClassOrInterfaceType type, Void v) {
                String typeName = type.getNameAsString();
                String name = ToIndexFileConverter.this.resolve(typeName);
                if (name == null) {
                    return "L" + typeName + ";";
                }
                return "L" + PluginUtil.join("/", name.split("\\.")) + ";";
            }

            @Override
            public String visit(PrimitiveType type, Void v) {
                switch (type.getType()) {
                    case BOOLEAN: {
                        return "Z";
                    }
                    case BYTE: {
                        return "B";
                    }
                    case CHAR: {
                        return "C";
                    }
                    case DOUBLE: {
                        return "D";
                    }
                    case FLOAT: {
                        return "F";
                    }
                    case INT: {
                        return "I";
                    }
                    case LONG: {
                        return "J";
                    }
                    case SHORT: {
                        return "S";
                    }
                }
                throw new BugInCF("unknown primitive type " + type);
            }

            @Override
            public String visit(ArrayType type, Void v) {
                String typeName = type.getElementType().accept(this, null);
                StringBuilder sb = new StringBuilder();
                int n = type.getArrayLevel();
                for (int i = 0; i < n; ++i) {
                    sb.append("[");
                }
                sb.append(typeName);
                return sb.toString();
            }

            @Override
            public String visit(VoidType type, Void v) {
                return "V";
            }

            @Override
            public String visit(WildcardType type, Void v) {
                return type.getSuperType().get().accept(this, null);
            }
        }, null);
    }

    private String resolve(String className) {
        String qualifiedName;
        Class<?> resolved = null;
        if (this.pkgName.isEmpty()) {
            qualifiedName = className;
            resolved = ToIndexFileConverter.loadClass(qualifiedName);
            if (resolved == null) {
                qualifiedName = "java.lang." + className;
                resolved = ToIndexFileConverter.loadClass(qualifiedName);
            }
        } else {
            qualifiedName = this.pkgName + "." + className;
            resolved = ToIndexFileConverter.loadClass(qualifiedName);
            if (resolved == null) {
                qualifiedName = className;
                resolved = ToIndexFileConverter.loadClass(qualifiedName);
            }
        }
        if (resolved == null) {
            for (String declName : this.imports) {
                qualifiedName = ToIndexFileConverter.mergeImport(declName, className);
                if (qualifiedName == null) continue;
                return qualifiedName;
            }
            return className;
        }
        return qualifiedName;
    }

    private static String mergeImport(String importName, String className) {
        if (importName.isEmpty() || importName.equals(className)) {
            return className;
        }
        String[] importSplit = importName.split("\\.");
        String[] classSplit = className.split("\\.");
        String importEnd = importSplit[importSplit.length - 1];
        if ("*".equals(importEnd)) {
            return importName.substring(0, importName.length() - 1) + className;
        }
        int i = importSplit.length;
        int n = i - classSplit.length;
        while (--i >= n) {
            if (classSplit[i - n].equals(importSplit[i])) continue;
            return null;
        }
        return importName;
    }

    private static Class<?> loadClass(String className) {
        assert (className != null);
        try {
            return Class.forName(className, false, null);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

