/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.framework.qual.UpperBoundFor;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.TypesUtils;

public class QualifierUpperBounds {
    private final Map<TypeKind, Set<AnnotationMirror>> typeKinds;
    private final Map<String, Set<AnnotationMirror>> types;
    private final QualifierHierarchy qualHierarchy;
    private final AnnotatedTypeFactory atypeFactory;

    public QualifierUpperBounds(AnnotatedTypeFactory typeFactory) {
        this.atypeFactory = typeFactory;
        this.typeKinds = new EnumMap<TypeKind, Set<AnnotationMirror>>(TypeKind.class);
        this.types = new HashMap<String, Set<AnnotationMirror>>();
        this.qualHierarchy = typeFactory.getQualifierHierarchy();
        Set<Class<? extends Annotation>> quals = typeFactory.getSupportedTypeQualifiers();
        for (Class<? extends Annotation> qual : quals) {
            UpperBoundFor upperBoundFor = qual.getAnnotation(UpperBoundFor.class);
            if (upperBoundFor == null) continue;
            AnnotationMirror theQual = AnnotationBuilder.fromClass(typeFactory.getElementUtils(), qual);
            for (org.checkerframework.framework.qual.TypeKind typeKind : upperBoundFor.typeKinds()) {
                TypeKind mappedTk = this.mapTypeKinds(typeKind);
                this.addTypeKind(mappedTk, theQual);
            }
            for (Class<?> clazz : upperBoundFor.types()) {
                this.addType(clazz, theQual);
            }
        }
    }

    private TypeKind mapTypeKinds(org.checkerframework.framework.qual.TypeKind typeKind) {
        return TypeKind.valueOf(typeKind.name());
    }

    public void addTypeKind(TypeKind typeKind, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.typeKinds, typeKind, theQual);
        if (!res) {
            throw new BugInCF("QualifierUpperBounds: invalid update of typeKinds $s at %s with %s.", new Object[]{this.typeKinds, typeKind, theQual});
        }
    }

    public void addType(Class<?> type, AnnotationMirror theQual) {
        String typeNameString = type.getCanonicalName();
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.types, typeNameString, theQual);
        if (!res) {
            throw new BugInCF("QualifierUpperBounds: invalid update of types $s at %s with %s.", this.types, type, theQual);
        }
    }

    protected Set<AnnotationMirror> getBoundQualifiers(TypeMirror type) {
        Set<AnnotationMirror> fnd;
        String qname;
        AnnotationMirrorSet bounds = new AnnotationMirrorSet();
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            bounds.addAll((Collection<? extends AnnotationMirror>)this.atypeFactory.fromElement((TypeElement)declaredType.asElement()).getAnnotations());
            qname = TypesUtils.getQualifiedName(declaredType).toString();
        } else {
            qname = type.getKind().isPrimitive() ? type.toString() : null;
        }
        if (qname != null && this.types.containsKey(qname)) {
            fnd = this.types.get(qname);
            this.addMissingAnnotations(bounds, fnd);
        }
        if (this.typeKinds.containsKey((Object)type.getKind())) {
            fnd = this.typeKinds.get((Object)type.getKind());
            this.addMissingAnnotations(bounds, fnd);
        }
        this.addMissingAnnotations(bounds, this.atypeFactory.getDefaultTypeDeclarationBounds());
        return bounds;
    }

    private void addMissingAnnotations(AnnotationMirrorSet annos, Set<? extends AnnotationMirror> missing) {
        for (AnnotationMirror annotationMirror : missing) {
            if (this.atypeFactory.getQualifierHierarchy().findAnnotationInSameHierarchy(annos, annotationMirror) != null) continue;
            annos.add(annotationMirror);
        }
    }
}

