/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.com.github.javaparser.ParseProblemException;
import org.checkerframework.com.github.javaparser.StaticJavaParser;
import org.checkerframework.com.github.javaparser.ast.ArrayCreationLevel;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.expr.ArrayAccessExpr;
import org.checkerframework.com.github.javaparser.ast.expr.ArrayCreationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.CharLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.ClassExpr;
import org.checkerframework.com.github.javaparser.ast.expr.DoubleLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.EnclosedExpr;
import org.checkerframework.com.github.javaparser.ast.expr.Expression;
import org.checkerframework.com.github.javaparser.ast.expr.FieldAccessExpr;
import org.checkerframework.com.github.javaparser.ast.expr.IntegerLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.LongLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.MethodCallExpr;
import org.checkerframework.com.github.javaparser.ast.expr.NameExpr;
import org.checkerframework.com.github.javaparser.ast.expr.NullLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.StringLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.SuperExpr;
import org.checkerframework.com.github.javaparser.ast.expr.ThisExpr;
import org.checkerframework.com.github.javaparser.ast.visitor.GenericVisitorWithDefaults;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Resolver;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;

public class FlowExpressionParseUtil {
    protected static final String PARAMETER_REGEX = "#([1-9][0-9]*)";
    protected static final Pattern UNANCHORED_PARAMETER_PATTERN = Pattern.compile("#([1-9][0-9]*)");
    private static final String PARMETER_REPLACEMENT = "_param_";
    private static final int PARAMETER_REPLACEMENT_LENGTH = "_param_".length();

    public static FlowExpressions.Receiver parse(String expression, FlowExpressionContext context, TreePath localScope, boolean useLocalScope) throws FlowExpressionParseException {
        FlowExpressions.Receiver result;
        Object expr;
        context = context.copyAndSetUseLocalScope(useLocalScope);
        ProcessingEnvironment env = context.checkerContext.getProcessingEnvironment();
        try {
            expr = StaticJavaParser.parseExpression(FlowExpressionParseUtil.replaceParameterSyntax(expression));
        }
        catch (ParseProblemException e) {
            throw FlowExpressionParseUtil.constructParserException(expression, "is an invalid expression");
        }
        try {
            result = expr.accept(new ExpressionToReceiverVisitor(localScope, env), (FlowExpressionContext)context);
        }
        catch (ParseRuntimeException e) {
            throw e.getCheckedException();
        }
        if (result instanceof FlowExpressions.ClassName && !expression.endsWith("class")) {
            throw FlowExpressionParseUtil.constructParserException(expression, "a class name cannot terminate a flow expression string");
        }
        return result;
    }

    private static String replaceParameterSyntax(String expression) {
        String updatedExpression = expression;
        for (Integer integer : FlowExpressionParseUtil.parameterIndices(expression)) {
            updatedExpression = updatedExpression.replaceAll("#" + integer, PARMETER_REPLACEMENT + integer);
        }
        return updatedExpression;
    }

    public static List<Integer> parameterIndices(String s2) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Matcher matcher = UNANCHORED_PARAMETER_PATTERN.matcher(s2);
        while (matcher.find()) {
            int idx = Integer.parseInt(matcher.group(1));
            result.add(idx);
        }
        return result;
    }

    private static TypeMirror getTypeOfEnclosingClass(DeclaredType type) {
        if (type instanceof Type.ClassType) {
            Symbol sym = ((Type.ClassType)type).tsym.owner;
            if (sym == null) {
                return Type.noType;
            }
            Symbol.ClassSymbol cs = sym.enclClass();
            if (cs == null) {
                return Type.noType;
            }
            return cs.asType();
        }
        return type.getEnclosingType();
    }

    public static FlowExpressions.Receiver internalReprOfVariable(AnnotatedTypeFactory provider, VariableTree tree) throws FlowExpressionParseException {
        VariableElement elt = TreeUtils.elementFromDeclaration(tree);
        if (elt.getKind() == ElementKind.LOCAL_VARIABLE || elt.getKind() == ElementKind.RESOURCE_VARIABLE || elt.getKind() == ElementKind.EXCEPTION_PARAMETER || elt.getKind() == ElementKind.PARAMETER) {
            return new FlowExpressions.LocalVariable(elt);
        }
        FlowExpressions.Receiver receiverF = FlowExpressions.internalReprOfImplicitReceiver(elt);
        FlowExpressionContext context = new FlowExpressionContext(receiverF, null, provider.getContext());
        return FlowExpressionParseUtil.parse(tree.getName().toString(), context, provider.getPath(tree), false);
    }

    private static FlowExpressionParseException constructParserException(String expr, String explanation) {
        if (expr == null) {
            throw new Error("Must have an expression.");
        }
        if (explanation == null) {
            throw new Error("Must have an explanation.");
        }
        return new FlowExpressionParseException((Throwable)null, "flowexpr.parse.error", "Invalid '" + expr + "' because " + explanation);
    }

    private static class ParseRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 2L;
        private final FlowExpressionParseException exception;

        private ParseRuntimeException(FlowExpressionParseException exception) {
            this.exception = exception;
        }

        private FlowExpressionParseException getCheckedException() {
            return this.exception;
        }
    }

    public static class FlowExpressionParseException
    extends Exception {
        private static final long serialVersionUID = 2L;
        private @CompilerMessageKey String errorKey;
        public final Object[] args;

        public FlowExpressionParseException(@CompilerMessageKey String errorKey, Object ... args) {
            this(null, errorKey, args);
        }

        public FlowExpressionParseException(Throwable cause, @CompilerMessageKey String errorKey, Object ... args) {
            super(cause);
            this.errorKey = errorKey;
            this.args = args;
        }

        @Override
        public String getMessage() {
            return this.errorKey + " " + Arrays.toString(this.args);
        }

        public Result getResult() {
            return Result.failure(this.errorKey, this.args);
        }

        public boolean isFlowParseError() {
            return this.errorKey.endsWith("flowexpr.parse.error");
        }
    }

    public static class FlowExpressionContext {
        public final FlowExpressions.Receiver receiver;
        public final List<FlowExpressions.Receiver> arguments;
        public final FlowExpressions.Receiver outerReceiver;
        public final BaseContext checkerContext;
        public final boolean parsingMember;
        public final boolean useLocalScope;

        public FlowExpressionContext(FlowExpressions.Receiver receiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext) {
            this(receiver, receiver, arguments, checkerContext);
        }

        private FlowExpressionContext(FlowExpressions.Receiver receiver, FlowExpressions.Receiver outerReceiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext) {
            this(receiver, outerReceiver, arguments, checkerContext, false, true);
        }

        private FlowExpressionContext(FlowExpressions.Receiver receiver, FlowExpressions.Receiver outerReceiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext, boolean parsingMember, boolean useLocalScope) {
            assert (checkerContext != null);
            this.receiver = receiver;
            this.arguments = arguments;
            this.outerReceiver = outerReceiver;
            this.checkerContext = checkerContext;
            this.parsingMember = parsingMember;
            this.useLocalScope = useLocalScope;
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, Tree enclosingTree, BaseContext checkerContext) {
            return FlowExpressionContext.buildContextForMethodDeclaration(methodDeclaration, TreeUtils.typeOf(enclosingTree), checkerContext);
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, TypeMirror enclosingType, BaseContext checkerContext) {
            org.checkerframework.dataflow.cfg.node.Node receiver;
            if (methodDeclaration.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                TypeElement classElt = ElementUtils.enclosingClass(TreeUtils.elementFromDeclaration(methodDeclaration));
                receiver = new ClassNameNode(enclosingType, classElt);
            } else {
                receiver = new ImplicitThisLiteralNode(enclosingType);
            }
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (VariableTree variableTree : methodDeclaration.getParameters()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), new LocalVariableNode(variableTree, receiver)));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForLambda(LambdaExpressionTree lambdaTree, TreePath path, BaseContext checkerContext) {
            TypeMirror enclosingType = TreeUtils.typeOf(TreeUtils.enclosingClass(path));
            ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(enclosingType);
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (VariableTree variableTree : lambdaTree.getParameters()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), new LocalVariableNode(variableTree, receiver)));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, TreePath currentPath, BaseContext checkerContext) {
            ClassTree classTree = TreeUtils.enclosingClass(currentPath);
            return FlowExpressionContext.buildContextForMethodDeclaration(methodDeclaration, classTree, checkerContext);
        }

        public static FlowExpressionContext buildContextForClassDeclaration(ClassTree classTree, BaseContext checkerContext) {
            ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(TreeUtils.typeOf(classTree));
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForMethodUse(MethodInvocationNode methodInvocation, BaseContext checkerContext) {
            org.checkerframework.dataflow.cfg.node.Node receiver = methodInvocation.getTarget().getReceiver();
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (org.checkerframework.dataflow.cfg.node.Node arg : methodInvocation.getArguments()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), arg));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForMethodUse(MethodInvocationTree methodInvocation, BaseContext checkerContext) {
            ExpressionTree receiverTree = TreeUtils.getReceiverTree(methodInvocation);
            FlowExpressions.Receiver receiver = receiverTree == null ? FlowExpressions.internalReprOfImplicitReceiver(TreeUtils.elementFromUse(methodInvocation)) : FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiverTree);
            List<? extends ExpressionTree> args = methodInvocation.getArguments();
            ArrayList<FlowExpressions.Receiver> argReceivers = new ArrayList<FlowExpressions.Receiver>(args.size());
            for (ExpressionTree expressionTree : args) {
                argReceivers.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), expressionTree));
            }
            return new FlowExpressionContext(receiver, argReceivers, checkerContext);
        }

        public static FlowExpressionContext buildContextForNewClassUse(ObjectCreationNode n, BaseContext checkerContext) {
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), n);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (org.checkerframework.dataflow.cfg.node.Node arg : n.getArguments()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), arg));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public FlowExpressionContext copyChangeToParsingMemberOfReceiver(FlowExpressions.Receiver receiver) {
            return new FlowExpressionContext(receiver, this.outerReceiver, this.arguments, this.checkerContext, true, this.useLocalScope);
        }

        public FlowExpressionContext copyAndUseOuterReceiver() {
            return new FlowExpressionContext(this.outerReceiver, this.outerReceiver, this.arguments, this.checkerContext, false, this.useLocalScope);
        }

        public FlowExpressionContext copyAndSetUseLocalScope(boolean useLocalScope) {
            return new FlowExpressionContext(this.receiver, this.outerReceiver, this.arguments, this.checkerContext, this.parsingMember, useLocalScope);
        }
    }

    private static class ExpressionToReceiverVisitor
    extends GenericVisitorWithDefaults<FlowExpressions.Receiver, FlowExpressionContext> {
        private final TreePath path;
        private final ProcessingEnvironment env;
        private final Types types;

        ExpressionToReceiverVisitor(TreePath path, ProcessingEnvironment env) {
            this.path = path;
            this.env = env;
            this.types = env.getTypeUtils();
        }

        @Override
        public FlowExpressions.Receiver defaultAction(Node n, FlowExpressionContext context) {
            String message = "is not a supported expression";
            if (context.parsingMember) {
                message = message + " in a context with parsingMember=true";
            }
            throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(n.toString(), message));
        }

        @Override
        public FlowExpressions.Receiver visit(NullLiteralExpr expr, FlowExpressionContext context) {
            return new FlowExpressions.ValueLiteral((TypeMirror)this.types.getNullType(), (Object)null);
        }

        @Override
        public FlowExpressions.Receiver visit(IntegerLiteralExpr expr, FlowExpressionContext context) {
            return new FlowExpressions.ValueLiteral((TypeMirror)this.types.getPrimitiveType(TypeKind.INT), expr.asInt());
        }

        @Override
        public FlowExpressions.Receiver visit(LongLiteralExpr expr, FlowExpressionContext context) {
            return new FlowExpressions.ValueLiteral((TypeMirror)this.types.getPrimitiveType(TypeKind.LONG), expr.asLong());
        }

        @Override
        public FlowExpressions.Receiver visit(CharLiteralExpr expr, FlowExpressionContext context) {
            return new FlowExpressions.ValueLiteral((TypeMirror)this.types.getPrimitiveType(TypeKind.CHAR), Character.valueOf(expr.asChar()));
        }

        @Override
        public FlowExpressions.Receiver visit(DoubleLiteralExpr expr, FlowExpressionContext context) {
            return new FlowExpressions.ValueLiteral((TypeMirror)this.types.getPrimitiveType(TypeKind.DOUBLE), expr.asDouble());
        }

        @Override
        public FlowExpressions.Receiver visit(StringLiteralExpr expr, FlowExpressionContext context) {
            TypeMirror stringTM = TypesUtils.typeFromClass(String.class, this.types, this.env.getElementUtils());
            return new FlowExpressions.ValueLiteral(stringTM, expr.asString());
        }

        @Override
        public FlowExpressions.Receiver visit(ThisExpr n, FlowExpressionContext context) {
            if (context.receiver != null && !context.receiver.containsUnknown()) {
                return context.receiver;
            }
            return new FlowExpressions.ThisReference(context.receiver == null ? null : context.receiver.getType());
        }

        @Override
        public FlowExpressions.Receiver visit(SuperExpr n, FlowExpressionContext context) {
            List<? extends TypeMirror> superTypes = this.types.directSupertypes(context.receiver.getType());
            for (TypeMirror typeMirror : superTypes) {
                Type.ClassType tt;
                if (!(typeMirror instanceof Type.ClassType) || (tt = (Type.ClassType)typeMirror).isInterface()) continue;
                return new FlowExpressions.ThisReference(typeMirror);
            }
            throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException("super", "super class not found"));
        }

        @Override
        public FlowExpressions.Receiver visit(EnclosedExpr expr, FlowExpressionContext context) {
            return expr.getInner().accept(this, context);
        }

        @Override
        public FlowExpressions.Receiver visit(ArrayAccessExpr expr, FlowExpressionContext context) {
            FlowExpressions.Receiver array = expr.getName().accept(this, context);
            FlowExpressionContext contextForIndex = context.copyAndUseOuterReceiver();
            FlowExpressions.Receiver index = expr.getIndex().accept(this, contextForIndex);
            TypeMirror arrayType = array.getType();
            if (arrayType.getKind() != TypeKind.ARRAY) {
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(expr.toString(), String.format("array not an array: %s : %s", array, arrayType)));
            }
            Type componentType = ((Type.ArrayType)arrayType).getComponentType();
            return new FlowExpressions.ArrayAccess(componentType, array, index);
        }

        @Override
        public FlowExpressions.Receiver visit(NameExpr expr, FlowExpressionContext context) {
            VariableElement varElem;
            String s2 = expr.getNameAsString();
            Resolver resolver = new Resolver(this.env);
            if (!context.parsingMember && s2.startsWith(FlowExpressionParseUtil.PARMETER_REPLACEMENT)) {
                return ExpressionToReceiverVisitor.getParameterReceiver(s2, context);
            }
            if (!context.parsingMember && context.useLocalScope && (varElem = resolver.findLocalVariableOrParameterOrField(s2, this.path)) != null) {
                if (varElem.getKind() == ElementKind.FIELD) {
                    boolean isOriginalReceiver = context.receiver instanceof FlowExpressions.ThisReference;
                    return ExpressionToReceiverVisitor.getReceiverField(s2, context, isOriginalReceiver, varElem);
                }
                return new FlowExpressions.LocalVariable(varElem);
            }
            TypeMirror receiverType = context.receiver.getType();
            boolean originalReceiver = true;
            Element fieldElem = null;
            if (receiverType.getKind() == TypeKind.ARRAY && s2.equals("length")) {
                fieldElem = resolver.findField(s2, receiverType, this.path);
            }
            while (receiverType.getKind() == TypeKind.DECLARED && (fieldElem = resolver.findField(s2, receiverType, this.path)) == null) {
                receiverType = FlowExpressionParseUtil.getTypeOfEnclosingClass((DeclaredType)receiverType);
                originalReceiver = false;
            }
            if (fieldElem != null && fieldElem.getKind() == ElementKind.FIELD) {
                FlowExpressions.FieldAccess fieldAccess = (FlowExpressions.FieldAccess)ExpressionToReceiverVisitor.getReceiverField(s2, context, originalReceiver, (VariableElement)fieldElem);
                TypeElement scopeClassElement = TypesUtils.getTypeElement(fieldAccess.getReceiver().getType());
                if (!originalReceiver && !ElementUtils.isStatic(fieldElem) && ElementUtils.isStatic(scopeClassElement)) {
                    throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(s2, "a non-static field can't be referenced from a static inner class or enum"));
                }
                return fieldAccess;
            }
            Element classElem = resolver.findClass(s2, this.path);
            TypeMirror classType = ElementUtils.getType(classElem);
            if (classType != null) {
                return new FlowExpressions.ClassName(classType);
            }
            MethodTree enclMethod = TreeUtils.enclosingMethod(this.path);
            if (enclMethod != null) {
                List<? extends VariableTree> params = enclMethod.getParameters();
                for (int i = 0; i < params.size(); ++i) {
                    if (!params.get(i).getName().contentEquals(s2)) continue;
                    throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(s2, String.format("Use \"#%d\" rather than \"%s\"", i + 1, s2)));
                }
            }
            throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(s2, "identifier not found"));
        }

        @Override
        public FlowExpressions.Receiver visit(MethodCallExpr expr, FlowExpressionContext context) {
            ExecutableElement executableElement;
            String s2 = expr.toString();
            Resolver resolver = new Resolver(this.env);
            if (expr.getScope().isPresent()) {
                FlowExpressions.Receiver receiver = expr.getScope().get().accept(this, context);
                context = context.copyChangeToParsingMemberOfReceiver(receiver);
                expr = expr.removeScope();
            }
            String methodName = expr.getNameAsString();
            ArrayList<FlowExpressions.Receiver> arguments = new ArrayList<FlowExpressions.Receiver>();
            for (Expression expression : expr.getArguments()) {
                arguments.add(expression.accept(this, context.copyAndUseOuterReceiver()));
            }
            ArrayList<TypeMirror> argumentTypes = new ArrayList<TypeMirror>();
            for (FlowExpressions.Receiver p : arguments) {
                argumentTypes.add(p.getType());
            }
            try {
                Element element = null;
                TypeMirror receiverType = context.receiver.getType();
                if (receiverType.getKind() == TypeKind.ARRAY) {
                    element = resolver.findMethod(methodName, receiverType, this.path, argumentTypes);
                }
                while (receiverType.getKind() == TypeKind.DECLARED && (element = resolver.findMethod(methodName, receiverType, this.path, argumentTypes)).getKind() != ElementKind.METHOD) {
                    receiverType = FlowExpressionParseUtil.getTypeOfEnclosingClass((DeclaredType)receiverType);
                }
                if (element == null) {
                    throw FlowExpressionParseUtil.constructParserException(s2, "element==null");
                }
                if (element.getKind() != ElementKind.METHOD) {
                    throw FlowExpressionParseUtil.constructParserException(s2, "element.getKind()==" + (Object)((Object)element.getKind()));
                }
                executableElement = (ExecutableElement)element;
                for (int i = 0; i < arguments.size(); ++i) {
                    VariableElement parameter = executableElement.getParameters().get(i);
                    TypeMirror parameterType = parameter.asType();
                    FlowExpressions.Receiver argument = (FlowExpressions.Receiver)arguments.get(i);
                    TypeMirror argumentType = argument.getType();
                    if (!TypesUtils.isBoxedPrimitive(parameterType) || !TypesUtils.isPrimitive(argumentType)) continue;
                    Symbol.MethodSymbol valueOfMethod = TreeBuilder.getValueOfMethod(this.env, parameterType);
                    ArrayList<FlowExpressions.Receiver> p = new ArrayList<FlowExpressions.Receiver>();
                    p.add(argument);
                    FlowExpressions.MethodCall boxedParam = new FlowExpressions.MethodCall(parameterType, valueOfMethod, new FlowExpressions.ClassName(parameterType), p);
                    arguments.set(i, boxedParam);
                }
            }
            catch (Throwable t) {
                if (t.getMessage() == null) {
                    throw new Error("no detail message in " + t.getClass(), t);
                }
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(s2, t.getMessage()));
            }
            if (ElementUtils.isStatic(executableElement)) {
                Element classElem = executableElement.getEnclosingElement();
                FlowExpressions.ClassName staticClassReceiver = new FlowExpressions.ClassName(ElementUtils.getType(classElem));
                return new FlowExpressions.MethodCall(ElementUtils.getType(executableElement), executableElement, staticClassReceiver, arguments);
            }
            if (context.receiver instanceof FlowExpressions.ClassName) {
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(s2, "a non-static method call cannot have a class name as a receiver"));
            }
            TypeMirror methodType = TypesUtils.substituteMethodReturnType(executableElement, context.receiver.getType(), this.env);
            return new FlowExpressions.MethodCall(methodType, executableElement, context.receiver, arguments);
        }

        @Override
        public FlowExpressions.Receiver visit(FieldAccessExpr expr, FlowExpressionContext context) {
            Resolver resolver = new Resolver(this.env);
            Symbol.PackageSymbol packageSymbol = resolver.findPackage(expr.getScope().toString(), this.path);
            if (packageSymbol != null) {
                Symbol.ClassSymbol classSymbol = resolver.findClassInPackage(expr.getNameAsString(), packageSymbol, this.path);
                if (classSymbol != null) {
                    return new FlowExpressions.ClassName(classSymbol.asType());
                }
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(expr.toString(), "could not find class " + expr.getNameAsString() + " inside " + expr.getScope().toString()));
            }
            FlowExpressions.Receiver receiver = expr.getScope().accept(this, context);
            FlowExpressionContext newContext = context.copyChangeToParsingMemberOfReceiver(receiver);
            return this.visit(expr.getNameAsExpression(), newContext);
        }

        @Override
        public FlowExpressions.Receiver visit(ClassExpr expr, FlowExpressionContext context) {
            TypeMirror result = this.convertTypeToTypeMirror(expr.getType(), context);
            if (result == null) {
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(expr.toString(), "is an unparsable class literal"));
            }
            return new FlowExpressions.ClassName(result);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public FlowExpressions.Receiver visit(ArrayCreationExpr expr, FlowExpressionContext context) {
            void var5_9;
            TypeMirror typeMirror;
            ArrayList<FlowExpressions.Receiver> dimensions = new ArrayList<FlowExpressions.Receiver>();
            for (ArrayCreationLevel arrayCreationLevel : expr.getLevels()) {
                if (arrayCreationLevel.getDimension().isPresent()) {
                    dimensions.add(arrayCreationLevel.getDimension().get().accept(this, context));
                    continue;
                }
                dimensions.add(null);
            }
            ArrayList<FlowExpressions.Receiver> initializers = new ArrayList<FlowExpressions.Receiver>();
            if (expr.getInitializer().isPresent()) {
                for (Expression initializer : expr.getInitializer().get().getValues()) {
                    initializers.add(initializer.accept(this, context));
                }
            }
            if ((typeMirror = this.convertTypeToTypeMirror(expr.getElementType(), context)) == null) {
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(expr.getElementType().asString(), "type not parsable"));
            }
            for (int i = 0; i < dimensions.size(); ++i) {
                ArrayType arrayType = TypesUtils.createArrayType((TypeMirror)var5_9, this.env.getTypeUtils());
            }
            return new FlowExpressions.ArrayCreation((TypeMirror)var5_9, dimensions, initializers);
        }

        private @Nullable TypeMirror convertTypeToTypeMirror(org.checkerframework.com.github.javaparser.ast.type.Type type, FlowExpressionContext context) {
            if (type.isClassOrInterfaceType()) {
                return StaticJavaParser.parseExpression(type.asString()).accept(this, (FlowExpressionContext)context).getType();
            }
            if (type.isPrimitiveType()) {
                switch (type.asPrimitiveType().getType()) {
                    case BOOLEAN: {
                        return this.types.getPrimitiveType(TypeKind.BOOLEAN);
                    }
                    case BYTE: {
                        return this.types.getPrimitiveType(TypeKind.BYTE);
                    }
                    case SHORT: {
                        return this.types.getPrimitiveType(TypeKind.SHORT);
                    }
                    case INT: {
                        return this.types.getPrimitiveType(TypeKind.INT);
                    }
                    case CHAR: {
                        return this.types.getPrimitiveType(TypeKind.CHAR);
                    }
                    case FLOAT: {
                        return this.types.getPrimitiveType(TypeKind.FLOAT);
                    }
                    case LONG: {
                        return this.types.getPrimitiveType(TypeKind.LONG);
                    }
                    case DOUBLE: {
                        return this.types.getPrimitiveType(TypeKind.DOUBLE);
                    }
                }
            } else {
                if (type.isVoidType()) {
                    return this.types.getNoType(TypeKind.VOID);
                }
                if (type.isArrayType()) {
                    return this.types.getArrayType(this.convertTypeToTypeMirror(type.asArrayType().getComponentType(), context));
                }
            }
            return null;
        }

        private static FlowExpressions.Receiver getReceiverField(String s2, FlowExpressionContext context, boolean originalReceiver, VariableElement fieldElem) {
            TypeMirror receiverType = context.receiver.getType();
            TypeMirror fieldType = ElementUtils.getType(fieldElem);
            if (ElementUtils.isStatic(fieldElem)) {
                Element classElem = fieldElem.getEnclosingElement();
                FlowExpressions.ClassName staticClassReceiver = new FlowExpressions.ClassName(ElementUtils.getType(classElem));
                return new FlowExpressions.FieldAccess(staticClassReceiver, fieldType, fieldElem);
            }
            FlowExpressions.Receiver locationOfField = originalReceiver ? context.receiver : FlowExpressions.internalReprOf(context.checkerContext.getAnnotationProvider(), new ImplicitThisLiteralNode(receiverType));
            if (locationOfField instanceof FlowExpressions.ClassName) {
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(s2, "a non-static field cannot have a class name as a receiver."));
            }
            return new FlowExpressions.FieldAccess(locationOfField, fieldType, fieldElem);
        }

        private static FlowExpressions.Receiver getParameterReceiver(String s2, FlowExpressionContext context) {
            if (context.arguments == null) {
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(s2, "no parameter found"));
            }
            int idx = Integer.parseInt(s2.substring(PARAMETER_REPLACEMENT_LENGTH));
            if (idx == 0) {
                throw new ParseRuntimeException(FlowExpressionParseUtil.constructParserException(s2, "one should use \"this\" for the receiver or \"#1\" for the first formal parameter"));
            }
            if (idx > context.arguments.size()) {
                throw new ParseRuntimeException(new FlowExpressionParseException("flowexpr.parse.index.too.big", Integer.toString(idx)));
            }
            return context.arguments.get(idx - 1);
        }
    }
}

