/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.ElementAnnotationApplier;
import org.checkerframework.framework.util.element.ElementAnnotationUtil;
import org.checkerframework.framework.util.element.IndexedElementAnnotationApplier;
import org.checkerframework.framework.util.element.TargetedElementAnnotationApplier;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.Pair;

public class ParamApplier
extends IndexedElementAnnotationApplier {
    public static final int RECEIVER_PARAM_INDEX = Integer.MIN_VALUE;
    private final Symbol.MethodSymbol enclosingMethod;
    private final boolean isLambdaParam;
    private final Integer lambdaParamIndex;
    private final LambdaExpressionTree lambdaTree;

    public static void apply(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        new ParamApplier(type, element, typeFactory).extractAndApply();
    }

    public static boolean accepts(AnnotatedTypeMirror type, Element element) {
        return element.getKind() == ElementKind.PARAMETER;
    }

    ParamApplier(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        super(type, element);
        this.enclosingMethod = ParamApplier.getParentMethod(element);
        if (this.enclosingMethod.getKind() != ElementKind.INSTANCE_INIT && this.enclosingMethod.getKind() != ElementKind.STATIC_INIT && ((List)this.enclosingMethod.getParameters()).contains(element)) {
            this.lambdaTree = null;
            this.isLambdaParam = false;
            this.lambdaParamIndex = null;
        } else {
            Pair<VariableTree, LambdaExpressionTree> paramToEnclosingLambda = ElementAnnotationApplier.getParamAndLambdaTree((VariableElement)element, typeFactory);
            if (paramToEnclosingLambda != null) {
                VariableTree paramDecl = (VariableTree)paramToEnclosingLambda.first;
                this.lambdaTree = (LambdaExpressionTree)paramToEnclosingLambda.second;
                this.isLambdaParam = true;
                this.lambdaParamIndex = this.lambdaTree.getParameters().indexOf(paramDecl);
            } else {
                this.lambdaTree = null;
                this.isLambdaParam = false;
                this.lambdaParamIndex = null;
            }
        }
    }

    @Override
    public int getElementIndex() {
        if (this.isLambdaParam) {
            return this.lambdaParamIndex;
        }
        if (this.isReceiver(this.element)) {
            return Integer.MIN_VALUE;
        }
        int paramIndex = ((List)this.enclosingMethod.getParameters()).indexOf(this.element);
        if (paramIndex == -1) {
            throw new BugInCF("Could not find parameter Element in parameter list. Parameter( " + this.element + " ) Parent ( " + this.enclosingMethod + " ) ");
        }
        return paramIndex;
    }

    @Override
    public int getTypeCompoundIndex(Attribute.TypeCompound anno) {
        return anno.getPosition().parameter_index;
    }

    @Override
    protected TargetType[] annotatedTargets() {
        return new TargetType[]{TargetType.METHOD_FORMAL_PARAMETER, TargetType.METHOD_RECEIVER};
    }

    @Override
    protected TargetType[] validTargets() {
        return new TargetType[]{TargetType.METHOD_FORMAL_PARAMETER, TargetType.METHOD_RETURN, TargetType.THROWS, TargetType.METHOD_TYPE_PARAMETER, TargetType.METHOD_TYPE_PARAMETER_BOUND, TargetType.LOCAL_VARIABLE, TargetType.RESOURCE_VARIABLE, TargetType.EXCEPTION_PARAMETER, TargetType.NEW, TargetType.CAST, TargetType.INSTANCEOF, TargetType.METHOD_INVOCATION_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, TargetType.METHOD_REFERENCE, TargetType.CONSTRUCTOR_REFERENCE, TargetType.METHOD_REFERENCE_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, TargetType.CLASS_EXTENDS};
    }

    @Override
    protected Iterable<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.enclosingMethod.getRawTypeAttributes();
    }

    @Override
    protected Map<TargetedElementAnnotationApplier.TargetClass, java.util.List<Attribute.TypeCompound>> sift(Iterable<Attribute.TypeCompound> typeCompounds) {
        Map<TargetedElementAnnotationApplier.TargetClass, java.util.List<Attribute.TypeCompound>> targetClassToAnnos = super.sift(typeCompounds);
        java.util.List<Attribute.TypeCompound> targeted = targetClassToAnnos.get((Object)TargetedElementAnnotationApplier.TargetClass.TARGETED);
        java.util.List<Attribute.TypeCompound> valid = targetClassToAnnos.get((Object)TargetedElementAnnotationApplier.TargetClass.VALID);
        int i = 0;
        while (i < targeted.size()) {
            JCTree.JCLambda onLambda = targeted.get((int)i).position.onLambda;
            if (onLambda == null) {
                if (!this.isLambdaParam) {
                    ++i;
                    continue;
                }
                valid.add(targeted.remove(i));
                continue;
            }
            if (onLambda.equals(this.lambdaTree)) {
                ++i;
                continue;
            }
            valid.add(targeted.remove(i));
        }
        return targetClassToAnnos;
    }

    @Override
    protected void handleTargeted(java.util.List<Attribute.TypeCompound> targeted) {
        ArrayList<Attribute.TypeCompound> formalParams = new ArrayList<Attribute.TypeCompound>();
        Map<TargetType, java.util.List<Attribute.TypeCompound>> targetToAnnos = ElementAnnotationUtil.partitionByTargetType(targeted, formalParams, TargetType.METHOD_RECEIVER);
        if (this.isReceiver(this.element)) {
            ElementAnnotationUtil.annotateViaTypeAnnoPosition(this.type, (Collection<Attribute.TypeCompound>)targetToAnnos.get((Object)TargetType.METHOD_RECEIVER));
        } else {
            ElementAnnotationUtil.annotateViaTypeAnnoPosition(this.type, formalParams);
        }
    }

    private boolean isReceiver(Element element) {
        return element.getKind() == ElementKind.PARAMETER && element.getSimpleName().contentEquals("this");
    }

    @Override
    protected boolean isAccepted() {
        return ParamApplier.accepts(this.type, this.element);
    }

    public static Symbol.MethodSymbol getParentMethod(Element methodChildElem) {
        if (!(methodChildElem.getEnclosingElement() instanceof Symbol.MethodSymbol)) {
            throw new BugInCF("Element is not a direct child of a MethodSymbol. Element ( " + methodChildElem + " parent ( " + methodChildElem.getEnclosingElement() + " ) ");
        }
        return (Symbol.MethodSymbol)methodChildElem.getEnclosingElement();
    }

    @Override
    public void extractAndApply() {
        ElementAnnotationUtil.addAnnotationsFromElement(this.type, this.element.getAnnotationMirrors());
        super.extractAndApply();
    }
}

