/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.Const;
import org.checkerframework.org.apache.bcel.classfile.AnnotationDefault;
import org.checkerframework.org.apache.bcel.classfile.AttributeReader;
import org.checkerframework.org.apache.bcel.classfile.BootstrapMethods;
import org.checkerframework.org.apache.bcel.classfile.ClassFormatException;
import org.checkerframework.org.apache.bcel.classfile.Code;
import org.checkerframework.org.apache.bcel.classfile.ConstantPool;
import org.checkerframework.org.apache.bcel.classfile.ConstantUtf8;
import org.checkerframework.org.apache.bcel.classfile.ConstantValue;
import org.checkerframework.org.apache.bcel.classfile.Deprecated;
import org.checkerframework.org.apache.bcel.classfile.EnclosingMethod;
import org.checkerframework.org.apache.bcel.classfile.ExceptionTable;
import org.checkerframework.org.apache.bcel.classfile.InnerClasses;
import org.checkerframework.org.apache.bcel.classfile.LineNumberTable;
import org.checkerframework.org.apache.bcel.classfile.LocalVariableTable;
import org.checkerframework.org.apache.bcel.classfile.LocalVariableTypeTable;
import org.checkerframework.org.apache.bcel.classfile.MethodParameters;
import org.checkerframework.org.apache.bcel.classfile.Node;
import org.checkerframework.org.apache.bcel.classfile.PMGClass;
import org.checkerframework.org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.checkerframework.org.apache.bcel.classfile.RuntimeInvisibleParameterAnnotations;
import org.checkerframework.org.apache.bcel.classfile.RuntimeVisibleAnnotations;
import org.checkerframework.org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.checkerframework.org.apache.bcel.classfile.Signature;
import org.checkerframework.org.apache.bcel.classfile.SourceFile;
import org.checkerframework.org.apache.bcel.classfile.StackMap;
import org.checkerframework.org.apache.bcel.classfile.Synthetic;
import org.checkerframework.org.apache.bcel.classfile.Unknown;
import org.checkerframework.org.apache.bcel.classfile.UnknownAttributeReader;
import org.checkerframework.org.apache.bcel.classfile.Visitor;

public abstract class Attribute
implements Cloneable,
Node {
    @java.lang.Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index;
    @java.lang.Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length;
    @java.lang.Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte tag;
    @java.lang.Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool;
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object> readers = new HashMap<String, Object>();

    protected Attribute(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte tag, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        this.tag = tag;
        this.name_index = name_index;
        this.length = length;
        this.constant_pool = constant_pool;
    }

    @Override
    public abstract void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor var1);

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.name_index);
        file.writeInt(this.length);
    }

    @java.lang.Deprecated
    public static void addAttributeReader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AttributeReader r) {
        readers.put(name, r);
    }

    public static void addAttributeReader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown UnknownAttributeReader r) {
        readers.put(name, r);
    }

    public static void removeAttributeReader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        readers.remove(name);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute readAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInputStream file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        return Attribute.readAttribute((DataInput)file, constant_pool);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute readAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        int tag = -1;
        int name_index = file.readUnsignedShort();
        ConstantUtf8 c = (ConstantUtf8)constant_pool.getConstant(name_index, (byte)1);
        String name = c.getBytes();
        int length = file.readInt();
        for (int i = 0; i < 22; i = (int)((byte)(i + 1))) {
            if (!name.equals(Const.getAttributeName(i))) continue;
            tag = i;
            break;
        }
        switch (tag) {
            case -1: {
                Object r = readers.get(name);
                if (r instanceof UnknownAttributeReader) {
                    return ((UnknownAttributeReader)r).createAttribute(name_index, length, file, constant_pool);
                }
                return new Unknown(name_index, length, file, constant_pool);
            }
            case 1: {
                return new ConstantValue(name_index, length, file, constant_pool);
            }
            case 0: {
                return new SourceFile(name_index, length, file, constant_pool);
            }
            case 2: {
                return new Code(name_index, length, file, constant_pool);
            }
            case 3: {
                return new ExceptionTable(name_index, length, file, constant_pool);
            }
            case 4: {
                return new LineNumberTable(name_index, length, file, constant_pool);
            }
            case 5: {
                return new LocalVariableTable(name_index, length, file, constant_pool);
            }
            case 6: {
                return new InnerClasses(name_index, length, file, constant_pool);
            }
            case 7: {
                return new Synthetic(name_index, length, file, constant_pool);
            }
            case 8: {
                return new Deprecated(name_index, length, file, constant_pool);
            }
            case 9: {
                return new PMGClass(name_index, length, file, constant_pool);
            }
            case 10: {
                return new Signature(name_index, length, file, constant_pool);
            }
            case 11: {
                System.err.println("Warning: Obsolete StackMap attribute ignored.");
                return new Unknown(name_index, length, file, constant_pool);
            }
            case 12: {
                return new RuntimeVisibleAnnotations(name_index, length, file, constant_pool);
            }
            case 13: {
                return new RuntimeInvisibleAnnotations(name_index, length, file, constant_pool);
            }
            case 14: {
                return new RuntimeVisibleParameterAnnotations(name_index, length, file, constant_pool);
            }
            case 15: {
                return new RuntimeInvisibleParameterAnnotations(name_index, length, file, constant_pool);
            }
            case 16: {
                return new AnnotationDefault(name_index, length, file, constant_pool);
            }
            case 17: {
                return new LocalVariableTypeTable(name_index, length, file, constant_pool);
            }
            case 18: {
                return new EnclosingMethod(name_index, length, file, constant_pool);
            }
            case 19: {
                return new StackMap(name_index, length, file, constant_pool);
            }
            case 20: {
                return new BootstrapMethods(name_index, length, file, constant_pool);
            }
            case 21: {
                return new MethodParameters(name_index, length, file, constant_pool);
            }
        }
        throw new IllegalStateException("Unrecognized attribute type tag parsed: " + tag);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return c.getBytes();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getLength() {
        return this.length;
    }

    public final void setLength(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length) {
        this.length = length;
    }

    public final void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index) {
        this.name_index = name_index;
    }

    @Pure
    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.name_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte getTag() {
        return this.tag;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        Attribute attr = null;
        try {
            attr = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
        return attr;
    }

    public abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool var1);

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return Const.getAttributeName(this.tag);
    }
}

