/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.classfile.Constant;
import org.checkerframework.org.apache.bcel.classfile.Utility;
import org.checkerframework.org.apache.bcel.classfile.Visitor;

public final class ConstantUtf8
extends Constant {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String bytes;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int considered = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hits = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int skipped = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int created = 0;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int MAX_CACHED_SIZE = Integer.getInteger("bcel.maxcached.size", 200);
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean BCEL_STATISTICS = Boolean.getBoolean("bcel.statistics");

    static void printStats() {
        System.err.println("Cache hit " + hits + "/" + considered + ", " + skipped + " skipped");
        System.err.println("Total of " + created + " ConstantUtf8 objects created");
    }

    static void clearStats() {
        created = 0;
        skipped = 0;
        considered = 0;
        hits = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 getCachedInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s2) {
        if (s2.length() > MAX_CACHED_SIZE) {
            ++skipped;
            return new ConstantUtf8(s2);
        }
        ++considered;
        Class<ConstantUtf8> clazz = ConstantUtf8.class;
        synchronized (ConstantUtf8.class) {
            ConstantUtf8 result = (ConstantUtf8)CACHE_HOLDER.CACHE.get(s2);
            if (result != null) {
                ++hits;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
            result = new ConstantUtf8(s2);
            CACHE_HOLDER.CACHE.put(s2, result);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s2) {
        return new ConstantUtf8(s2);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return ConstantUtf8.getInstance(input.readUTF());
    }

    public ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 c) {
        this(c.getBytes());
    }

    ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super((byte)1);
        this.bytes = file.readUTF();
        ++created;
    }

    public ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String bytes) {
        super((byte)1);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null!");
        }
        this.bytes = bytes;
        ++created;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitConstantUtf8(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(super.getTag());
        file.writeUTF(this.bytes);
    }

    @Pure
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBytes() {
        return this.bytes;
    }

    @Deprecated
    public final void setBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return super.toString() + "(\"" + Utility.replace(this.bytes, "\n", "\\n") + "\")";
    }

    static {
        if (BCEL_STATISTICS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ConstantUtf8.printStats();
                }
            });
        }
    }

    private static class CACHE_HOLDER {
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int MAX_CACHE_ENTRIES = 20000;
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int INITIAL_CACHE_CAPACITY = 26666;
        private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown HashMap<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8> CACHE = new LinkedHashMap<String, ConstantUtf8>(26666, 0.75f, true){
            private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long serialVersionUID = -8506975356158971766L;

            @Override
            protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean removeEldestEntry( @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map.Entry<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8> eldest) {
                return this.size() > 20000;
            }
        };

        private CACHE_HOLDER() {
        }
    }
}

