/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.classfile.AnnotationElementValue;
import org.checkerframework.org.apache.bcel.classfile.AnnotationEntry;
import org.checkerframework.org.apache.bcel.classfile.ArrayElementValue;
import org.checkerframework.org.apache.bcel.classfile.ClassElementValue;
import org.checkerframework.org.apache.bcel.classfile.ConstantPool;
import org.checkerframework.org.apache.bcel.classfile.EnumElementValue;
import org.checkerframework.org.apache.bcel.classfile.SimpleElementValue;

public abstract class ElementValue {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte STRING = 115;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte ENUM_CONSTANT = 101;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte CLASS = 99;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte ANNOTATION = 64;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte ARRAY = 91;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte PRIMITIVE_INT = 73;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte PRIMITIVE_BYTE = 66;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte PRIMITIVE_CHAR = 67;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte PRIMITIVE_DOUBLE = 68;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte PRIMITIVE_FLOAT = 70;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte PRIMITIVE_LONG = 74;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte PRIMITIVE_SHORT = 83;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte PRIMITIVE_BOOLEAN = 90;

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return this.stringifyValue();
    }

    protected ElementValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) {
        this.type = type;
        this.cpool = cpool;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getElementValueType() {
        return this.type;
    }

    public abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String stringifyValue();

    public abstract void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream var1) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException;

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue readElementValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        byte type = input.readByte();
        switch (type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new SimpleElementValue(type, input.readUnsignedShort(), cpool);
            }
            case 101: {
                return new EnumElementValue(101, input.readUnsignedShort(), input.readUnsignedShort(), cpool);
            }
            case 99: {
                return new ClassElementValue(99, input.readUnsignedShort(), cpool);
            }
            case 64: {
                return new AnnotationElementValue(64, AnnotationEntry.read(input, cpool, false), cpool);
            }
            case 91: {
                int numArrayVals = input.readUnsignedShort();
                ElementValue[] evalues = new ElementValue[numArrayVals];
                for (int j = 0; j < numArrayVals; ++j) {
                    evalues[j] = ElementValue.readElementValue(input, cpool);
                }
                return new ArrayElementValue(91, evalues, cpool);
            }
        }
        throw new RuntimeException("Unexpected element value kind in annotation: " + type);
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.cpool;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getType() {
        return this.type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toShortString() {
        return this.stringifyValue();
    }
}

