/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.classfile.Attribute;
import org.checkerframework.org.apache.bcel.classfile.ClassFormatException;
import org.checkerframework.org.apache.bcel.classfile.ConstantPool;
import org.checkerframework.org.apache.bcel.classfile.ConstantValue;
import org.checkerframework.org.apache.bcel.classfile.FieldOrMethod;
import org.checkerframework.org.apache.bcel.classfile.Utility;
import org.checkerframework.org.apache.bcel.classfile.Visitor;
import org.checkerframework.org.apache.bcel.generic.Type;
import org.checkerframework.org.apache.bcel.util.BCELComparator;

public final class Field
extends FieldOrMethod {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            Field THIS = (Field)o1;
            Field THAT = (Field)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            Field THIS = (Field)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };

    public Field(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field c) {
        super(c);
    }

    Field(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        super(file, constant_pool);
    }

    public Field(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attributes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitField(this);
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ConstantValue getConstantValue() {
        for (Attribute attribute : super.getAttributes()) {
            if (attribute.getTag() != 1) continue;
            return (ConstantValue)attribute;
        }
        return null;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        access = access.isEmpty() ? "" : access + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuilder buf = new StringBuilder(64);
        buf.append(access).append(signature).append(" ").append(name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = ").append(cv);
        }
        for (Attribute attribute : super.getAttributes()) {
            if (attribute instanceof ConstantValue) continue;
            buf.append(" [").append(attribute).append("]");
        }
        return buf.toString();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        return (Field)this.copy_(_constant_pool);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType() {
        return Type.getReturnType(this.getSignature());
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        bcelComparator = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object obj) {
        return bcelComparator.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

