/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.classfile.Attribute;
import org.checkerframework.org.apache.bcel.classfile.ConstantPool;
import org.checkerframework.org.apache.bcel.classfile.InnerClass;
import org.checkerframework.org.apache.bcel.classfile.Visitor;

public final class InnerClasses
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] inner_classes;

    public InnerClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClasses c) {
        this(c.getNameIndex(), c.getLength(), c.getInnerClasses(), c.getConstantPool());
    }

    public InnerClasses(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown [] inner_classes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)6, name_index, length, constant_pool);
        this.inner_classes = inner_classes != null ? inner_classes : new InnerClass[]{};
    }

    InnerClasses(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (InnerClass[])null, constant_pool);
        int number_of_classes = input.readUnsignedShort();
        this.inner_classes = new InnerClass[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            this.inner_classes[i] = new InnerClass(input);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitInnerClasses(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.inner_classes.length);
        for (InnerClass inner_class : this.inner_classes) {
            inner_class.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInnerClasses() {
        return this.inner_classes;
    }

    public final void setInnerClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InnerClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] inner_classes) {
        this.inner_classes = inner_classes != null ? inner_classes : new InnerClass[]{};
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("InnerClasses(");
        buf.append(this.inner_classes.length);
        buf.append("):\n");
        for (InnerClass inner_class : this.inner_classes) {
            buf.append(inner_class.toString(super.getConstantPool())).append("\n");
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        InnerClasses c = (InnerClasses)this.clone();
        c.inner_classes = new InnerClass[this.inner_classes.length];
        for (int i = 0; i < this.inner_classes.length; ++i) {
            c.inner_classes[i] = this.inner_classes[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

