/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.classfile.Node;
import org.checkerframework.org.apache.bcel.classfile.Visitor;

public final class LineNumber
implements Cloneable,
Node {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short start_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short line_number;

    public LineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumber c) {
        this(c.getStartPC(), c.getLineNumber());
    }

    LineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public LineNumber(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int line_number) {
        this.start_pc = (short)start_pc;
        this.line_number = (short)line_number;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitLineNumber(this);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.line_number);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getLineNumber() {
        return 0xFFFF & this.line_number;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getStartPC() {
        return 0xFFFF & this.start_pc;
    }

    public final void setLineNumber(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int line_number) {
        this.line_number = (short)line_number;
    }

    public final void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc) {
        this.start_pc = (short)start_pc;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "LineNumber(" + this.start_pc + ", " + this.line_number + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

