/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.FieldDescriptor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.Constants;
import org.checkerframework.org.apache.bcel.classfile.ConstantPool;
import org.checkerframework.org.apache.bcel.classfile.ConstantUtf8;
import org.checkerframework.org.apache.bcel.classfile.Node;
import org.checkerframework.org.apache.bcel.classfile.Utility;
import org.checkerframework.org.apache.bcel.classfile.Visitor;

public final class LocalVariable
implements Cloneable,
Node,
Constants {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int orig_index;

    public LocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable c) {
        this(c.getStartPC(), c.getLength(), c.getNameIndex(), c.getSignatureIndex(), c.getIndex(), c.getConstantPool());
        this.orig_index = c.getOrigIndex();
    }

    LocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), constant_pool);
    }

    public LocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        this.start_pc = start_pc;
        this.length = length;
        this.name_index = name_index;
        this.signature_index = signature_index;
        this.index = index;
        this.constant_pool = constant_pool;
        this.orig_index = index;
    }

    public LocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int orig_index) {
        this.start_pc = start_pc;
        this.length = length;
        this.name_index = name_index;
        this.signature_index = signature_index;
        this.index = index;
        this.constant_pool = constant_pool;
        this.orig_index = orig_index;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitLocalVariable(this);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.length);
        file.writeShort(this.name_index);
        file.writeShort(this.signature_index);
        file.writeShort(this.index);
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getLength() {
        return this.length;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return c.getBytes();
    }

    @Pure
    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.name_index;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @FieldDescriptor String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSignatureIndex() {
        return this.signature_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getOrigIndex() {
        return this.orig_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getStartPC() {
        return this.start_pc;
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toStringShared(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean typeTable) {
        String name = this.getName();
        String signature = Utility.signatureToString(this.getSignature(), false);
        String label = "LocalVariable" + (typeTable ? "Types" : "");
        return label + "(start_pc = " + this.start_pc + ", length = " + this.length + ", index = " + this.index + ":" + signature + " " + name + ")";
    }

    public final void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final void setLength(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length) {
        this.length = length;
    }

    public final void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index) {
        this.name_index = name_index;
    }

    public final void setSignatureIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index) {
        this.signature_index = signature_index;
    }

    public final void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        this.index = index;
    }

    public final void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc) {
        this.start_pc = start_pc;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return this.toStringShared(false);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable copy() {
        try {
            return (LocalVariable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

