/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.org.apache.bcel.classfile.Attribute;
import org.checkerframework.org.apache.bcel.classfile.ConstantPool;
import org.checkerframework.org.apache.bcel.classfile.MethodParameter;
import org.checkerframework.org.apache.bcel.classfile.Visitor;

public class MethodParameters
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodParameter @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] parameters = new MethodParameter[0];

    MethodParameters(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super((byte)21, name_index, length, constant_pool);
        int parameters_count = input.readUnsignedByte();
        this.parameters = new MethodParameter[parameters_count];
        for (int i = 0; i < parameters_count; ++i) {
            this.parameters[i] = new MethodParameter(input);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodParameter @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getParameters() {
        return this.parameters;
    }

    public void setParameters(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodParameter @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] parameters) {
        this.parameters = parameters;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitMethodParameters(this);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        MethodParameters c = (MethodParameters)this.clone();
        c.parameters = new MethodParameter[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            c.parameters[i] = this.parameters[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeByte(this.parameters.length);
        for (MethodParameter parameter : this.parameters) {
            parameter.dump(file);
        }
    }
}

