/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.org.apache.bcel.classfile.ClassElementValue;
import org.checkerframework.org.apache.bcel.classfile.ConstantUtf8;
import org.checkerframework.org.apache.bcel.classfile.ElementValue;
import org.checkerframework.org.apache.bcel.generic.ConstantPoolGen;
import org.checkerframework.org.apache.bcel.generic.ElementValueGen;
import org.checkerframework.org.apache.bcel.generic.ObjectType;

public class ClassElementValueGen
extends ElementValueGen {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int idx;

    protected ClassElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int typeIdx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = typeIdx;
    }

    public ClassElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType t, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = cpool.addUtf8(t.getSignature());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue getElementValue() {
        return new ClassElementValue(super.getElementValueType(), this.idx, this.getConstantPool().getConstantPool());
    }

    public ClassElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassElementValue value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean copyPoolEntries) {
        super(99, cpool);
        this.idx = copyPoolEntries ? cpool.addUtf8(value.getClassString()) : value.getIndex();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.idx;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getClassString() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return cu8.getBytes();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String stringifyValue() {
        return this.getClassString();
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeByte(super.getElementValueType());
        dos.writeShort(this.idx);
    }
}

