/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.generic;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.classfile.CodeException;
import org.checkerframework.org.apache.bcel.generic.BranchInstruction;
import org.checkerframework.org.apache.bcel.generic.ClassGenException;
import org.checkerframework.org.apache.bcel.generic.ConstantPoolGen;
import org.checkerframework.org.apache.bcel.generic.InstructionHandle;
import org.checkerframework.org.apache.bcel.generic.InstructionTargeter;
import org.checkerframework.org.apache.bcel.generic.ObjectType;

public final class CodeExceptionGen
implements InstructionTargeter,
Cloneable {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start_pc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end_pc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle handler_pc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType catch_type;

    public CodeExceptionGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle handler_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType catch_type) {
        this.setStartPC(start_pc);
        this.setEndPC(end_pc);
        this.setHandlerPC(handler_pc);
        this.catch_type = catch_type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException getCodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        return new CodeException(this.start_pc.getPosition(), this.end_pc.getPosition() + this.end_pc.getInstruction().getLength(), this.handler_pc.getPosition(), this.catch_type == null ? 0 : cp.addClass(this.catch_type));
    }

    public void setStartPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start_pc) {
        BranchInstruction.notifyTarget(this.start_pc, start_pc, this);
        this.start_pc = start_pc;
    }

    public void setEndPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end_pc) {
        BranchInstruction.notifyTarget(this.end_pc, end_pc, this);
        this.end_pc = end_pc;
    }

    public void setHandlerPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle handler_pc) {
        BranchInstruction.notifyTarget(this.handler_pc, handler_pc, this);
        this.handler_pc = handler_pc;
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.start_pc == old_ih) {
            targeted = true;
            this.setStartPC(new_ih);
        }
        if (this.end_pc == old_ih) {
            targeted = true;
            this.setEndPC(new_ih);
        }
        if (this.handler_pc == old_ih) {
            targeted = true;
            this.setHandlerPC(new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih + ", but {" + this.start_pc + ", " + this.end_pc + ", " + this.handler_pc + "}");
        }
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih) {
        return this.start_pc == ih || this.end_pc == ih || this.handler_pc == ih;
    }

    public void setCatchType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType catch_type) {
        this.catch_type = catch_type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getCatchType() {
        return this.catch_type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getStartPC() {
        return this.start_pc;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getEndPC() {
        return this.end_pc;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getHandlerPC() {
        return this.handler_pc;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "CodeExceptionGen(" + this.start_pc + ", " + this.end_pc + ", " + this.handler_pc + ")";
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }
}

