/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.org.apache.bcel.classfile.ConstantUtf8;
import org.checkerframework.org.apache.bcel.classfile.ElementValue;
import org.checkerframework.org.apache.bcel.classfile.EnumElementValue;
import org.checkerframework.org.apache.bcel.generic.ConstantPoolGen;
import org.checkerframework.org.apache.bcel.generic.ElementValueGen;
import org.checkerframework.org.apache.bcel.generic.ObjectType;

public class EnumElementValueGen
extends ElementValueGen {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int typeIdx;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int valueIdx;

    protected EnumElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int typeIdx, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int valueIdx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool) {
        super(101, cpool);
        if (super.getElementValueType() != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor - type specified: " + super.getElementValueType());
        }
        this.typeIdx = typeIdx;
        this.valueIdx = valueIdx;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue getElementValue() {
        System.err.println("Duplicating value: " + this.getEnumTypeString() + ":" + this.getEnumValueString());
        return new EnumElementValue(super.getElementValueType(), this.typeIdx, this.valueIdx, this.getConstantPool().getConstantPool());
    }

    public EnumElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType t, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool) {
        super(101, cpool);
        this.typeIdx = cpool.addUtf8(t.getSignature());
        this.valueIdx = cpool.addUtf8(value);
    }

    public EnumElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown EnumElementValue value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean copyPoolEntries) {
        super(101, cpool);
        if (copyPoolEntries) {
            this.typeIdx = cpool.addUtf8(value.getEnumTypeString());
            this.valueIdx = cpool.addUtf8(value.getEnumValueString());
        } else {
            this.typeIdx = value.getTypeIndex();
            this.valueIdx = value.getValueIndex();
        }
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeByte(super.getElementValueType());
        dos.writeShort(this.typeIdx);
        dos.writeShort(this.valueIdx);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String stringifyValue() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx);
        return cu8.getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getEnumTypeString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.typeIdx)).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getEnumValueString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx)).getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getValueIndex() {
        return this.valueIdx;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTypeIndex() {
        return this.typeIdx;
    }
}

