/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.verifier.structurals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.org.apache.bcel.generic.ATHROW;
import org.checkerframework.org.apache.bcel.generic.BranchInstruction;
import org.checkerframework.org.apache.bcel.generic.GotoInstruction;
import org.checkerframework.org.apache.bcel.generic.Instruction;
import org.checkerframework.org.apache.bcel.generic.InstructionHandle;
import org.checkerframework.org.apache.bcel.generic.JsrInstruction;
import org.checkerframework.org.apache.bcel.generic.MethodGen;
import org.checkerframework.org.apache.bcel.generic.RET;
import org.checkerframework.org.apache.bcel.generic.ReturnInstruction;
import org.checkerframework.org.apache.bcel.generic.Select;
import org.checkerframework.org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.checkerframework.org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.checkerframework.org.apache.bcel.verifier.structurals.ExceptionHandler;
import org.checkerframework.org.apache.bcel.verifier.structurals.ExceptionHandlers;
import org.checkerframework.org.apache.bcel.verifier.structurals.ExecutionVisitor;
import org.checkerframework.org.apache.bcel.verifier.structurals.Frame;
import org.checkerframework.org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import org.checkerframework.org.apache.bcel.verifier.structurals.InstructionContext;
import org.checkerframework.org.apache.bcel.verifier.structurals.LocalVariables;
import org.checkerframework.org.apache.bcel.verifier.structurals.OperandStack;
import org.checkerframework.org.apache.bcel.verifier.structurals.Subroutine;
import org.checkerframework.org.apache.bcel.verifier.structurals.Subroutines;

public class ControlFlowGraph {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Subroutines subroutines;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionHandlers exceptionhandlers;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext> instructionContexts = new HashMap<InstructionHandle, InstructionContext>();

    public ControlFlowGraph(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen method_gen) {
        this(method_gen, true);
    }

    public ControlFlowGraph(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen method_gen, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean enableJustIceCheck) {
        InstructionHandle[] instructionhandles;
        this.subroutines = new Subroutines(method_gen, enableJustIceCheck);
        this.exceptionhandlers = new ExceptionHandlers(method_gen);
        for (InstructionHandle instructionhandle : instructionhandles = method_gen.getInstructionList().getInstructionHandles()) {
            this.instructionContexts.put(instructionhandle, new InstructionContextImpl(instructionhandle));
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext contextOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle inst) {
        InstructionContext ic = this.instructionContexts.get(inst);
        if (ic == null) {
            throw new AssertionViolatedException("InstructionContext requested for an InstructionHandle that's not known!");
        }
        return ic;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] contextsOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] insts) {
        InstructionContext[] ret = new InstructionContext[insts.length];
        for (int i = 0; i < insts.length; ++i) {
            ret[i] = this.contextOf(insts[i]);
        }
        return ret;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInstructionContexts() {
        InstructionContext[] ret = new InstructionContext[this.instructionContexts.values().size()];
        return this.instructionContexts.values().toArray(ret);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isDead(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle i) {
        return this.subroutines.subroutineOf(i) == null;
    }

    private class InstructionContextImpl
    implements InstructionContext {
        private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int TAG;
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle instruction;
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame> inFrames;
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame> outFrames;
        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext> executionPredecessors = null;

        public InstructionContextImpl(InstructionHandle inst) {
            if (inst == null) {
                throw new AssertionViolatedException("Cannot instantiate InstructionContextImpl from NULL.");
            }
            this.instruction = inst;
            this.inFrames = new HashMap<InstructionContext, Frame>();
            this.outFrames = new HashMap<InstructionContext, Frame>();
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTag() {
            return this.TAG;
        }

        @Override
        public void setTag(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int tag) {
            this.TAG = tag;
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionHandler @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionHandlers() {
            return ControlFlowGraph.this.exceptionhandlers.getExceptionHandlers(this.getInstruction());
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame getOutFrame(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext> execChain) {
            this.executionPredecessors = execChain;
            InstructionContextImpl jsr = this.lastExecutionJSR();
            Frame org = this.outFrames.get(jsr);
            if (org == null) {
                throw new AssertionViolatedException("outFrame not set! This:\n" + this + "\nExecutionChain: " + this.getExecutionChain() + "\nOutFrames: '" + this.outFrames + "'.");
            }
            return org.getClone();
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame getInFrame() {
            InstructionContextImpl jsr = this.lastExecutionJSR();
            Frame org = this.inFrames.get(jsr);
            if (org == null) {
                throw new AssertionViolatedException("inFrame not set! This:\n" + this + "\nInFrames: '" + this.inFrames + "'.");
            }
            return org.getClone();
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean execute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame inFrame, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayList<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext> execPreds, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstConstraintVisitor icv, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExecutionVisitor ev) {
            List clone;
            this.executionPredecessors = clone = (List)execPreds.clone();
            if (this.lastExecutionJSR() == null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) != ControlFlowGraph.this.subroutines.getTopLevel()) {
                throw new AssertionViolatedException("Huh?! Am I '" + this + "' part of a subroutine or not?");
            }
            if (this.lastExecutionJSR() != null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) == ControlFlowGraph.this.subroutines.getTopLevel()) {
                throw new AssertionViolatedException("Huh?! Am I '" + this + "' part of a subroutine or not?");
            }
            Frame inF = this.inFrames.get(this.lastExecutionJSR());
            if (inF == null) {
                this.inFrames.put(this.lastExecutionJSR(), inFrame);
                inF = inFrame;
            } else {
                if (inF.equals(inFrame)) {
                    return false;
                }
                if (!this.mergeInFrames(inFrame)) {
                    return false;
                }
            }
            Frame workingFrame = inF.getClone();
            try {
                icv.setFrame(workingFrame);
                this.getInstruction().accept(icv);
            }
            catch (StructuralCodeConstraintException ce) {
                ce.extendMessage("", "\nInstructionHandle: " + this.getInstruction() + "\n");
                ce.extendMessage("", "\nExecution Frame:\n" + workingFrame);
                this.extendMessageWithFlow(ce);
                throw ce;
            }
            ev.setFrame(workingFrame);
            this.getInstruction().accept(ev);
            this.outFrames.put(this.lastExecutionJSR(), workingFrame);
            return true;
        }

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
            String ret = this.getInstruction().toString(false) + "\t[InstructionContext]";
            return ret;
        }

        private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean mergeInFrames(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame inFrame) {
            Frame inF = this.inFrames.get(this.lastExecutionJSR());
            OperandStack oldstack = inF.getStack().getClone();
            LocalVariables oldlocals = inF.getLocals().getClone();
            try {
                inF.getStack().merge(inFrame.getStack());
                inF.getLocals().merge(inFrame.getLocals());
            }
            catch (StructuralCodeConstraintException sce) {
                this.extendMessageWithFlow(sce);
                throw sce;
            }
            return !oldstack.equals(inF.getStack()) || !oldlocals.equals(inF.getLocals());
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getExecutionChain() {
            String s2 = this.toString();
            for (int i = this.executionPredecessors.size() - 1; i >= 0; --i) {
                s2 = this.executionPredecessors.get(i) + "\n" + s2;
            }
            return s2;
        }

        private void extendMessageWithFlow(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StructuralCodeConstraintException e) {
            String s2 = "Execution flow:\n";
            e.extendMessage("", "Execution flow:\n" + this.getExecutionChain());
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getInstruction() {
            return this.instruction;
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ControlFlowGraph. @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InstructionContextImpl lastExecutionJSR() {
            int size = this.executionPredecessors.size();
            int retcount = 0;
            for (int i = size - 1; i >= 0; --i) {
                InstructionContextImpl current = (InstructionContextImpl)this.executionPredecessors.get(i);
                Instruction currentlast = current.getInstruction().getInstruction();
                if (currentlast instanceof RET) {
                    ++retcount;
                }
                if (!(currentlast instanceof JsrInstruction) || --retcount != -1) continue;
                return current;
            }
            return null;
        }

        @Override
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionContext @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getSuccessors() {
            return ControlFlowGraph.this.contextsOf(this._getSuccessors());
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] _getSuccessors() {
            InstructionHandle[] empty = new InstructionHandle[]{};
            InstructionHandle[] single = new InstructionHandle[1];
            Instruction inst = this.getInstruction().getInstruction();
            if (inst instanceof RET) {
                Subroutine s2 = ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction());
                if (s2 == null) {
                    throw new AssertionViolatedException("Asking for successors of a RET in dead code?!");
                }
                InstructionHandle[] jsrs = s2.getEnteringJsrInstructions();
                InstructionHandle[] ret = new InstructionHandle[jsrs.length];
                for (int i = 0; i < jsrs.length; ++i) {
                    ret[i] = jsrs[i].getNext();
                }
                return ret;
            }
            if (inst instanceof ReturnInstruction) {
                return empty;
            }
            if (inst instanceof ATHROW) {
                return empty;
            }
            if (inst instanceof JsrInstruction) {
                single[0] = ((JsrInstruction)inst).getTarget();
                return single;
            }
            if (inst instanceof GotoInstruction) {
                single[0] = ((GotoInstruction)inst).getTarget();
                return single;
            }
            if (inst instanceof BranchInstruction) {
                if (inst instanceof Select) {
                    InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                    InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                    ret[0] = ((Select)inst).getTarget();
                    System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                    return ret;
                }
                InstructionHandle[] pair = new InstructionHandle[]{this.getInstruction().getNext(), ((BranchInstruction)inst).getTarget()};
                return pair;
            }
            single[0] = this.getInstruction().getNext();
            return single;
        }
    }
}

