/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.plumelib.bcelutil;

import java.io.File;
import java.io.PrintStream;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.checker.signature.qual.InternalForm;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.org.apache.bcel.Const;
import org.checkerframework.org.apache.bcel.classfile.Attribute;
import org.checkerframework.org.apache.bcel.classfile.Code;
import org.checkerframework.org.apache.bcel.classfile.Constant;
import org.checkerframework.org.apache.bcel.classfile.ConstantClass;
import org.checkerframework.org.apache.bcel.classfile.ConstantPool;
import org.checkerframework.org.apache.bcel.classfile.ConstantUtf8;
import org.checkerframework.org.apache.bcel.classfile.Field;
import org.checkerframework.org.apache.bcel.classfile.JavaClass;
import org.checkerframework.org.apache.bcel.classfile.Method;
import org.checkerframework.org.apache.bcel.generic.ClassGen;
import org.checkerframework.org.apache.bcel.generic.CodeExceptionGen;
import org.checkerframework.org.apache.bcel.generic.ConstantPoolGen;
import org.checkerframework.org.apache.bcel.generic.InstructionHandle;
import org.checkerframework.org.apache.bcel.generic.InstructionList;
import org.checkerframework.org.apache.bcel.generic.InstructionTargeter;
import org.checkerframework.org.apache.bcel.generic.LineNumberGen;
import org.checkerframework.org.apache.bcel.generic.LocalVariableGen;
import org.checkerframework.org.apache.bcel.generic.MethodGen;
import org.checkerframework.org.apache.bcel.generic.ObjectType;
import org.checkerframework.org.apache.bcel.generic.RETURN;
import org.checkerframework.org.apache.bcel.generic.Type;
import org.checkerframework.org.plumelib.reflection.ReflectionPlume;
import org.checkerframework.org.plumelib.reflection.Signatures;

public final class BcelUtil {
    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean skipChecks = false;
    private static final @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type stringArray = Type.getType("[Ljava.lang.String;");

    private BcelUtil() {
        throw new Error("do not instantiate");
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String methodDeclarationToString(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Method m3) {
        StringBuilder sb = new StringBuilder();
        String flags = BcelUtil.accessFlagsToString(m3);
        boolean argsExist = false;
        if (flags != null && !flags.isEmpty()) {
            sb.append(String.format("%s ", flags));
        }
        sb.append(String.format("%s %s(", m3.getReturnType(), m3.getName()));
        for (Type at : m3.getArgumentTypes()) {
            sb.append(String.format("%s, ", at));
            argsExist = true;
        }
        if (argsExist) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        return sb.toString();
    }

    static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String accessFlagsToString(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Method m3) {
        int flags = m3.getAccessFlags();
        StringBuilder buf = new StringBuilder();
        int pow = 1;
        for (int i = 0; i <= 16384; ++i) {
            if ((flags & pow) != 0) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                if (i < Const.ACCESS_NAMES_LENGTH) {
                    buf.append(Const.getAccessName(i));
                } else {
                    buf.append(String.format("ACC_BIT(%x)", pow));
                }
            }
            pow <<= 1;
        }
        return buf.toString();
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String instructionListToString(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionList il, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ConstantPoolGen pool) {
        StringBuilder out = new StringBuilder();
        for (InstructionHandle handle : il) {
            out.append(handle.getInstruction().toString(pool.getConstantPool()) + "\n");
        }
        return out.toString();
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String localVariablesToString(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg) {
        StringBuilder out = new StringBuilder();
        out.append(String.format("Locals for %s [cnt %d]%n", mg, mg.getMaxLocals()));
        LocalVariableGen[] lvgs = mg.getLocalVariables();
        if (lvgs != null && lvgs.length > 0) {
            for (LocalVariableGen lvg : lvgs) {
                out.append(String.format("  %s [index %d]%n", lvg, lvg.getIndex()));
            }
        }
        return out.toString();
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String attributeNameToString(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Attribute a) {
        ConstantPool pool = a.getConstantPool();
        int conIndex = a.getNameIndex();
        Constant c = pool.getConstant(conIndex);
        String attName = ((ConstantUtf8)c).getBytes();
        return attName;
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String attributeNameToString(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Attribute a, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ConstantPoolGen pool) {
        int conIndex = a.getNameIndex();
        Constant c = pool.getConstant(conIndex);
        String attName = ((ConstantUtf8)c).getBytes();
        return attName;
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean isConstructor(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg) {
        if (mg.getName().equals("")) {
            throw new Error("method name cannot be empty");
        }
        return mg.getName().equals("<init>");
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean isConstructor(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Method m3) {
        if (m3.getName().equals("")) {
            throw new Error("method name cannot be empty");
        }
        return m3.getName().equals("<init>");
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean isClinit(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg) {
        return mg.getName().equals("<clinit>");
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean isClinit(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Method m3) {
        return m3.getName().equals("<clinit>");
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean inJdk(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ClassGen gen) {
        return BcelUtil.inJdk(gen.getClassName());
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean inJdk(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @ClassGetName @UnknownFormat @UnknownRegex String classname) {
        return classname.startsWith("java.") || classname.startsWith("com.oracle.") || classname.startsWith("com.sun.") || classname.startsWith("javax.") || classname.startsWith("jdk.") || classname.startsWith("org.ietf.") || classname.startsWith("org.jcp.") || classname.startsWith("org.omg.") || classname.startsWith("org.w3c.") || classname.startsWith("org.xml.") || classname.startsWith("sun.") || classname.startsWith("sunw.");
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean inJdkInternalform(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @InternalForm @UnknownFormat @UnknownRegex String classname) {
        return classname.startsWith("java/") || classname.startsWith("com/oracle/") || classname.startsWith("com/sun/") || classname.startsWith("javax/") || classname.startsWith("jdk/") || classname.startsWith("org/ietj/") || classname.startsWith("org/jcp/") || classname.startsWith("org/omg/") || classname.startsWith("org/w3c/") || classname.startsWith("org/xml/") || classname.startsWith("sun/") || classname.startsWith("sunw/");
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean isLocalVariableTypeTable(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Attribute a, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ConstantPoolGen pool) {
        return BcelUtil.attributeNameToString(a, pool).equals("LocalVariableTypeTable");
    }

    public static @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean isMain(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg) {
        Type[] argTypes = mg.getArgumentTypes();
        return mg.isStatic() && mg.getReturnType() == Type.VOID && mg.getName().equals("main") && argTypes.length == 1 && argTypes[0].equals(stringArray);
    }

    public static void checkMgen(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mgen) {
        if (skipChecks) {
            return;
        }
        try {
            CodeExceptionGen[] exceptionHandlers;
            mgen.toString();
            mgen.getLineNumberTable(mgen.getConstantPool());
            InstructionList ilist = mgen.getInstructionList();
            if (ilist == null || ilist.getStart() == null) {
                return;
            }
            for (CodeExceptionGen gen : exceptionHandlers = mgen.getExceptionHandlers()) {
                assert (ilist.contains(gen.getStartPC())) : "exception handler " + gen + " has been forgotten in " + mgen.getClassName() + "." + mgen.getName();
            }
            MethodGen nmg = new MethodGen(mgen.getMethod(), mgen.getClassName(), mgen.getConstantPool());
            nmg.getLineNumberTable(mgen.getConstantPool());
        }
        catch (Throwable t) {
            Error e = new Error(String.format("failure while checking method %s.%s%n", mgen.getClassName(), mgen.getName()), t);
            e.printStackTrace();
            throw e;
        }
    }

    public static void checkMgens(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ClassGen gen) {
        if (skipChecks) {
            return;
        }
        Method[] methods = gen.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            BcelUtil.checkMgen(new MethodGen(method, gen.getClassName(), gen.getConstantPool()));
        }
    }

    public static void dumpStackTrace() {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        if (ste.length < 3) {
            System.out.println("No stack trace information available");
        } else {
            StackTraceElement caller = ste[2];
            System.out.printf("%s.%s (%s line %d)", caller.getClassName(), caller.getMethodName(), caller.getFileName(), caller.getLineNumber());
            for (int ii = 3; ii < ste.length; ++ii) {
                System.out.printf(" [%s line %d]", ste[ii].getFileName(), ste[ii].getLineNumber());
            }
            System.out.printf("%n", new Object[0]);
        }
    }

    static void dumpMethods(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ClassGen gen) {
        System.out.printf("Class %s methods:%n", gen.getClassName());
        for (Method m3 : gen.getMethods()) {
            System.out.printf("  %s%n", m3);
        }
    }

    public static void dump(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown JavaClass jc, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String dumpDir) {
        BcelUtil.dump(jc, new File(dumpDir));
    }

    public static void dump(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown JavaClass jc, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown File dumpDir) {
        try {
            dumpDir.mkdir();
            File path = new File(dumpDir, jc.getClassName() + ".bcel");
            PrintStream p = new PrintStream(path);
            p.printf("class %s extends %s%n", jc.getClassName(), jc.getSuperclassName());
            String[] inames = jc.getInterfaceNames();
            boolean first = true;
            if (inames != null && inames.length > 0) {
                p.printf("   implements ", new Object[0]);
                for (String string : inames) {
                    if (!first) {
                        p.printf(", ", new Object[0]);
                    }
                    p.printf("%s", string);
                    first = false;
                }
                p.printf("%n", new Object[0]);
            }
            p.printf("%nFields%n", new Object[0]);
            for (Field field : jc.getFields()) {
                p.printf("  %s%n", field);
            }
            p.printf("%nMethods%n", new Object[0]);
            for (Method method : jc.getMethods()) {
                p.printf("  %s%n", method);
            }
            for (Method method : jc.getMethods()) {
                Code code = method.getCode();
                if (code == null) continue;
                p.printf("%nMethod %s%n", method);
                p.printf("  %s%n", code.toString().replace("\n", "\n  "));
            }
            p.printf("Constant Pool:%n", new Object[0]);
            ConstantPool cp = jc.getConstantPool();
            Constant[] constants = cp.getConstantPool();
            for (int ii = 0; ii < constants.length; ++ii) {
                p.printf("  %d %s%n", ii, constants[ii]);
            }
            p.close();
        }
        catch (Exception e) {
            throw new Error("Unexpected error dumping JavaClass: " + jc.getClassName() + " to " + dumpDir.getName(), e);
        }
    }

    public static void addToStart(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionList newList) {
        InstructionList il = mg.getInstructionList();
        InstructionHandle oldStart = il.getStart();
        InstructionHandle newStart = il.insert(newList);
        if (oldStart.hasTargeters()) {
            for (InstructionTargeter it : oldStart.getTargeters()) {
                if (!(it instanceof LineNumberGen) && !(it instanceof LocalVariableGen)) continue;
                it.updateTarget(oldStart, newStart);
            }
        }
        mg.setMaxStack();
        mg.setMaxLocals();
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String getConstantString(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ConstantPool pool, @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown int index) {
        Constant c = pool.getConstant(index);
        assert (c != null) : "Bad index " + index + " into pool";
        if (c instanceof ConstantUtf8) {
            return ((ConstantUtf8)c).getBytes();
        }
        if (c instanceof ConstantClass) {
            ConstantClass cc = (ConstantClass)c;
            return cc.getBytes(pool) + " [" + cc.getNameIndex() + "]";
        }
        throw new Error("unexpected constant " + c + " of class " + c.getClass());
    }

    public static void resetLocalsToFormals(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg) {
        Type @SameLen(value={"argTypes", "mg.getArgumentTypes()"}) [] argTypes = mg.getArgumentTypes();
        String @SameLen(value={"argTypes", "argNames", "mg.getArgumentTypes()", "mg.getArgumentNames()"}) [] argNames = mg.getArgumentNames();
        mg.setMaxLocals(0);
        mg.removeLocalVariables();
        if (!mg.isStatic()) {
            mg.addLocalVariable("this", new ObjectType(mg.getClassName()), null, null);
        }
        for (int ii = 0; ii < argNames.length; ++ii) {
            mg.addLocalVariable(argNames[ii], argTypes[ii], null, null);
        }
        mg.setMaxLocals();
    }

    public static void makeMethodBodyEmpty(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg) {
        mg.setInstructionList(new InstructionList(new RETURN()));
        mg.removeExceptionHandlers();
        mg.removeLineNumbers();
        mg.removeLocalVariables();
        mg.setMaxLocals();
    }

    public static void removeLocalVariableTypeTables(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg) {
        for (Attribute a : mg.getCodeAttributes()) {
            if (!BcelUtil.isLocalVariableTypeTable(a, mg.getConstantPool())) continue;
            mg.removeCodeAttribute(a);
        }
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @ClassGetName @UnknownFormat @UnknownRegex String typeToClassgetname(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type type) {
        String signature = type.getSignature();
        return Signatures.fieldDescriptorToClassGetName(signature);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Class<@UnknownInterned @InternedDistinct @LockPossiblyHeld @GuardedBy @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonRaw @NonRaw @UnknownFormat @FormatBottom @UnknownRegex @RegexBottom @SignatureUnknown @SignatureBottom ?> typeToClass(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type type) {
        String classname = BcelUtil.typeToClassgetname(type);
        try {
            return ReflectionPlume.classForName(classname);
        }
        catch (Exception e) {
            throw new RuntimeException("can't find class for " + classname, e);
        }
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown [] postpendToArray(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown [] types, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type newType) {
        if (types.length == Integer.MAX_VALUE) {
            throw new Error("array " + types + " is too large to extend");
        }
        Type[] newTypes = new Type[types.length + 1];
        System.arraycopy(types, 0, newTypes, 0, types.length);
        newTypes[types.length] = newType;
        return newTypes;
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown [] prependToArray(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type newType, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown [] types) {
        if (types.length == Integer.MAX_VALUE) {
            throw new Error("array " + types + " is too large to extend");
        }
        Type[] newTypes = new Type[types.length + 1];
        System.arraycopy(types, 0, newTypes, 1, types.length);
        newTypes[0] = newType;
        return newTypes;
    }

    public static @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Type classnameToType(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @BinaryName @UnknownFormat @UnknownRegex String classname) {
        if ((classname = classname.intern()) == "int") {
            return Type.INT;
        }
        if (classname == "boolean") {
            return Type.BOOLEAN;
        }
        if (classname == "byte") {
            return Type.BYTE;
        }
        if (classname == "char") {
            return Type.CHAR;
        }
        if (classname == "double") {
            return Type.DOUBLE;
        }
        if (classname == "float") {
            return Type.FLOAT;
        }
        if (classname == "long") {
            return Type.LONG;
        }
        if (classname == "short") {
            return Type.SHORT;
        }
        return new ObjectType(classname);
    }
}

