/*
 * Decompiled with CFR 0.152.
 */
package annotator;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Types;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public final class Source {
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private StandardJavaFileManager fileManager;
    private JavacTask task;
    private StringBuilder source;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private String path;
    private Types types;

    public Source(String src) throws CompilerException, IOException {
        int c;
        if (this.compiler == null) {
            throw new CompilerException("could not get compiler instance");
        }
        this.diagnostics = new DiagnosticCollector();
        this.fileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        if (this.fileManager == null) {
            throw new CompilerException("could not get file manager");
        }
        Iterable<? extends JavaFileObject> fileObjs = this.fileManager.getJavaFileObjectsFromStrings(Collections.singletonList(src));
        String[] stringOpts = new String[]{"-g", "-Xlint:-options", "-source", "8", "-target", "8"};
        List<String> optsList = Arrays.asList(stringOpts);
        JavaCompiler.CompilationTask cTask = this.compiler.getTask(null, this.fileManager, this.diagnostics, optsList, null, fileObjs);
        if (!(cTask instanceof JavacTask)) {
            throw new CompilerException("could not get a valid JavacTask: " + cTask.getClass());
        }
        this.task = (JavacTask)cTask;
        this.types = Types.instance(((JavacTaskImpl)cTask).getContext());
        this.path = src;
        this.source = new StringBuilder();
        FileInputStream in = new FileInputStream(src);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            bytes.write(c);
        }
        in.close();
        this.source.append(bytes.toString());
        bytes.close();
        this.fileManager.close();
    }

    public Types getTypes() {
        return this.types;
    }

    /*
     * WARNING - void declaration
     */
    public Set<CompilationUnitTree> parse() {
        try {
            HashSet<CompilationUnitTree> compUnits = new HashSet<CompilationUnitTree>();
            for (CompilationUnitTree compilationUnitTree : this.task.parse()) {
                compUnits.add(compilationUnitTree);
            }
            List<Diagnostic<JavaFileObject>> errors = this.diagnostics.getDiagnostics();
            if (!this.diagnostics.getDiagnostics().isEmpty()) {
                void var3_6;
                boolean bl = false;
                for (Diagnostic<JavaFileObject> d : errors) {
                    System.err.println(d);
                    if (d.getKind() != Diagnostic.Kind.ERROR) continue;
                    ++var3_6;
                }
                if (var3_6 > 0) {
                    System.err.println((int)var3_6 + " error" + (var3_6 != true ? "s" : ""));
                    System.err.println("WARNING: Error processing input source files. Please fix and try again.");
                    System.exit(1);
                }
            }
            try {
                this.task.analyze();
            }
            catch (Throwable throwable) {
                System.err.println("WARNING: skipping " + this.path);
                System.err.println("  Type analysis failed due to: " + throwable.getMessage());
                return Collections.emptySet();
            }
            return compUnits;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public void insert(int offset, String str) {
        this.source.insert(offset, str);
    }

    public char charAt(int index) {
        return this.source.charAt(index);
    }

    public String substring(int start, int end) {
        return this.source.substring(start, end);
    }

    public String getString() {
        return this.source.toString();
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.source.toString().getBytes());
        out.flush();
        out.close();
    }

    public static class CompilerException
    extends Exception {
        private static final long serialVersionUID = -4751611137146719789L;

        public CompilerException(String message) {
            super(message);
        }
    }
}

