/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.find.IsSigMethodCriterion;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Modifier;

final class InMethodCriterion
implements Criterion {
    public final String name;
    private final IsSigMethodCriterion sigMethodCriterion;

    InMethodCriterion(String name) {
        this.name = name;
        this.sigMethodCriterion = new IsSigMethodCriterion(name);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_METHOD;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy(%s); this=%s%n", Main.leafString(path), this.toString());
        boolean inDecl = false;
        boolean staticDecl = false;
        TreePath childPath = null;
        do {
            Tree leaf;
            if ((leaf = path.getLeaf()).getKind() == Tree.Kind.METHOD) {
                boolean b = this.sigMethodCriterion.isSatisfiedBy(path);
                Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy => %s%n", b);
                return b;
            }
            if (leaf.getKind() == Tree.Kind.VARIABLE) {
                VariableTree varDecl = (VariableTree)leaf;
                if (childPath != null && childPath.getLeaf() == varDecl.getInitializer()) {
                    inDecl = true;
                    ModifiersTree mods = varDecl.getModifiers();
                    staticDecl = mods.getFlags().contains((Object)Modifier.STATIC);
                }
            }
            childPath = path;
        } while ((path = path.getParentPath()) != null && path.getLeaf() != null);
        boolean result = inDecl && (staticDecl ? "<clinit>()V" : "<init>()V").equals(this.name);
        Criteria.dbug.debug("InMethodCriterion.isSatisfiedBy => %s%n", result);
        return result;
    }

    public String toString() {
        return "in method '" + this.name + "'";
    }
}

