/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.inequality;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.index.OffsetDependentTypesHelper;
import org.checkerframework.checker.index.qual.LessThan;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.upperbound.OffsetEquation;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.ValueCheckerUtils;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;

public class LessThanAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror BOTTOM;
    public final AnnotationMirror UNKNOWN;

    public LessThanAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.BOTTOM = AnnotationBuilder.fromClass(this.elements, LessThanBottom.class);
        this.UNKNOWN = AnnotationBuilder.fromClass(this.elements, LessThanUnknown.class);
        this.postInit();
    }

    public ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(LessThan.class, LessThanUnknown.class, LessThanBottom.class));
    }

    @Override
    protected DependentTypesHelper createDependentTypesHelper() {
        return new OffsetDependentTypesHelper(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new LessThanQualifierHierarchy(factory);
    }

    public boolean isLessThan(Tree left, String right) {
        AnnotatedTypeMirror leftATM = this.getAnnotatedType(left);
        return LessThanAnnotatedTypeFactory.isLessThan(leftATM.getAnnotationInHierarchy(this.UNKNOWN), right);
    }

    public static boolean isLessThan(AnnotationMirror left, String right) {
        List<String> expressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(left);
        if (expressions == null) {
            return true;
        }
        return expressions.contains(right);
    }

    public boolean isLessThanByValue(Tree smaller, String bigger, TreePath path) {
        Long smallerValue = ValueCheckerUtils.getMinValue(smaller, this.getValueAnnotatedTypeFactory());
        if (smallerValue == null) {
            return false;
        }
        OffsetEquation offsetEquation = OffsetEquation.createOffsetFromJavaExpression(bigger);
        if (offsetEquation.isInt()) {
            return smallerValue < (long)offsetEquation.getInt();
        }
        smallerValue = smallerValue - (long)offsetEquation.getInt();
        offsetEquation = offsetEquation.copyAdd('-', OffsetEquation.createOffsetForInt(offsetEquation.getInt()));
        long minValueOfBigger = this.getMinValueFromString(offsetEquation.toString(), smaller, path);
        return smallerValue < minValueOfBigger;
    }

    private long getMinValueFromString(String expression, Tree tree, TreePath path) {
        FlowExpressions.FieldAccess fieldAccess;
        FlowExpressions.Receiver expressionRec;
        try {
            expressionRec = this.getValueAnnotatedTypeFactory().getReceiverFromJavaExpressionString(expression, path);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
            return Long.MIN_VALUE;
        }
        AnnotationMirror intRange = this.getValueAnnotatedTypeFactory().getAnnotationFromReceiver(expressionRec, tree, IntRange.class);
        if (intRange != null) {
            return ValueAnnotatedTypeFactory.getRange((AnnotationMirror)intRange).from;
        }
        AnnotationMirror intValue = this.getValueAnnotatedTypeFactory().getAnnotationFromReceiver(expressionRec, tree, IntVal.class);
        if (intValue != null) {
            List<Long> possibleValues = ValueAnnotatedTypeFactory.getIntValues(intValue);
            return Collections.min(possibleValues);
        }
        if (expressionRec instanceof FlowExpressions.FieldAccess && (fieldAccess = (FlowExpressions.FieldAccess)expressionRec).getReceiver().getType().getKind() == TypeKind.ARRAY) {
            AnnotationMirror arrayRange = this.getValueAnnotatedTypeFactory().getAnnotationFromReceiver(fieldAccess.getReceiver(), tree, ArrayLenRange.class);
            if (arrayRange != null) {
                return ValueAnnotatedTypeFactory.getRange((AnnotationMirror)arrayRange).from;
            }
            AnnotationMirror arrayLen = this.getValueAnnotatedTypeFactory().getAnnotationFromReceiver(expressionRec, tree, ArrayLen.class);
            if (arrayLen != null) {
                List<Integer> possibleValues = ValueAnnotatedTypeFactory.getArrayLength(arrayLen);
                return Collections.min(possibleValues).intValue();
            }
            return 0L;
        }
        return Long.MIN_VALUE;
    }

    public boolean isLessThanOrEqual(Tree left, String right) {
        AnnotatedTypeMirror leftATM = this.getAnnotatedType(left);
        return LessThanAnnotatedTypeFactory.isLessThanOrEqual(leftATM.getAnnotationInHierarchy(this.UNKNOWN), right);
    }

    public static boolean isLessThanOrEqual(AnnotationMirror left, String right) {
        List<String> expressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(left);
        if (expressions == null) {
            return true;
        }
        if (expressions.contains(right)) {
            return true;
        }
        for (String expression : expressions) {
            if (!expression.endsWith(" + 1") || !expression.substring(0, expression.length() - 4).equals(right)) continue;
            return true;
        }
        return false;
    }

    public List<String> getLessThanExpressions(ExpressionTree expression) {
        AnnotatedTypeMirror annotatedTypeMirror = this.getAnnotatedType(expression);
        return LessThanAnnotatedTypeFactory.getLessThanExpressions(annotatedTypeMirror.getAnnotationInHierarchy(this.UNKNOWN));
    }

    public AnnotationMirror createLessThanQualifier(List<String> expressions) {
        if (expressions == null) {
            return this.BOTTOM;
        }
        if (expressions.isEmpty()) {
            return this.UNKNOWN;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, LessThan.class);
        builder.setValue((CharSequence)"value", expressions);
        return builder.build();
    }

    public AnnotationMirror createLessThanQualifier(String expression) {
        return this.createLessThanQualifier(Collections.singletonList(expression));
    }

    public static List<String> getLessThanExpressions(AnnotationMirror annotation) {
        if (AnnotationUtils.areSameByClass(annotation, LessThanBottom.class)) {
            return null;
        }
        if (AnnotationUtils.areSameByClass(annotation, LessThanUnknown.class)) {
            return new ArrayList<String>();
        }
        List<String> list = AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
        return list;
    }

    class LessThanQualifierHierarchy
    extends GraphQualifierHierarchy {
        public LessThanQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f, LessThanAnnotatedTypeFactory.this.BOTTOM);
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            List<String> subList = LessThanAnnotatedTypeFactory.getLessThanExpressions(subAnno);
            List<String> superList = LessThanAnnotatedTypeFactory.getLessThanExpressions(superAnno);
            if (subList == null) {
                return true;
            }
            if (superList == null) {
                return false;
            }
            return subList.containsAll(superList);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            List<String> a1List = LessThanAnnotatedTypeFactory.getLessThanExpressions(a1);
            List<String> a2List = LessThanAnnotatedTypeFactory.getLessThanExpressions(a2);
            ArrayList<String> lub = new ArrayList<String>(a1List);
            lub.retainAll(a2List);
            return LessThanAnnotatedTypeFactory.this.createLessThanQualifier(lub);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (this.isSubtype(a1, a2)) {
                return a1;
            }
            if (this.isSubtype(a2, a1)) {
                return a2;
            }
            List<String> a1List = LessThanAnnotatedTypeFactory.getLessThanExpressions(a1);
            List<String> a2List = LessThanAnnotatedTypeFactory.getLessThanExpressions(a2);
            ArrayList<String> glb = new ArrayList<String>(a1List);
            glb.addAll(a2List);
            return LessThanAnnotatedTypeFactory.this.createLessThanQualifier(glb);
        }
    }
}

