/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.initialization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.initialization.InitializationAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class InitializationStore<V extends CFAbstractValue<V>, S extends InitializationStore<V, S>>
extends CFAbstractStore<V, S> {
    protected final Set<VariableElement> initializedFields;
    protected final Map<FlowExpressions.FieldAccess, V> invariantFields;

    public InitializationStore(CFAbstractAnalysis<V, S, ?> analysis, boolean sequentialSemantics) {
        super(analysis, sequentialSemantics);
        this.initializedFields = new HashSet<VariableElement>();
        this.invariantFields = new HashMap<FlowExpressions.FieldAccess, V>();
    }

    @Override
    public void insertValue(FlowExpressions.Receiver r, V value) {
        if (value == null) {
            return;
        }
        InitializationAnnotatedTypeFactory atypeFactory = (InitializationAnnotatedTypeFactory)this.analysis.getTypeFactory();
        QualifierHierarchy qualifierHierarchy = atypeFactory.getQualifierHierarchy();
        AnnotationMirror invariantAnno = atypeFactory.getFieldInvariantAnnotation();
        if (r instanceof FlowExpressions.FieldAccess) {
            Set<AnnotationMirror> declaredAnnos;
            FlowExpressions.FieldAccess fieldAccess = (FlowExpressions.FieldAccess)r;
            if (!this.fieldValues.containsKey(r) && AnnotationUtils.containsSame(declaredAnnos = atypeFactory.getAnnotatedType(fieldAccess.getField()).getAnnotations(), invariantAnno) && !this.invariantFields.containsKey(fieldAccess)) {
                this.invariantFields.put(fieldAccess, this.analysis.createSingleAnnotationValue(invariantAnno, r.getType()));
            }
        }
        super.insertValue(r, value);
        for (AnnotationMirror a : ((CFAbstractValue)value).getAnnotations()) {
            FlowExpressions.FieldAccess fa;
            if (!qualifierHierarchy.isSubtype(a, invariantAnno) || !(r instanceof FlowExpressions.FieldAccess) || !((fa = (FlowExpressions.FieldAccess)r).getReceiver() instanceof FlowExpressions.ThisReference) && !(fa.getReceiver() instanceof FlowExpressions.ClassName)) continue;
            this.addInitializedField(fa.getField());
        }
    }

    @Override
    public void updateForMethodCall(MethodInvocationNode n, AnnotatedTypeFactory atypeFactory, V val) {
        for (FlowExpressions.FieldAccess invariantField : this.invariantFields.keySet()) {
            this.fieldValues.remove(invariantField);
        }
        super.updateForMethodCall(n, atypeFactory, val);
        this.fieldValues.putAll(this.invariantFields);
    }

    public InitializationStore(S other) {
        super(other);
        this.initializedFields = new HashSet<VariableElement>(((InitializationStore)other).initializedFields);
        this.invariantFields = new HashMap<FlowExpressions.FieldAccess, V>(((InitializationStore)other).invariantFields);
    }

    public void addInitializedField(FlowExpressions.FieldAccess field) {
        boolean fieldOnThisReference = field.getReceiver() instanceof FlowExpressions.ThisReference;
        boolean staticField = field.isStatic();
        if (fieldOnThisReference || staticField) {
            this.initializedFields.add(field.getField());
        }
    }

    public void addInitializedField(VariableElement f) {
        this.initializedFields.add(f);
    }

    public boolean isFieldInitialized(Element f) {
        return this.initializedFields.contains(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean supersetOf(CFAbstractStore<V, S> o) {
        if (!(o instanceof InitializationStore)) {
            return false;
        }
        InitializationStore other = (InitializationStore)o;
        for (Element element : other.initializedFields) {
            if (this.initializedFields.contains(element)) continue;
            return false;
        }
        for (FlowExpressions.FieldAccess fieldAccess : other.invariantFields.keySet()) {
            if (this.invariantFields.containsKey(fieldAccess)) continue;
            return false;
        }
        HashMap<FlowExpressions.FieldAccess, CFAbstractValue> removedFieldValues = new HashMap<FlowExpressions.FieldAccess, CFAbstractValue>();
        HashMap<FlowExpressions.FieldAccess, CFAbstractValue> hashMap = new HashMap<FlowExpressions.FieldAccess, CFAbstractValue>();
        try {
            CFAbstractValue v;
            for (FlowExpressions.FieldAccess invariantField : this.invariantFields.keySet()) {
                v = (CFAbstractValue)this.fieldValues.remove(invariantField);
                removedFieldValues.put(invariantField, v);
            }
            for (FlowExpressions.FieldAccess invariantField : other.invariantFields.keySet()) {
                v = (CFAbstractValue)other.fieldValues.remove(invariantField);
                hashMap.put(invariantField, v);
            }
            boolean bl = super.supersetOf(other);
            return bl;
        }
        finally {
            this.fieldValues.putAll(removedFieldValues);
            other.fieldValues.putAll(hashMap);
        }
    }

    @Override
    public S leastUpperBound(S other) {
        CFAbstractValue v;
        HashMap<FlowExpressions.FieldAccess, CFAbstractValue> removedFieldValues = new HashMap<FlowExpressions.FieldAccess, CFAbstractValue>();
        HashMap<FlowExpressions.FieldAccess, CFAbstractValue> removedOtherFieldValues = new HashMap<FlowExpressions.FieldAccess, CFAbstractValue>();
        for (FlowExpressions.FieldAccess invariantField : this.invariantFields.keySet()) {
            v = (CFAbstractValue)this.fieldValues.remove(invariantField);
            removedFieldValues.put(invariantField, v);
        }
        for (FlowExpressions.FieldAccess invariantField : ((InitializationStore)other).invariantFields.keySet()) {
            v = (CFAbstractValue)((InitializationStore)other).fieldValues.remove(invariantField);
            removedOtherFieldValues.put(invariantField, v);
        }
        InitializationStore result = (InitializationStore)super.leastUpperBound(other);
        this.fieldValues.putAll(removedFieldValues);
        ((InitializationStore)other).fieldValues.putAll(removedOtherFieldValues);
        result.initializedFields.addAll(((InitializationStore)other).initializedFields);
        result.initializedFields.retainAll(this.initializedFields);
        for (Map.Entry<FlowExpressions.FieldAccess, V> e : this.invariantFields.entrySet()) {
            if (!((InitializationStore)other).invariantFields.containsKey(e.getKey())) continue;
            result.invariantFields.put(e.getKey(), (CFAbstractValue)e.getValue());
        }
        result.fieldValues.putAll(result.invariantFields);
        return (S)result;
    }

    @Override
    protected String internalVisualize(CFGVisualizer<V, S, ?> viz) {
        return super.internalVisualize(viz) + viz.visualizeStoreKeyVal("initialized fields", this.initializedFields) + viz.visualizeStoreKeyVal("invariant fields", this.invariantFields);
    }

    public Map<FlowExpressions.FieldAccess, V> getFieldValues() {
        return this.fieldValues;
    }

    public CFAbstractAnalysis<V, S, ?> getAnalysis() {
        return this.analysis;
    }
}

