/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.SignedPositive;
import org.checkerframework.checker.signedness.qual.SignednessGlb;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.ValueCheckerUtils;
import org.checkerframework.common.value.qual.IntRangeFromNonNegative;
import org.checkerframework.common.value.qual.IntRangeFromPositive;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationBuilder;

public class SignednessAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror SIGNEDNESS_GLB;
    private final AnnotationMirror SIGNED;
    private final AnnotationMirror UNKNOWN_SIGNEDNESS;
    private final AnnotationMirror INT_RANGE_FROM_NON_NEGATIVE;
    private final AnnotationMirror INT_RANGE_FROM_POSITIVE;
    ValueAnnotatedTypeFactory valueFactory;
    private boolean computingAnnotatedTypeMirrorOfLHS;

    public SignednessAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.SIGNEDNESS_GLB = AnnotationBuilder.fromClass(this.elements, SignednessGlb.class);
        this.SIGNED = AnnotationBuilder.fromClass(this.elements, Signed.class);
        this.UNKNOWN_SIGNEDNESS = AnnotationBuilder.fromClass(this.elements, UnknownSignedness.class);
        this.INT_RANGE_FROM_NON_NEGATIVE = AnnotationBuilder.fromClass(this.elements, IntRangeFromNonNegative.class);
        this.INT_RANGE_FROM_POSITIVE = AnnotationBuilder.fromClass(this.elements, IntRangeFromPositive.class);
        this.valueFactory = (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
        this.computingAnnotatedTypeMirrorOfLHS = false;
        this.addAliasedAnnotation(SignedPositive.class, this.SIGNEDNESS_GLB);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        Set<Class<? extends Annotation>> result = this.getBundledTypeQualifiersWithoutPolyAll(new Class[0]);
        result.remove(SignedPositive.class);
        return result;
    }

    @Override
    protected void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        this.addUnknownSignednessToSomeLocals(tree, type);
        if (!this.computingAnnotatedTypeMirrorOfLHS) {
            this.addSignednessGlbAnnotation(tree, type);
        }
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
    }

    @Override
    public AnnotatedTypeMirror getAnnotatedTypeLhs(Tree lhsTree) {
        boolean oldComputingAnnotatedTypeMirrorOfLHS = this.computingAnnotatedTypeMirrorOfLHS;
        this.computingAnnotatedTypeMirrorOfLHS = true;
        AnnotatedTypeMirror result = super.getAnnotatedTypeLhs(lhsTree);
        this.computingAnnotatedTypeMirrorOfLHS = oldComputingAnnotatedTypeMirrorOfLHS;
        return result;
    }

    private void addSignednessGlbAnnotation(Tree tree, AnnotatedTypeMirror type) {
        TypeMirror javaType = type.getUnderlyingType();
        TypeKind javaTypeKind = javaType.getKind();
        if (tree.getKind() != Tree.Kind.VARIABLE && (javaTypeKind == TypeKind.BYTE || javaTypeKind == TypeKind.CHAR || javaTypeKind == TypeKind.SHORT || javaTypeKind == TypeKind.INT || javaTypeKind == TypeKind.LONG)) {
            AnnotatedTypeMirror valueATM = this.valueFactory.getAnnotatedType(tree);
            if ((valueATM.hasAnnotation(this.INT_RANGE_FROM_NON_NEGATIVE) || valueATM.hasAnnotation(this.INT_RANGE_FROM_POSITIVE)) && type.hasAnnotation(this.SIGNED)) {
                type.replaceAnnotation(this.SIGNEDNESS_GLB);
            } else {
                Range treeRange = ValueCheckerUtils.getPossibleValues(valueATM, this.valueFactory);
                if (treeRange != null) {
                    switch (javaType.getKind()) {
                        case BYTE: 
                        case CHAR: {
                            if (!treeRange.isWithin(0L, 127L)) break;
                            type.replaceAnnotation(this.SIGNEDNESS_GLB);
                            break;
                        }
                        case SHORT: {
                            if (!treeRange.isWithin(0L, 32767L)) break;
                            type.replaceAnnotation(this.SIGNEDNESS_GLB);
                            break;
                        }
                        case INT: {
                            if (!treeRange.isWithin(0L, Integer.MAX_VALUE)) break;
                            type.replaceAnnotation(this.SIGNEDNESS_GLB);
                            break;
                        }
                        case LONG: {
                            if (!treeRange.isWithin(0L, Long.MAX_VALUE)) break;
                            type.replaceAnnotation(this.SIGNEDNESS_GLB);
                            break;
                        }
                    }
                }
            }
        }
    }

    private void addUnknownSignednessToSomeLocals(Tree tree, AnnotatedTypeMirror type) {
        switch (type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                QualifierDefaults defaults = new QualifierDefaults(this.elements, this);
                defaults.addCheckedCodeDefault(this.UNKNOWN_SIGNEDNESS, TypeUseLocation.LOCAL_VARIABLE);
                defaults.annotate(tree, type);
                break;
            }
        }
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new SignednessTreeAnnotator(this), super.createTreeAnnotator());
    }

    private class SignednessTreeAnnotator
    extends TreeAnnotator {
        public SignednessTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        private void annotateBooleanAsUnknownSignedness(AnnotatedTypeMirror type) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    type.addAnnotation(SignednessAnnotatedTypeFactory.this.UNKNOWN_SIGNEDNESS);
                    break;
                }
            }
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            switch (tree.getKind()) {
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    AnnotatedTypeMirror lht = SignednessAnnotatedTypeFactory.this.getAnnotatedType(tree.getLeftOperand());
                    type.replaceAnnotations(lht.getAnnotations());
                    break;
                }
            }
            this.annotateBooleanAsUnknownSignedness(type);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree tree, AnnotatedTypeMirror type) {
            this.annotateBooleanAsUnknownSignedness(type);
            return null;
        }
    }
}

