/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.RangeOrListOfValues;
import org.checkerframework.common.value.ReflectiveEvaluator;
import org.checkerframework.common.value.ValueCheckerUtils;
import org.checkerframework.common.value.ValueMethodIdentifier;
import org.checkerframework.common.value.ValueTransfer;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.IntRangeFromGTENegativeOne;
import org.checkerframework.common.value.qual.IntRangeFromNonNegative;
import org.checkerframework.common.value.qual.IntRangeFromPositive;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.MinLenFieldInvariant;
import org.checkerframework.common.value.qual.PolyValue;
import org.checkerframework.common.value.qual.StaticallyExecutable;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.common.value.util.NumberUtils;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.StructuralEqualityComparer;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.LiteralTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.FieldInvariants;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class ValueAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected static final int MAX_VALUES = 10;
    protected static final Set<String> COVERED_CLASS_STRINGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("int", "java.lang.Integer", "double", "java.lang.Double", "byte", "java.lang.Byte", "java.lang.String", "char", "java.lang.Character", "float", "java.lang.Float", "boolean", "java.lang.Boolean", "long", "java.lang.Long", "short", "java.lang.Short", "char[]")));
    protected final AnnotationMirror UNKNOWNVAL;
    protected final AnnotationMirror BOTTOMVAL;
    public final AnnotationMirror POLY;
    private final boolean reportEvalWarnings;
    private final ReflectiveEvaluator evaluator;
    private final ValueMethodIdentifier methods;

    public ValueAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWNVAL = AnnotationBuilder.fromClass(this.elements, UnknownVal.class);
        this.BOTTOMVAL = AnnotationBuilder.fromClass(this.elements, BottomVal.class);
        this.POLY = AnnotationBuilder.fromClass(this.elements, PolyValue.class);
        this.reportEvalWarnings = checker.hasOption("reportEvalWarns");
        Range.ignoreOverflow = checker.hasOption("ignoreRangeOverflow");
        this.evaluator = new ReflectiveEvaluator(checker, this, this.reportEvalWarnings);
        this.addAliasedAnnotation("android.support.annotation.IntRange", IntRange.class, true, new String[0]);
        this.addAliasedAnnotation(MinLen.class, this.BOTTOMVAL);
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.Positive", this.createIntRangeFromPositive());
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.NonNegative", this.createIntRangeFromNonNegative());
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.GTENegativeOne", this.createIntRangeFromGTENegativeOne());
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.LengthOf", this.createIntRangeFromNonNegative());
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.IndexFor", this.createIntRangeFromNonNegative());
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.IndexOrHigh", this.createIntRangeFromNonNegative());
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.IndexOrLow", this.createIntRangeFromGTENegativeOne());
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.SubstringIndexFor", this.createIntRangeFromGTENegativeOne());
        this.addAliasedAnnotation("org.checkerframework.checker.index.qual.PolyLength", this.POLY);
        this.methods = new ValueMethodIdentifier(this.processingEnv);
        if (this.getClass().equals(ValueAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    ValueMethodIdentifier getMethodIdentifier() {
        return this.methods;
    }

    @Override
    public AnnotationMirror canonicalAnnotation(AnnotationMirror anno) {
        if (AnnotationUtils.areSameByClass(anno, MinLen.class)) {
            int from = this.getMinLenValue(anno);
            return this.createArrayLenRangeAnnotation(from, Integer.MAX_VALUE);
        }
        return super.canonicalAnnotation(anno);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(ArrayLen.class, ArrayLenRange.class, IntVal.class, IntRange.class, BoolVal.class, StringVal.class, DoubleVal.class, BottomVal.class, UnknownVal.class, IntRangeFromPositive.class, IntRangeFromNonNegative.class, IntRangeFromGTENegativeOne.class, PolyValue.class, PolyAll.class));
    }

    @Override
    public CFTransfer createFlowTransferFunction(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        return new ValueTransfer(analysis);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new ValueQualifierHierarchy(factory);
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new DefaultTypeHierarchy(this.checker, this.getQualifierHierarchy(), this.checker.getBooleanOption("ignoreRawTypeArguments", true), this.checker.hasOption("invariantArrays")){

            @Override
            public StructuralEqualityComparer createEqualityComparer() {
                return new StructuralEqualityComparer(this.typeargVisitHistory){

                    @Override
                    protected boolean arePrimeAnnosEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
                        type1.replaceAnnotation(ValueAnnotatedTypeFactory.this.convertSpecialIntRangeToStandardIntRange(type1.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL)));
                        type2.replaceAnnotation(ValueAnnotatedTypeFactory.this.convertSpecialIntRangeToStandardIntRange(type2.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL)));
                        type1.replaceAnnotation(ValueAnnotatedTypeFactory.this.convertToUnknown(type1.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL)));
                        type2.replaceAnnotation(ValueAnnotatedTypeFactory.this.convertToUnknown(type2.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL)));
                        return super.arePrimeAnnosEqual(type1, type2);
                    }
                };
            }
        };
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new ListTypeAnnotator(new ValueTypeAnnotator(this), super.createTypeAnnotator());
    }

    @Override
    public FieldInvariants getFieldInvariants(TypeElement element) {
        AnnotationMirror fieldInvarAnno = this.getDeclAnnotation(element, MinLenFieldInvariant.class);
        if (fieldInvarAnno == null) {
            return null;
        }
        List<String> fields = AnnotationUtils.getElementValueArray(fieldInvarAnno, "field", String.class, true);
        List<Integer> minlens = AnnotationUtils.getElementValueArray(fieldInvarAnno, "minLen", Integer.class, true);
        ArrayList<AnnotationMirror> qualifiers = new ArrayList<AnnotationMirror>();
        for (Integer minlen : minlens) {
            qualifiers.add(this.createArrayLenRangeAnnotation(minlen, Integer.MAX_VALUE));
        }
        FieldInvariants superInvariants = super.getFieldInvariants(element);
        return new FieldInvariants(superInvariants, fields, qualifiers);
    }

    @Override
    protected Set<Class<? extends Annotation>> getFieldInvariantDeclarationAnnotations() {
        HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>(super.getFieldInvariantDeclarationAnnotations());
        set.add(MinLenFieldInvariant.class);
        return set;
    }

    @Override
    public AnnotatedTypeFactory.ParameterizedExecutableType methodFromUse(ExpressionTree tree, ExecutableElement methodElt, AnnotatedTypeMirror receiverType) {
        AnnotatedTypeFactory.ParameterizedExecutableType superPair = super.methodFromUse(tree, methodElt, receiverType);
        if (ElementUtils.matchesElement(methodElt, "values", new Class[0]) && methodElt.getEnclosingElement().getKind() == ElementKind.ENUM && ElementUtils.isStatic(methodElt)) {
            int count = 0;
            List<? extends Element> l = methodElt.getEnclosingElement().getEnclosedElements();
            for (Element element : l) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                ++count;
            }
            AnnotationMirror am = this.createArrayLenAnnotation(Collections.singletonList(count));
            superPair.executableType.getReturnType().replaceAnnotation(am);
        }
        return superPair;
    }

    public long getFromValueFromIntRange(AnnotatedTypeMirror atm) {
        long from;
        AnnotationMirror anno = atm.getAnnotation(IntRange.class);
        if (AnnotationUtils.hasElementValue(anno, "from")) {
            return AnnotationUtils.getElementValue(anno, "from", Long.class, false);
        }
        switch (atm.getUnderlyingType().getKind()) {
            case INT: {
                from = Integer.MIN_VALUE;
                break;
            }
            case SHORT: {
                from = -32768L;
                break;
            }
            case BYTE: {
                from = -128L;
                break;
            }
            case CHAR: {
                from = 0L;
                break;
            }
            default: {
                from = Long.MIN_VALUE;
            }
        }
        return from;
    }

    public long getToValueFromIntRange(AnnotatedTypeMirror atm) {
        long to;
        AnnotationMirror anno = atm.getAnnotation(IntRange.class);
        if (AnnotationUtils.hasElementValue(anno, "to")) {
            return AnnotationUtils.getElementValue(anno, "to", Long.class, false);
        }
        switch (atm.getUnderlyingType().getKind()) {
            case INT: {
                to = Integer.MAX_VALUE;
                break;
            }
            case SHORT: {
                to = 32767L;
                break;
            }
            case BYTE: {
                to = 127L;
                break;
            }
            case CHAR: {
                to = 65535L;
                break;
            }
            default: {
                to = Long.MAX_VALUE;
            }
        }
        return to;
    }

    private List<Long> getArrayLenOrIntValue(AnnotationMirror anno) {
        List<Long> result;
        if (AnnotationUtils.areSameByClass(anno, ArrayLen.class)) {
            List<Integer> intValues = ValueAnnotatedTypeFactory.getArrayLength(anno);
            result = new ArrayList<Long>(intValues.size());
            for (Integer i : intValues) {
                result.add(i.longValue());
            }
        } else {
            result = ValueAnnotatedTypeFactory.getIntValues(anno);
        }
        return result;
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        TreeAnnotator arrayCreation = new TreeAnnotator(this){
            PropagationTreeAnnotator propagationTreeAnnotator;
            {
                this.propagationTreeAnnotator = new PropagationTreeAnnotator(this.atypeFactory);
            }

            @Override
            public Void visitNewArray(NewArrayTree node, AnnotatedTypeMirror mirror) {
                return this.propagationTreeAnnotator.visitNewArray(node, mirror);
            }
        };
        return new ListTreeAnnotator(new ValueTreeAnnotator(this), new LiteralTreeAnnotator(this).addStandardLiteralQualifiers(), arrayCreation);
    }

    private AnnotationMirror convertSpecialIntRangeToStandardIntRange(AnnotationMirror anm) {
        if (AnnotationUtils.areSameByClass(anm, IntRangeFromPositive.class)) {
            return this.createIntRangeAnnotation(1L, Integer.MAX_VALUE);
        }
        if (AnnotationUtils.areSameByClass(anm, IntRangeFromNonNegative.class)) {
            return this.createIntRangeAnnotation(0L, Integer.MAX_VALUE);
        }
        if (AnnotationUtils.areSameByClass(anm, IntRangeFromGTENegativeOne.class)) {
            return this.createIntRangeAnnotation(-1L, Integer.MAX_VALUE);
        }
        return anm;
    }

    private AnnotationMirror convertToUnknown(AnnotationMirror anno) {
        if (AnnotationUtils.areSameByClass(anno, ArrayLenRange.class)) {
            Range range = ValueAnnotatedTypeFactory.getRange(anno);
            if (range.from == 0L && range.to >= Integer.MAX_VALUE) {
                return this.UNKNOWNVAL;
            }
            return anno;
        }
        if (AnnotationUtils.areSameByClass(anno, IntRange.class)) {
            Range range = ValueAnnotatedTypeFactory.getRange(anno);
            if (range.isLongEverything()) {
                return this.UNKNOWNVAL;
            }
            return anno;
        }
        return anno;
    }

    AnnotationMirror createArrayLengthResultAnnotation(AnnotatedTypeMirror receiverType) {
        AnnotationMirror arrayAnno = receiverType.getAnnotationInHierarchy(this.UNKNOWNVAL);
        if (AnnotationUtils.areSameByClass(arrayAnno, ArrayLen.class)) {
            List<Integer> lengths = ValueAnnotatedTypeFactory.getArrayLength(arrayAnno);
            return this.createNumberAnnotationMirror(new ArrayList<Number>(lengths));
        }
        if (AnnotationUtils.areSameByClass(arrayAnno, ArrayLenRange.class)) {
            Range range = ValueAnnotatedTypeFactory.getRange(arrayAnno);
            return this.createIntRangeAnnotation(range);
        }
        if (AnnotationUtils.areSameByClass(arrayAnno, StringVal.class)) {
            List<String> strings = ValueAnnotatedTypeFactory.getStringValues(arrayAnno);
            List<Integer> lengths = ValueCheckerUtils.getLengthsForStringValues(strings);
            return this.createNumberAnnotationMirror(new ArrayList<Number>(lengths));
        }
        return this.createIntRangeAnnotation(0L, Integer.MAX_VALUE);
    }

    AnnotationMirror createResultingAnnotation(TypeMirror resultType, Object value) {
        return this.createResultingAnnotation(resultType, Collections.singletonList(value));
    }

    AnnotationMirror createResultingAnnotation(TypeMirror resultType, List<?> values) {
        TypeKind primitiveKind;
        if (values == null) {
            return this.UNKNOWNVAL;
        }
        values.remove(null);
        if (values.isEmpty()) {
            return this.BOTTOMVAL;
        }
        if (TypesUtils.isString(resultType)) {
            ArrayList<String> stringVals = new ArrayList<String>(values.size());
            for (Object o : values) {
                stringVals.add((String)o);
            }
            return this.createStringAnnotation(stringVals);
        }
        if (ValueCheckerUtils.getClassFromType(resultType) == char[].class) {
            ArrayList<String> stringVals = new ArrayList<String>(values.size());
            for (Object o : values) {
                if (o instanceof char[]) {
                    stringVals.add(new String((char[])o));
                    continue;
                }
                stringVals.add(o.toString());
            }
            return this.createStringAnnotation(stringVals);
        }
        if (TypesUtils.isPrimitive(resultType)) {
            primitiveKind = resultType.getKind();
        } else if (TypesUtils.isBoxedPrimitive(resultType)) {
            primitiveKind = this.types.unboxedType(resultType).getKind();
        } else {
            return this.UNKNOWNVAL;
        }
        switch (primitiveKind) {
            case BOOLEAN: {
                ArrayList<Boolean> boolVals = new ArrayList<Boolean>(values.size());
                for (Object o : values) {
                    boolVals.add((Boolean)o);
                }
                return this.createBooleanAnnotation(boolVals);
            }
            case INT: 
            case SHORT: 
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case LONG: {
                ArrayList<Number> numberVals = new ArrayList<Number>(values.size());
                ArrayList<Character> characterVals = new ArrayList<Character>(values.size());
                for (Object o : values) {
                    if (o instanceof Character) {
                        characterVals.add((Character)o);
                        continue;
                    }
                    numberVals.add((Number)o);
                }
                if (numberVals.isEmpty()) {
                    return this.createCharAnnotation(characterVals);
                }
                return this.createNumberAnnotationMirror(new ArrayList<Number>(numberVals));
            }
            case CHAR: {
                ArrayList<Character> charVals = new ArrayList<Character>(values.size());
                for (Object o : values) {
                    if (o instanceof Number) {
                        charVals.add(Character.valueOf((char)((Number)o).intValue()));
                        continue;
                    }
                    charVals.add(Character.valueOf(((Character)o).charValue()));
                }
                return this.createCharAnnotation(charVals);
            }
        }
        throw new UnsupportedOperationException("Unexpected kind:" + resultType);
    }

    public AnnotationMirror createIntValAnnotation(List<Long> values) {
        if (values == null) {
            return this.UNKNOWNVAL;
        }
        if (values.isEmpty()) {
            return this.BOTTOMVAL;
        }
        if ((values = ValueCheckerUtils.removeDuplicates(values)).size() > 10) {
            long valMin = Collections.min(values);
            long valMax = Collections.max(values);
            return this.createIntRangeAnnotation(valMin, valMax);
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, IntVal.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    public AnnotationMirror convertIntRangeToIntVal(AnnotationMirror intRangeAnno) {
        Range range = ValueAnnotatedTypeFactory.getRange(intRangeAnno);
        List<Long> values = ValueCheckerUtils.getValuesFromRange(range, Long.class);
        return this.createIntValAnnotation(values);
    }

    public AnnotationMirror createDoubleValAnnotation(List<Double> values) {
        if (values == null) {
            return this.UNKNOWNVAL;
        }
        if (values.isEmpty()) {
            return this.BOTTOMVAL;
        }
        if ((values = ValueCheckerUtils.removeDuplicates(values)).size() > 10) {
            return this.UNKNOWNVAL;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, DoubleVal.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    private AnnotationMirror convertIntValToDoubleVal(AnnotationMirror intValAnno) {
        List<Long> intValues = ValueAnnotatedTypeFactory.getIntValues(intValAnno);
        return this.createDoubleValAnnotation(this.convertLongListToDoubleList(intValues));
    }

    private List<Double> convertLongListToDoubleList(List<Long> intValues) {
        ArrayList<Double> doubleValues = new ArrayList<Double>(intValues.size());
        for (Long intValue : intValues) {
            doubleValues.add(intValue.doubleValue());
        }
        return doubleValues;
    }

    public AnnotationMirror createStringAnnotation(List<String> values) {
        if (values == null) {
            return this.UNKNOWNVAL;
        }
        if (values.isEmpty()) {
            return this.BOTTOMVAL;
        }
        if ((values = ValueCheckerUtils.removeDuplicates(values)).size() > 10) {
            List<Integer> lengths = ValueCheckerUtils.getLengthsForStringValues(values);
            return this.createArrayLenAnnotation(lengths);
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, StringVal.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    public AnnotationMirror createArrayLenAnnotation(List<Integer> values) {
        if (values == null) {
            return this.UNKNOWNVAL;
        }
        if (values.isEmpty()) {
            return this.BOTTOMVAL;
        }
        if ((values = ValueCheckerUtils.removeDuplicates(values)).isEmpty() || Collections.min(values) < 0) {
            return this.BOTTOMVAL;
        }
        if (values.size() > 10) {
            return this.createArrayLenRangeAnnotation(Collections.min(values), Collections.max(values));
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, ArrayLen.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    public AnnotationMirror createBooleanAnnotation(List<Boolean> values) {
        if (values == null) {
            return this.UNKNOWNVAL;
        }
        if (values.isEmpty()) {
            return this.BOTTOMVAL;
        }
        if ((values = ValueCheckerUtils.removeDuplicates(values)).size() > 10) {
            return this.UNKNOWNVAL;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, BoolVal.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    public AnnotationMirror createCharAnnotation(List<Character> values) {
        if (values == null) {
            return this.UNKNOWNVAL;
        }
        if (values.isEmpty()) {
            return this.BOTTOMVAL;
        }
        if ((values = ValueCheckerUtils.removeDuplicates(values)).size() > 10) {
            return this.UNKNOWNVAL;
        }
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (char value : values) {
            longValues.add(Long.valueOf(value));
        }
        return this.createIntValAnnotation(longValues);
    }

    public AnnotationMirror createNumberAnnotationMirror(List<Number> values) {
        if (values == null) {
            return this.UNKNOWNVAL;
        }
        if (values.isEmpty()) {
            return this.BOTTOMVAL;
        }
        Number first = values.get(0);
        if (first instanceof Integer || first instanceof Short || first instanceof Long || first instanceof Byte) {
            ArrayList<Long> intValues = new ArrayList<Long>();
            for (Number number : values) {
                intValues.add(number.longValue());
            }
            return this.createIntValAnnotation(intValues);
        }
        if (first instanceof Double || first instanceof Float) {
            ArrayList<Double> intValues = new ArrayList<Double>();
            for (Number number : values) {
                intValues.add(number.doubleValue());
            }
            return this.createDoubleValAnnotation(intValues);
        }
        throw new UnsupportedOperationException("ValueAnnotatedTypeFactory: unexpected class: " + first.getClass());
    }

    private AnnotationMirror createIntRangeAnnotation(long from, long to) {
        assert (from <= to);
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, IntRange.class);
        builder.setValue((CharSequence)"from", from);
        builder.setValue((CharSequence)"to", to);
        return builder.build();
    }

    public AnnotationMirror createIntRangeAnnotation(Range range) {
        if (range.isNothing()) {
            return this.BOTTOMVAL;
        }
        if (range.isLongEverything()) {
            return this.UNKNOWNVAL;
        }
        if (range.isWiderThan(10L)) {
            return this.createIntRangeAnnotation(range.from, range.to);
        }
        List<Long> newValues = ValueCheckerUtils.getValuesFromRange(range, Long.class);
        return this.createIntValAnnotation(newValues);
    }

    private AnnotationMirror createIntRangeFromPositive() {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, IntRangeFromPositive.class);
        return builder.build();
    }

    private AnnotationMirror createIntRangeFromNonNegative() {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, IntRangeFromNonNegative.class);
        return builder.build();
    }

    private AnnotationMirror createIntRangeFromGTENegativeOne() {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, IntRangeFromGTENegativeOne.class);
        return builder.build();
    }

    public AnnotationMirror createArrayLenRangeAnnotation(int from, int to) {
        assert (from <= to);
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, ArrayLenRange.class);
        builder.setValue((CharSequence)"from", from);
        builder.setValue((CharSequence)"to", to);
        return builder.build();
    }

    public AnnotationMirror createArrayLenRangeAnnotation(Range range) {
        if (range.isNothing()) {
            return this.BOTTOMVAL;
        }
        if (range.isLongEverything() || !range.isWithin(Integer.MIN_VALUE, Integer.MAX_VALUE)) {
            return this.UNKNOWNVAL;
        }
        return this.createArrayLenRangeAnnotation(Long.valueOf(range.from).intValue(), Long.valueOf(range.to).intValue());
    }

    private AnnotationMirror convertStringValToArrayLenRange(AnnotationMirror stringValAnno) {
        List<String> values = ValueAnnotatedTypeFactory.getStringValues(stringValAnno);
        List<Integer> lengths = ValueCheckerUtils.getLengthsForStringValues(values);
        return this.createArrayLenRangeAnnotation(Collections.min(lengths), Collections.max(lengths));
    }

    private AnnotationMirror convertStringValToArrayLen(AnnotationMirror stringValAnno) {
        List<String> values = ValueAnnotatedTypeFactory.getStringValues(stringValAnno);
        return this.createArrayLenAnnotation(ValueCheckerUtils.getLengthsForStringValues(values));
    }

    public AnnotationMirror convertArrayLenToArrayLenRange(AnnotationMirror arrayLenAnno) {
        List<Integer> values = ValueAnnotatedTypeFactory.getArrayLength(arrayLenAnno);
        return this.createArrayLenRangeAnnotation(Collections.min(values), Collections.max(values));
    }

    public AnnotationMirror convertIntValToIntRange(AnnotationMirror intValAnno) {
        List<Long> intValues = ValueAnnotatedTypeFactory.getIntValues(intValAnno);
        return this.createIntRangeAnnotation(Collections.min(intValues), Collections.max(intValues));
    }

    public static Range getRange(AnnotationMirror rangeAnno) {
        if (rangeAnno == null) {
            return null;
        }
        if (AnnotationUtils.areSameByClass(rangeAnno, IntRangeFromPositive.class)) {
            return new Range(1L, Integer.MAX_VALUE);
        }
        if (AnnotationUtils.areSameByClass(rangeAnno, IntRangeFromNonNegative.class)) {
            return new Range(0L, Integer.MAX_VALUE);
        }
        if (AnnotationUtils.areSameByClass(rangeAnno, IntRangeFromGTENegativeOne.class)) {
            return new Range(-1L, Integer.MAX_VALUE);
        }
        if (AnnotationUtils.areSameByClass(rangeAnno, IntVal.class)) {
            return ValueCheckerUtils.getRangeFromValues(ValueAnnotatedTypeFactory.getIntValues(rangeAnno));
        }
        if (AnnotationUtils.areSameByClass(rangeAnno, IntRange.class)) {
            return new Range(AnnotationUtils.getElementValue(rangeAnno, "from", Long.class, true), AnnotationUtils.getElementValue(rangeAnno, "to", Long.class, true));
        }
        if (AnnotationUtils.areSameByClass(rangeAnno, ArrayLenRange.class)) {
            return new Range(AnnotationUtils.getElementValue(rangeAnno, "from", Integer.class, true).intValue(), AnnotationUtils.getElementValue(rangeAnno, "to", Integer.class, true).intValue());
        }
        return null;
    }

    public static List<Long> getIntValues(AnnotationMirror intAnno) {
        if (intAnno == null) {
            return null;
        }
        List<Long> list = AnnotationUtils.getElementValueArray(intAnno, "value", Long.class, true);
        list = ValueCheckerUtils.removeDuplicates(list);
        return list;
    }

    public static List<Double> getDoubleValues(AnnotationMirror doubleAnno) {
        if (doubleAnno == null) {
            return null;
        }
        List<Double> list = AnnotationUtils.getElementValueArray(doubleAnno, "value", Double.class, true);
        list = ValueCheckerUtils.removeDuplicates(list);
        return list;
    }

    public static List<Integer> getArrayLength(AnnotationMirror arrayAnno) {
        if (arrayAnno == null) {
            return null;
        }
        List<Integer> list = AnnotationUtils.getElementValueArray(arrayAnno, "value", Integer.class, true);
        list = ValueCheckerUtils.removeDuplicates(list);
        return list;
    }

    public static List<Character> getCharValues(AnnotationMirror intAnno) {
        if (intAnno == null) {
            return new ArrayList<Character>();
        }
        List<Long> intValues = AnnotationUtils.getElementValueArray(intAnno, "value", Long.class, true);
        TreeSet<Character> charValues = new TreeSet<Character>();
        for (Long i : intValues) {
            charValues.add(Character.valueOf((char)i.intValue()));
        }
        return new ArrayList<Character>(charValues);
    }

    public static List<Boolean> getBooleanValues(AnnotationMirror boolAnno) {
        if (boolAnno == null) {
            return new ArrayList<Boolean>();
        }
        List<Boolean> boolValues = AnnotationUtils.getElementValueArray(boolAnno, "value", Boolean.class, true);
        TreeSet<Boolean> boolSet = new TreeSet<Boolean>(boolValues);
        if (boolSet.size() > 1) {
            return null;
        }
        return new ArrayList<Boolean>(boolSet);
    }

    public static List<String> getStringValues(AnnotationMirror stringAnno) {
        if (stringAnno == null) {
            return null;
        }
        List<String> list = AnnotationUtils.getElementValueArray(stringAnno, "value", String.class, true);
        list = ValueCheckerUtils.removeDuplicates(list);
        return list;
    }

    public boolean isIntRange(Set<AnnotationMirror> anmSet) {
        for (AnnotationMirror anm : anmSet) {
            if (!this.isIntRange(anm)) continue;
            return true;
        }
        return false;
    }

    public boolean isIntRange(AnnotationMirror anm) {
        return AnnotationUtils.areSameByClass(anm, IntRange.class) || AnnotationUtils.areSameByClass(anm, IntRangeFromPositive.class) || AnnotationUtils.areSameByClass(anm, IntRangeFromNonNegative.class) || AnnotationUtils.areSameByClass(anm, IntRangeFromGTENegativeOne.class);
    }

    public int getMinLenValue(AnnotatedTypeMirror atm) {
        return this.getMinLenValue(atm.getAnnotationInHierarchy(this.UNKNOWNVAL));
    }

    public Integer getMaxLenValue(AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        if (AnnotationUtils.areSameByClass(annotation, ArrayLenRange.class)) {
            return Long.valueOf(ValueAnnotatedTypeFactory.getRange((AnnotationMirror)annotation).to).intValue();
        }
        if (AnnotationUtils.areSameByClass(annotation, ArrayLen.class)) {
            return Collections.max(ValueAnnotatedTypeFactory.getArrayLength(annotation));
        }
        if (AnnotationUtils.areSameByClass(annotation, StringVal.class)) {
            return Collections.max(ValueCheckerUtils.getLengthsForStringValues(ValueAnnotatedTypeFactory.getStringValues(annotation)));
        }
        return null;
    }

    private Integer getSpecifiedMinLenValue(AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        if (AnnotationUtils.areSameByClass(annotation, MinLen.class)) {
            return AnnotationUtils.getElementValue(annotation, "value", Integer.class, true);
        }
        if (AnnotationUtils.areSameByClass(annotation, ArrayLenRange.class)) {
            return Long.valueOf(ValueAnnotatedTypeFactory.getRange((AnnotationMirror)annotation).from).intValue();
        }
        if (AnnotationUtils.areSameByClass(annotation, ArrayLen.class)) {
            return Collections.min(ValueAnnotatedTypeFactory.getArrayLength(annotation));
        }
        if (AnnotationUtils.areSameByClass(annotation, StringVal.class)) {
            return Collections.min(ValueCheckerUtils.getLengthsForStringValues(ValueAnnotatedTypeFactory.getStringValues(annotation)));
        }
        return null;
    }

    public int getMinLenValue(AnnotationMirror annotation) {
        Integer minLen = this.getSpecifiedMinLenValue(annotation);
        if (minLen == null || minLen < 0) {
            return 0;
        }
        return minLen;
    }

    public Long getMinimumIntegralValue(AnnotatedTypeMirror atm) {
        AnnotationMirror anm = atm.getAnnotationInHierarchy(this.UNKNOWNVAL);
        if (AnnotationUtils.areSameByClass(anm, IntVal.class)) {
            List<Long> possibleValues = ValueAnnotatedTypeFactory.getIntValues(anm);
            return Collections.min(possibleValues);
        }
        if (this.isIntRange(anm)) {
            Range range = ValueAnnotatedTypeFactory.getRange(anm);
            return range.from;
        }
        return null;
    }

    public int getMinLenFromString(String sequenceExpression, Tree tree, TreePath currentPath) {
        AnnotationMirror lengthAnno;
        FlowExpressions.Receiver expressionObj;
        try {
            expressionObj = this.getReceiverFromJavaExpressionString(sequenceExpression, currentPath);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
            return 0;
        }
        if (expressionObj instanceof FlowExpressions.ValueLiteral) {
            FlowExpressions.ValueLiteral sequenceLiteral = (FlowExpressions.ValueLiteral)expressionObj;
            Object sequenceLiteralValue = sequenceLiteral.getValue();
            if (sequenceLiteralValue instanceof String) {
                return ((String)sequenceLiteralValue).length();
            }
        } else if (expressionObj instanceof FlowExpressions.ArrayCreation) {
            FlowExpressions.ArrayCreation arrayCreation = (FlowExpressions.ArrayCreation)expressionObj;
            return arrayCreation.getInitializers().size();
        }
        if ((lengthAnno = this.getAnnotationFromReceiver(expressionObj, tree, ArrayLenRange.class)) == null) {
            lengthAnno = this.getAnnotationFromReceiver(expressionObj, tree, ArrayLen.class);
        }
        if (lengthAnno == null) {
            lengthAnno = this.getAnnotationFromReceiver(expressionObj, tree, StringVal.class);
        }
        if (lengthAnno == null) {
            return 0;
        }
        return this.getMinLenValue(lengthAnno);
    }

    @Override
    public AnnotatedTypeMirror getDummyAssignedTo(ExpressionTree expressionTree) {
        TypeMirror type = TreeUtils.typeOf(expressionTree);
        if (type.getKind() != TypeKind.VOID) {
            AnnotatedTypeMirror atm = this.type(expressionTree);
            this.addDefaultAnnotations(atm);
            return atm;
        }
        return null;
    }

    protected class ValueTreeAnnotator
    extends TreeAnnotator {
        public ValueTreeAnnotator(ValueAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitNewArray(NewArrayTree tree, AnnotatedTypeMirror type) {
            List<? extends ExpressionTree> dimensions = tree.getDimensions();
            List<? extends ExpressionTree> initializers = tree.getInitializers();
            if (!dimensions.isEmpty()) {
                this.handleDimensions(dimensions, (AnnotatedTypeMirror.AnnotatedArrayType)type);
            } else {
                this.handleInitializers(initializers, (AnnotatedTypeMirror.AnnotatedArrayType)type);
                Class<?> clazz = ValueCheckerUtils.getClassFromType(type.getUnderlyingType());
                String stringVal = null;
                if (clazz.equals(char[].class)) {
                    stringVal = this.getCharArrayStringVal(initializers);
                }
                if (stringVal != null) {
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createStringAnnotation(Collections.singletonList(stringVal));
                    type.replaceAnnotation(newQual);
                }
            }
            return null;
        }

        private void handleDimensions(List<? extends ExpressionTree> dimensions, AnnotatedTypeMirror.AnnotatedArrayType type) {
            AnnotationMirror dimType;
            if (dimensions.size() > 1) {
                this.handleDimensions(dimensions.subList(1, dimensions.size()), (AnnotatedTypeMirror.AnnotatedArrayType)type.getComponentType());
            }
            if (AnnotationUtils.areSameByName(dimType = ValueAnnotatedTypeFactory.this.getAnnotatedType(dimensions.get(0)).getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL), ValueAnnotatedTypeFactory.this.BOTTOMVAL)) {
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.BOTTOMVAL);
            } else {
                RangeOrListOfValues rolv = null;
                if (ValueAnnotatedTypeFactory.this.isIntRange(dimType)) {
                    rolv = new RangeOrListOfValues(ValueAnnotatedTypeFactory.getRange(dimType));
                } else if (AnnotationUtils.areSameByClass(dimType, IntVal.class)) {
                    rolv = new RangeOrListOfValues(RangeOrListOfValues.convertLongsToInts(ValueAnnotatedTypeFactory.getIntValues(dimType)));
                }
                if (rolv != null) {
                    AnnotationMirror newQual = rolv.createAnnotation((ValueAnnotatedTypeFactory)this.atypeFactory);
                    type.replaceAnnotation(newQual);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void handleInitializers(List<? extends ExpressionTree> initializers, AnnotatedTypeMirror.AnnotatedArrayType type) {
            void var6_8;
            ArrayList<Integer> array = new ArrayList<Integer>();
            array.add(initializers.size());
            type.replaceAnnotation(ValueAnnotatedTypeFactory.this.createArrayLenAnnotation(array));
            if (type.getComponentType().getKind() != TypeKind.ARRAY) {
                return;
            }
            ArrayList<RangeOrListOfValues> arrayLenOfDimensions = new ArrayList<RangeOrListOfValues>();
            for (ExpressionTree expressionTree : initializers) {
                AnnotatedTypeMirror componentType = ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree);
                int dimension = 0;
                while (componentType.getKind() == TypeKind.ARRAY) {
                    AnnotationMirror arrayLen;
                    RangeOrListOfValues rolv = null;
                    if (dimension < arrayLenOfDimensions.size()) {
                        rolv = (RangeOrListOfValues)arrayLenOfDimensions.get(dimension);
                    }
                    if ((arrayLen = componentType.getAnnotation(ArrayLen.class)) != null) {
                        List<Integer> currentLengths = ValueAnnotatedTypeFactory.getArrayLength(arrayLen);
                        if (rolv != null) {
                            rolv.addAll(currentLengths);
                        } else {
                            arrayLenOfDimensions.add(new RangeOrListOfValues(currentLengths));
                        }
                    } else {
                        AnnotationMirror arrayLenRangeAnno = componentType.getAnnotation(ArrayLenRange.class);
                        Range range = arrayLenRangeAnno != null ? ValueAnnotatedTypeFactory.getRange(arrayLenRangeAnno) : Range.EVERYTHING;
                        if (rolv != null) {
                            rolv.add(range);
                        } else {
                            arrayLenOfDimensions.add(new RangeOrListOfValues(range));
                        }
                    }
                    ++dimension;
                    componentType = ((AnnotatedTypeMirror.AnnotatedArrayType)componentType).getComponentType();
                }
            }
            AnnotatedTypeMirror componentType = type.getComponentType();
            boolean bl = false;
            while (componentType.getKind() == TypeKind.ARRAY && var6_8 < arrayLenOfDimensions.size()) {
                RangeOrListOfValues rolv = (RangeOrListOfValues)arrayLenOfDimensions.get((int)var6_8);
                componentType.addAnnotation(rolv.createAnnotation((ValueAnnotatedTypeFactory)this.atypeFactory));
                componentType = ((AnnotatedTypeMirror.AnnotatedArrayType)componentType).getComponentType();
                ++var6_8;
            }
        }

        private String getCharArrayStringVal(List<? extends ExpressionTree> initializers) {
            boolean allLiterals = true;
            StringBuilder stringVal = new StringBuilder();
            for (ExpressionTree expressionTree : initializers) {
                Range range = ValueAnnotatedTypeFactory.getRange(ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree).getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL));
                if (range != null && range.from == range.to) {
                    char charVal = (char)range.from;
                    stringVal.append(charVal);
                    continue;
                }
                allLiterals = false;
                break;
            }
            if (allLiterals) {
                return stringVal.toString();
            }
            return null;
        }

        @Override
        public Void visitTypeCast(TypeCastTree tree, AnnotatedTypeMirror atm) {
            if (this.handledByValueChecker(atm)) {
                Range range;
                AnnotationMirror newAnno;
                AnnotationMirror oldAnno = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression()).getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
                if (oldAnno == null) {
                    return null;
                }
                TypeMirror newType = atm.getUnderlyingType();
                if (TypesUtils.isString(newType) || newType.getKind() == TypeKind.ARRAY) {
                    newAnno = oldAnno;
                } else if (ValueAnnotatedTypeFactory.this.isIntRange(oldAnno) && (range = ValueAnnotatedTypeFactory.getRange(oldAnno)).isWiderThan(10L)) {
                    Class<?> newClass = ValueCheckerUtils.getClassFromType(newType);
                    if (newClass == String.class) {
                        newAnno = ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
                    } else {
                        if (newClass == Boolean.class || newClass == Boolean.TYPE) {
                            throw new UnsupportedOperationException("ValueAnnotatedTypeFactory: can't convert int to boolean");
                        }
                        newAnno = ValueAnnotatedTypeFactory.this.createIntRangeAnnotation(NumberUtils.castRange(newType, range));
                    }
                } else {
                    List<?> values = ValueCheckerUtils.getValuesCastedToType(oldAnno, newType);
                    newAnno = ValueAnnotatedTypeFactory.this.createResultingAnnotation(atm.getUnderlyingType(), values);
                }
                atm.addMissingAnnotations(Collections.singleton(newAnno));
            } else if (atm.getKind() == TypeKind.ARRAY && tree.getExpression().getKind() == Tree.Kind.NULL_LITERAL) {
                atm.addMissingAnnotations(Collections.singleton(ValueAnnotatedTypeFactory.this.BOTTOMVAL));
            }
            return null;
        }

        private List<?> getValues(AnnotatedTypeMirror type, TypeMirror castTo) {
            AnnotationMirror anno = type.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            if (anno == null) {
                return null;
            }
            return ValueCheckerUtils.getValuesCastedToType(anno, castTo);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (!this.handledByValueChecker(type)) {
                return null;
            }
            Object value = tree.getValue();
            switch (tree.getKind()) {
                case BOOLEAN_LITERAL: {
                    AnnotationMirror boolAnno = ValueAnnotatedTypeFactory.this.createBooleanAnnotation(Collections.singletonList((Boolean)value));
                    type.replaceAnnotation(boolAnno);
                    return null;
                }
                case CHAR_LITERAL: {
                    AnnotationMirror charAnno = ValueAnnotatedTypeFactory.this.createCharAnnotation(Collections.singletonList((Character)value));
                    type.replaceAnnotation(charAnno);
                    return null;
                }
                case DOUBLE_LITERAL: 
                case FLOAT_LITERAL: 
                case INT_LITERAL: 
                case LONG_LITERAL: {
                    AnnotationMirror numberAnno = ValueAnnotatedTypeFactory.this.createNumberAnnotationMirror(Collections.singletonList((Number)value));
                    type.replaceAnnotation(numberAnno);
                    return null;
                }
                case STRING_LITERAL: {
                    AnnotationMirror stringAnno = ValueAnnotatedTypeFactory.this.createStringAnnotation(Collections.singletonList((String)value));
                    type.replaceAnnotation(stringAnno);
                    return null;
                }
            }
            return null;
        }

        private boolean methodIsStaticallyExecutable(Element method) {
            return ValueAnnotatedTypeFactory.this.getDeclAnnotation(method, StaticallyExecutable.class) != null;
        }

        private Range getRangeForMathMinMax(MethodInvocationTree tree) {
            if (ValueAnnotatedTypeFactory.this.getMethodIdentifier().isMathMin(tree, ValueAnnotatedTypeFactory.this.processingEnv)) {
                AnnotatedTypeMirror arg1 = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotatedTypeMirror arg2 = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(1));
                Range rangeArg1 = ValueAnnotatedTypeFactory.getRange(arg1.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL));
                Range rangeArg2 = ValueAnnotatedTypeFactory.getRange(arg2.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL));
                if (rangeArg1 != null && rangeArg2 != null) {
                    return rangeArg1.min(rangeArg2);
                }
            } else if (ValueAnnotatedTypeFactory.this.getMethodIdentifier().isMathMax(tree, ValueAnnotatedTypeFactory.this.processingEnv)) {
                AnnotatedTypeMirror arg1 = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotatedTypeMirror arg2 = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(1));
                Range rangeArg1 = ValueAnnotatedTypeFactory.getRange(arg1.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL));
                Range rangeArg2 = ValueAnnotatedTypeFactory.getRange(arg2.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL));
                if (rangeArg1 != null && rangeArg2 != null) {
                    return rangeArg1.max(rangeArg2);
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            void var6_10;
            List<?> returnValues;
            ArrayList argValues;
            Range range;
            if (type.hasAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL) && (range = this.getRangeForMathMinMax(tree)) != null) {
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.createIntRangeAnnotation(range));
            }
            if (!this.methodIsStaticallyExecutable(TreeUtils.elementFromUse(tree)) || !this.handledByValueChecker(type)) {
                return null;
            }
            if (ValueAnnotatedTypeFactory.this.getMethodIdentifier().isStringLengthInvocation(tree, ValueAnnotatedTypeFactory.this.processingEnv)) {
                AnnotatedTypeMirror receiverType = ValueAnnotatedTypeFactory.this.getReceiverType(tree);
                AnnotationMirror resultAnno = ValueAnnotatedTypeFactory.this.createArrayLengthResultAnnotation(receiverType);
                if (resultAnno != null) {
                    type.replaceAnnotation(resultAnno);
                }
                return null;
            }
            List<? extends ExpressionTree> arguments = tree.getArguments();
            if (arguments.isEmpty()) {
                argValues = null;
            } else {
                argValues = new ArrayList();
                for (ExpressionTree expressionTree : arguments) {
                    AnnotatedTypeMirror argType = ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree);
                    List<?> values = this.getValues(argType, argType.getUnderlyingType());
                    if (values == null || values.isEmpty()) {
                        return null;
                    }
                    argValues.add(values);
                }
            }
            AnnotatedTypeMirror receiver = ValueAnnotatedTypeFactory.this.getReceiverType(tree);
            if (receiver != null && !ElementUtils.isStatic(TreeUtils.elementFromUse(tree))) {
                List<?> list = this.getValues(receiver, receiver.getUnderlyingType());
                if (list == null || list.isEmpty()) {
                    return null;
                }
            } else {
                Object var6_9 = null;
            }
            if ((returnValues = ValueAnnotatedTypeFactory.this.evaluator.evaluateMethodCall(argValues, (List<?>)var6_10, tree)) == null) {
                return null;
            }
            AnnotationMirror returnType = ValueAnnotatedTypeFactory.this.createResultingAnnotation(type.getUnderlyingType(), returnValues);
            type.replaceAnnotation(returnType);
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree tree, AnnotatedTypeMirror type) {
            ArrayList argValues;
            if (!this.methodIsStaticallyExecutable(TreeUtils.elementFromUse(tree)) || !this.handledByValueChecker(type)) {
                return null;
            }
            List<? extends ExpressionTree> arguments = tree.getArguments();
            if (arguments.isEmpty()) {
                argValues = null;
            } else {
                argValues = new ArrayList();
                for (ExpressionTree expressionTree : arguments) {
                    AnnotatedTypeMirror argType = ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree);
                    List<?> values = this.getValues(argType, argType.getUnderlyingType());
                    if (values == null || values.isEmpty()) {
                        return null;
                    }
                    argValues.add(values);
                }
            }
            List<?> returnValues = ValueAnnotatedTypeFactory.this.evaluator.evaluteConstructorCall(argValues, tree, type.getUnderlyingType());
            if (returnValues == null) {
                return null;
            }
            AnnotationMirror annotationMirror = ValueAnnotatedTypeFactory.this.createResultingAnnotation(type.getUnderlyingType(), returnValues);
            type.replaceAnnotation(annotationMirror);
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            AnnotationMirror resultAnno;
            AnnotatedTypeMirror receiverType;
            Element e;
            if (!TreeUtils.isFieldAccess(tree) || !this.handledByValueChecker(type)) {
                return null;
            }
            VariableElement elem = (VariableElement)TreeUtils.elementFromTree(tree);
            Object value = elem.getConstantValue();
            if (value != null) {
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.createResultingAnnotation(type.getUnderlyingType(), value));
                return null;
            }
            if (ElementUtils.isStatic(elem) && ElementUtils.isFinal(elem) && (e = TreeUtils.elementFromTree(tree.getExpression())) != null) {
                String classname = ElementUtils.getQualifiedClassName(e).toString();
                String fieldName = tree.getIdentifier().toString();
                value = ValueAnnotatedTypeFactory.this.evaluator.evaluateStaticFieldAccess(classname, fieldName, tree);
                if (value != null) {
                    type.replaceAnnotation(ValueAnnotatedTypeFactory.this.createResultingAnnotation(type.getUnderlyingType(), value));
                }
                return null;
            }
            if (TreeUtils.isArrayLengthAccess(tree) && (receiverType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression())).getKind() == TypeKind.ARRAY && (resultAnno = ValueAnnotatedTypeFactory.this.createArrayLengthResultAnnotation(receiverType)) != null) {
                type.replaceAnnotation(resultAnno);
            }
            return null;
        }

        private boolean handledByValueChecker(AnnotatedTypeMirror type) {
            TypeMirror tm = type.getUnderlyingType();
            return COVERED_CLASS_STRINGS.contains(tm.toString());
        }

        @Override
        public Void visitConditionalExpression(ConditionalExpressionTree node, AnnotatedTypeMirror annotatedTypeMirror) {
            annotatedTypeMirror.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            return null;
        }
    }

    private final class ValueQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public ValueQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        private AnnotationMirror glbOfStringVal(AnnotationMirror stringValAnno, AnnotationMirror otherAnno) {
            List<String> values = ValueAnnotatedTypeFactory.getStringValues(stringValAnno);
            if (AnnotationUtils.areSameByClass(otherAnno, StringVal.class)) {
                List<String> otherValues = ValueAnnotatedTypeFactory.getStringValues(otherAnno);
                values.retainAll(otherValues);
            } else if (AnnotationUtils.areSameByClass(otherAnno, ArrayLen.class)) {
                List<Integer> otherLengths = ValueAnnotatedTypeFactory.getArrayLength(otherAnno);
                ArrayList<String> result = new ArrayList<String>();
                for (String s2 : values) {
                    if (!otherLengths.contains(s2.length())) continue;
                    result.add(s2);
                }
                values = result;
            } else if (AnnotationUtils.areSameByClass(otherAnno, ArrayLenRange.class)) {
                Range otherRange = ValueAnnotatedTypeFactory.getRange(otherAnno);
                ArrayList<String> result = new ArrayList<String>();
                for (String s3 : values) {
                    if (!otherRange.contains(s3.length())) continue;
                    result.add(s3);
                }
                values = result;
            } else {
                return ValueAnnotatedTypeFactory.this.BOTTOMVAL;
            }
            return ValueAnnotatedTypeFactory.this.createStringAnnotation(values);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (this.isSubtype(a1, a2)) {
                return a1;
            }
            if (this.isSubtype(a2, a1)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a1, StringVal.class)) {
                return this.glbOfStringVal(a1, a2);
            }
            if (AnnotationUtils.areSameByClass(a2, StringVal.class)) {
                return this.glbOfStringVal(a2, a1);
            }
            return ValueAnnotatedTypeFactory.this.BOTTOMVAL;
        }

        @Override
        public int numberOfIterationsBeforeWidening() {
            return 11;
        }

        @Override
        public AnnotationMirror widenedUpperBound(AnnotationMirror newQualifier, AnnotationMirror previousQualifier) {
            AnnotationMirror lub = this.leastUpperBound(newQualifier, previousQualifier);
            if (AnnotationUtils.areSameByClass(lub, IntRange.class)) {
                Range lubRange = ValueAnnotatedTypeFactory.getRange(lub);
                Range newRange = ValueAnnotatedTypeFactory.getRange(newQualifier);
                Range oldRange = ValueAnnotatedTypeFactory.getRange(previousQualifier);
                Range wubRange = this.widenedRange(newRange, oldRange, lubRange);
                return ValueAnnotatedTypeFactory.this.createIntRangeAnnotation(wubRange);
            }
            if (AnnotationUtils.areSameByClass(lub, ArrayLenRange.class)) {
                Range lubRange = ValueAnnotatedTypeFactory.getRange(lub);
                Range newRange = ValueAnnotatedTypeFactory.getRange(newQualifier);
                Range oldRange = ValueAnnotatedTypeFactory.getRange(previousQualifier);
                return ValueAnnotatedTypeFactory.this.createArrayLenRangeAnnotation(this.widenedRange(newRange, oldRange, lubRange));
            }
            return lub;
        }

        private Range widenedRange(Range newRange, Range oldRange, Range lubRange) {
            if (newRange == null || oldRange == null || lubRange.equals(oldRange)) {
                return lubRange;
            }
            if (newRange.from >= oldRange.from && newRange.to >= oldRange.to) {
                if (lubRange.to < 127L) {
                    return new Range(newRange.from, 127L);
                }
                if (lubRange.to < 32767L) {
                    return new Range(newRange.from, 32767L);
                }
                if (lubRange.to < Integer.MAX_VALUE) {
                    return new Range(newRange.from, Integer.MAX_VALUE);
                }
                return new Range(newRange.from, Long.MAX_VALUE);
            }
            if (newRange.from <= oldRange.from && newRange.to <= oldRange.to) {
                if (lubRange.from > -128L) {
                    return new Range(-128L, newRange.to);
                }
                if (lubRange.from > -32768L) {
                    return new Range(-32768L, newRange.to);
                }
                if (lubRange.from > Integer.MIN_VALUE) {
                    return new Range(Integer.MIN_VALUE, newRange.to);
                }
                return new Range(Long.MIN_VALUE, newRange.to);
            }
            if (lubRange.isWithin(-127L, 127L) || lubRange.isWithin(-128L, 126L)) {
                return Range.BYTE_EVERYTHING;
            }
            if (lubRange.isWithin(-32767L, 32767L) || lubRange.isWithin(-32768L, 32766L)) {
                return Range.SHORT_EVERYTHING;
            }
            if (lubRange.isWithin(-9223372036854775807L, Long.MAX_VALUE) || lubRange.isWithin(Long.MIN_VALUE, 0x7FFFFFFFFFFFFFFEL)) {
                return Range.INT_EVERYTHING;
            }
            return Range.EVERYTHING;
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (!AnnotationUtils.areSameByName(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
                return null;
            }
            if (this.isSubtype(a1 = ValueAnnotatedTypeFactory.this.convertSpecialIntRangeToStandardIntRange(a1), a2 = ValueAnnotatedTypeFactory.this.convertSpecialIntRangeToStandardIntRange(a2))) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            if (AnnotationUtils.areSameByName(a1, a2)) {
                if (AnnotationUtils.areSameByClass(a1, IntRange.class)) {
                    Range range1 = ValueAnnotatedTypeFactory.getRange(a1);
                    Range range2 = ValueAnnotatedTypeFactory.getRange(a2);
                    return ValueAnnotatedTypeFactory.this.createIntRangeAnnotation(range1.union(range2));
                }
                if (AnnotationUtils.areSameByClass(a1, ArrayLenRange.class)) {
                    Range range1 = ValueAnnotatedTypeFactory.getRange(a1);
                    Range range2 = ValueAnnotatedTypeFactory.getRange(a2);
                    return ValueAnnotatedTypeFactory.this.createArrayLenRangeAnnotation(range1.union(range2));
                }
                if (AnnotationUtils.areSameByClass(a1, IntVal.class)) {
                    List<Long> a1Values = ValueAnnotatedTypeFactory.getIntValues(a1);
                    List<Long> a2Values = ValueAnnotatedTypeFactory.getIntValues(a2);
                    ArrayList<Long> newValues = new ArrayList<Long>();
                    newValues.addAll(a1Values);
                    newValues.addAll(a2Values);
                    return ValueAnnotatedTypeFactory.this.createIntValAnnotation(newValues);
                }
                if (AnnotationUtils.areSameByClass(a1, ArrayLen.class)) {
                    List<Integer> a1Values = ValueAnnotatedTypeFactory.getArrayLength(a1);
                    List<Integer> a2Values = ValueAnnotatedTypeFactory.getArrayLength(a2);
                    ArrayList<Integer> newValues = new ArrayList<Integer>();
                    newValues.addAll(a1Values);
                    newValues.addAll(a2Values);
                    return ValueAnnotatedTypeFactory.this.createArrayLenAnnotation(newValues);
                }
                if (AnnotationUtils.areSameByClass(a1, StringVal.class)) {
                    List<String> a1Values = ValueAnnotatedTypeFactory.getStringValues(a1);
                    List<String> a2Values = ValueAnnotatedTypeFactory.getStringValues(a2);
                    ArrayList<String> newValues = new ArrayList<String>();
                    newValues.addAll(a1Values);
                    newValues.addAll(a2Values);
                    return ValueAnnotatedTypeFactory.this.createStringAnnotation(newValues);
                }
                List<Object> a1Values = AnnotationUtils.getElementValueArray(a1, "value", Object.class, true);
                List<Object> a2Values = AnnotationUtils.getElementValueArray(a2, "value", Object.class, true);
                TreeSet<Object> newValues = new TreeSet<Object>();
                newValues.addAll(a1Values);
                newValues.addAll(a2Values);
                if (newValues.isEmpty()) {
                    return ValueAnnotatedTypeFactory.this.BOTTOMVAL;
                }
                if (newValues.size() > 10) {
                    return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
                }
                AnnotationBuilder builder = new AnnotationBuilder(ValueAnnotatedTypeFactory.this.processingEnv, a1.getAnnotationType().toString());
                ArrayList valuesList = new ArrayList(newValues);
                builder.setValue((CharSequence)"value", valuesList);
                return builder.build();
            }
            AnnotationMirror arrayLenAnno = null;
            AnnotationMirror arrayLenRangeAnno = null;
            AnnotationMirror stringValAnno = null;
            if (AnnotationUtils.areSameByClass(a1, ArrayLen.class)) {
                arrayLenAnno = a1;
            } else if (AnnotationUtils.areSameByClass(a2, ArrayLen.class)) {
                arrayLenAnno = a2;
            }
            if (AnnotationUtils.areSameByClass(a1, ArrayLenRange.class)) {
                arrayLenRangeAnno = a1;
            } else if (AnnotationUtils.areSameByClass(a2, ArrayLenRange.class)) {
                arrayLenRangeAnno = a2;
            }
            if (AnnotationUtils.areSameByClass(a1, StringVal.class)) {
                stringValAnno = a1;
            } else if (AnnotationUtils.areSameByClass(a2, StringVal.class)) {
                stringValAnno = a2;
            }
            if (arrayLenAnno != null && arrayLenRangeAnno != null) {
                return this.leastUpperBound(arrayLenRangeAnno, ValueAnnotatedTypeFactory.this.convertArrayLenToArrayLenRange(arrayLenAnno));
            }
            if (stringValAnno != null && arrayLenAnno != null) {
                return this.leastUpperBound(arrayLenAnno, ValueAnnotatedTypeFactory.this.convertStringValToArrayLen(stringValAnno));
            }
            if (stringValAnno != null && arrayLenRangeAnno != null) {
                return this.leastUpperBound(arrayLenRangeAnno, ValueAnnotatedTypeFactory.this.convertStringValToArrayLenRange(stringValAnno));
            }
            AnnotationMirror intValAnno = null;
            AnnotationMirror intRangeAnno = null;
            AnnotationMirror doubleValAnno = null;
            if (AnnotationUtils.areSameByClass(a1, IntVal.class)) {
                intValAnno = a1;
            } else if (AnnotationUtils.areSameByClass(a2, IntVal.class)) {
                intValAnno = a2;
            }
            if (AnnotationUtils.areSameByClass(a1, DoubleVal.class)) {
                doubleValAnno = a1;
            } else if (AnnotationUtils.areSameByClass(a2, DoubleVal.class)) {
                doubleValAnno = a2;
            }
            if (AnnotationUtils.areSameByClass(a1, IntRange.class)) {
                intRangeAnno = a1;
            } else if (AnnotationUtils.areSameByClass(a2, IntRange.class)) {
                intRangeAnno = a2;
            }
            if (doubleValAnno != null) {
                if (intRangeAnno != null) {
                    intValAnno = ValueAnnotatedTypeFactory.this.convertIntRangeToIntVal(intRangeAnno);
                    intRangeAnno = null;
                    if (intValAnno == ValueAnnotatedTypeFactory.this.UNKNOWNVAL) {
                        intValAnno = null;
                    }
                }
                if (intValAnno != null) {
                    AnnotationMirror doubleValAnno2 = ValueAnnotatedTypeFactory.this.convertIntValToDoubleVal(intValAnno);
                    return this.leastUpperBound(doubleValAnno, doubleValAnno2);
                }
                return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
            }
            if (intRangeAnno != null && intValAnno != null) {
                AnnotationMirror intRangeAnno2 = ValueAnnotatedTypeFactory.this.convertIntValToIntRange(intValAnno);
                return this.leastUpperBound(intRangeAnno, intRangeAnno2);
            }
            return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            subAnno = ValueAnnotatedTypeFactory.this.convertSpecialIntRangeToStandardIntRange(subAnno);
            superAnno = ValueAnnotatedTypeFactory.this.convertSpecialIntRangeToStandardIntRange(superAnno);
            if (AnnotationUtils.areSameByClass(subAnno, UnknownVal.class)) {
                superAnno = ValueAnnotatedTypeFactory.this.convertToUnknown(superAnno);
            }
            if (AnnotationUtils.areSameByClass(superAnno, UnknownVal.class) || AnnotationUtils.areSameByClass(subAnno, BottomVal.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(subAnno, UnknownVal.class) || AnnotationUtils.areSameByClass(superAnno, BottomVal.class)) {
                return false;
            }
            if (AnnotationUtils.areSameByClass(subAnno, PolyValue.class)) {
                return AnnotationUtils.areSameByClass(superAnno, PolyValue.class);
            }
            if (AnnotationUtils.areSameByClass(superAnno, PolyValue.class)) {
                return AnnotationUtils.areSameByClass(subAnno, PolyValue.class);
            }
            if (AnnotationUtils.areSameByName(superAnno, subAnno)) {
                if (AnnotationUtils.areSameByClass(subAnno, IntRange.class) || AnnotationUtils.areSameByClass(subAnno, ArrayLenRange.class)) {
                    Range superRange = ValueAnnotatedTypeFactory.getRange(superAnno);
                    Range subRange = ValueAnnotatedTypeFactory.getRange(subAnno);
                    return superRange.contains(subRange);
                }
                List<Object> superValues = AnnotationUtils.getElementValueArray(superAnno, "value", Object.class, true);
                List<Object> subValues = AnnotationUtils.getElementValueArray(subAnno, "value", Object.class, true);
                return superValues.containsAll(subValues);
            }
            if (AnnotationUtils.areSameByClass(superAnno, DoubleVal.class) && AnnotationUtils.areSameByClass(subAnno, IntVal.class)) {
                List subValues = ValueAnnotatedTypeFactory.this.convertLongListToDoubleList(ValueAnnotatedTypeFactory.getIntValues(subAnno));
                List<Double> superValues = ValueAnnotatedTypeFactory.getDoubleValues(superAnno);
                return superValues.containsAll(subValues);
            }
            if (AnnotationUtils.areSameByClass(superAnno, IntRange.class) && AnnotationUtils.areSameByClass(subAnno, IntVal.class) || AnnotationUtils.areSameByClass(superAnno, ArrayLenRange.class) && AnnotationUtils.areSameByClass(subAnno, ArrayLen.class)) {
                List subValues = ValueAnnotatedTypeFactory.this.getArrayLenOrIntValue(subAnno);
                Range superRange = ValueAnnotatedTypeFactory.getRange(superAnno);
                long subMinVal = (Long)Collections.min(subValues);
                long subMaxVal = (Long)Collections.max(subValues);
                return subMinVal >= superRange.from && subMaxVal <= superRange.to;
            }
            if (AnnotationUtils.areSameByClass(superAnno, DoubleVal.class) && AnnotationUtils.areSameByClass(subAnno, IntRange.class)) {
                Range subRange = ValueAnnotatedTypeFactory.getRange(subAnno);
                if (subRange.isWiderThan(10L)) {
                    return false;
                }
                List<Double> superValues = ValueAnnotatedTypeFactory.getDoubleValues(superAnno);
                List<Double> subValues = ValueCheckerUtils.getValuesFromRange(subRange, Double.class);
                return superValues.containsAll(subValues);
            }
            if (AnnotationUtils.areSameByClass(superAnno, IntVal.class) && AnnotationUtils.areSameByClass(subAnno, IntRange.class) || AnnotationUtils.areSameByClass(superAnno, ArrayLen.class) && AnnotationUtils.areSameByClass(subAnno, ArrayLenRange.class)) {
                Range subRange = ValueAnnotatedTypeFactory.getRange(subAnno);
                if (subRange.isWiderThan(10L)) {
                    return false;
                }
                List superValues = ValueAnnotatedTypeFactory.this.getArrayLenOrIntValue(superAnno);
                List<Long> subValues = ValueCheckerUtils.getValuesFromRange(subRange, Long.class);
                return superValues.containsAll(subValues);
            }
            if (AnnotationUtils.areSameByClass(superAnno, StringVal.class) && (AnnotationUtils.areSameByClass(subAnno, ArrayLen.class) || AnnotationUtils.areSameByClass(subAnno, ArrayLenRange.class))) {
                List<String> superValues = ValueAnnotatedTypeFactory.getStringValues(superAnno);
                return superValues.contains("") && ValueAnnotatedTypeFactory.this.getMaxLenValue(subAnno) == 0;
            }
            if (AnnotationUtils.areSameByClass(superAnno, ArrayLen.class) && AnnotationUtils.areSameByClass(subAnno, StringVal.class)) {
                List<String> subValues = ValueAnnotatedTypeFactory.getStringValues(subAnno);
                List<Integer> superValues = ValueAnnotatedTypeFactory.getArrayLength(superAnno);
                for (String value : subValues) {
                    if (superValues.contains(value.length())) continue;
                    return false;
                }
                return true;
            }
            if (AnnotationUtils.areSameByClass(superAnno, ArrayLenRange.class) && AnnotationUtils.areSameByClass(subAnno, StringVal.class)) {
                List<String> subValues = ValueAnnotatedTypeFactory.getStringValues(subAnno);
                Range superRange = ValueAnnotatedTypeFactory.getRange(superAnno);
                for (String value : subValues) {
                    if (superRange.contains(value.length())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    protected class ValueTypeAnnotator
    extends TypeAnnotator {
        protected ValueTypeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type, Void aVoid) {
            this.replaceWithNewAnnoInSpecialCases(type);
            return (Void)super.scan(type, aVoid);
        }

        private void replaceWithNewAnnoInSpecialCases(AnnotatedTypeMirror atm) {
            AnnotationMirror anno = atm.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            if (anno == null || anno.getElementValues().isEmpty()) {
                return;
            }
            if (AnnotationUtils.areSameByClass(anno, IntVal.class)) {
                List<Long> values = ValueAnnotatedTypeFactory.getIntValues(anno);
                if (values.size() > 10) {
                    long annoMinVal = Collections.min(values);
                    long annoMaxVal = Collections.max(values);
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.createIntRangeAnnotation(new Range(annoMinVal, annoMaxVal)));
                }
            } else if (AnnotationUtils.areSameByClass(anno, ArrayLen.class)) {
                List<Integer> values = ValueAnnotatedTypeFactory.getArrayLength(anno);
                if (values.isEmpty()) {
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.BOTTOMVAL);
                } else if (Collections.min(values) < 0) {
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.BOTTOMVAL);
                } else if (values.size() > 10) {
                    long annoMinVal = Collections.min(values).intValue();
                    long annoMaxVal = Collections.max(values).intValue();
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.createArrayLenRangeAnnotation(new Range(annoMinVal, annoMaxVal)));
                }
            } else if (AnnotationUtils.areSameByClass(anno, IntRange.class)) {
                long to;
                long from = ValueAnnotatedTypeFactory.this.getFromValueFromIntRange(atm);
                if (from > (to = ValueAnnotatedTypeFactory.this.getToValueFromIntRange(atm))) {
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.BOTTOMVAL);
                } else {
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.createIntRangeAnnotation(from, to));
                }
            } else if (AnnotationUtils.areSameByClass(anno, ArrayLenRange.class)) {
                int to;
                int from = AnnotationUtils.getElementValue(anno, "from", Integer.class, true);
                if (from > (to = AnnotationUtils.getElementValue(anno, "to", Integer.class, true).intValue())) {
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.BOTTOMVAL);
                } else if (from < 0) {
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.createArrayLenRangeAnnotation(0, to));
                }
            } else if (AnnotationUtils.areSameByClass(anno, StringVal.class)) {
                List<String> values = ValueAnnotatedTypeFactory.getStringValues(anno);
                if (values.size() > 10) {
                    List<Integer> lengths = ValueCheckerUtils.getLengthsForStringValues(values);
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.createArrayLenAnnotation(lengths));
                }
            } else {
                List<Object> values = AnnotationUtils.getElementValueArray(anno, "value", Object.class, false);
                if (values.size() > 10) {
                    atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
                }
            }
        }
    }
}

