/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value.util;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.javacutil.TypesUtils;

public class NumberUtils {
    public static List<? extends Number> castNumbers(TypeMirror type, List<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        TypeKind typeKind = NumberUtils.unBoxPrimitive(type);
        switch (typeKind) {
            case BYTE: {
                ArrayList<Byte> bytes = new ArrayList<Byte>();
                for (Number number : numbers) {
                    bytes.add(number.byteValue());
                }
                return bytes;
            }
            case CHAR: {
                ArrayList<Integer> chars = new ArrayList<Integer>();
                for (Number number : numbers) {
                    chars.add(number.intValue());
                }
                return chars;
            }
            case DOUBLE: {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (Number number : numbers) {
                    arrayList.add(number.doubleValue());
                }
                return arrayList;
            }
            case FLOAT: {
                ArrayList<Float> arrayList = new ArrayList<Float>();
                for (Number number : numbers) {
                    arrayList.add(Float.valueOf(number.floatValue()));
                }
                return arrayList;
            }
            case INT: {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (Number number : numbers) {
                    arrayList.add(number.intValue());
                }
                return arrayList;
            }
            case LONG: {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (Number number : numbers) {
                    arrayList.add(number.longValue());
                }
                return arrayList;
            }
            case SHORT: {
                ArrayList<Short> arrayList = new ArrayList<Short>();
                for (Number number : numbers) {
                    arrayList.add(number.shortValue());
                }
                return arrayList;
            }
        }
        throw new UnsupportedOperationException(typeKind.toString());
    }

    public static Range castRange(TypeMirror type, Range range) {
        TypeKind typeKind = NumberUtils.unBoxPrimitive(type);
        switch (typeKind) {
            case BYTE: {
                return range.byteRange();
            }
            case CHAR: {
                return range.charRange();
            }
            case SHORT: {
                return range.shortRange();
            }
            case INT: {
                return range.intRange();
            }
            case DOUBLE: 
            case FLOAT: 
            case LONG: {
                return range;
            }
        }
        throw new UnsupportedOperationException(typeKind.toString());
    }

    private static TypeKind unBoxPrimitive(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            String stringType;
            switch (stringType = TypesUtils.getQualifiedName((DeclaredType)type).toString()) {
                case "java.lang.Byte": {
                    return TypeKind.BYTE;
                }
                case "java.lang.Boolean": {
                    return TypeKind.BOOLEAN;
                }
                case "java.lang.Character": {
                    return TypeKind.CHAR;
                }
                case "java.lang.Double": {
                    return TypeKind.DOUBLE;
                }
                case "java.lang.Float": {
                    return TypeKind.FLOAT;
                }
                case "java.lang.Integer": {
                    return TypeKind.INT;
                }
                case "java.lang.Long": {
                    return TypeKind.LONG;
                }
                case "java.lang.Short": {
                    return TypeKind.SHORT;
                }
            }
        }
        return type.getKind();
    }
}

