/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.BugInCF;

public class DefaultInferredTypesApplier {
    private final boolean omitSubtypingCheck;
    private final QualifierHierarchy hierarchy;
    private final AnnotatedTypeFactory factory;

    public DefaultInferredTypesApplier(QualifierHierarchy hierarchy, AnnotatedTypeFactory factory) {
        this(false, hierarchy, factory);
    }

    public DefaultInferredTypesApplier(boolean omitSubtypingCheck, QualifierHierarchy hierarchy, AnnotatedTypeFactory factory) {
        this.omitSubtypingCheck = omitSubtypingCheck;
        this.hierarchy = hierarchy;
        this.factory = factory;
    }

    public void applyInferredType(AnnotatedTypeMirror type, Set<AnnotationMirror> inferredSet, TypeMirror inferredTypeMirror) {
        if (inferredSet == null) {
            return;
        }
        if (inferredTypeMirror.getKind() == TypeKind.WILDCARD) {
            while (inferredTypeMirror.getKind() == TypeKind.WILDCARD && ((WildcardType)inferredTypeMirror).getExtendsBound() != null) {
                inferredTypeMirror = ((WildcardType)inferredTypeMirror).getExtendsBound();
            }
        }
        for (AnnotationMirror annotationMirror : this.hierarchy.getTopAnnotations()) {
            AnnotationMirror inferred = this.hierarchy.findAnnotationInHierarchy(inferredSet, annotationMirror);
            this.apply(type, inferred, inferredTypeMirror, annotationMirror);
        }
    }

    private void apply(AnnotatedTypeMirror type, AnnotationMirror inferred, TypeMirror inferredTypeMirror, AnnotationMirror top) {
        AnnotationMirror primary = type.getAnnotationInHierarchy(top);
        if (inferred == null) {
            if (primary != null) {
                if (type.getKind() == TypeKind.TYPEVAR) {
                    this.removePrimaryAnnotationTypeVar((AnnotatedTypeMirror.AnnotatedTypeVariable)type, inferredTypeMirror, top, primary);
                } else {
                    this.removePrimaryTypeVarApplyUpperBound(type, inferredTypeMirror, top, primary);
                }
            }
        } else {
            if (primary == null) {
                Set<AnnotationMirror> lowerbounds = AnnotatedTypes.findEffectiveLowerBoundAnnotations(this.hierarchy, type);
                primary = this.hierarchy.findAnnotationInHierarchy(lowerbounds, top);
            }
            if (this.omitSubtypingCheck || this.hierarchy.isSubtype(inferred, primary)) {
                type.replaceAnnotation(inferred);
                if (type.getKind() == TypeKind.INTERSECTION) {
                    for (AnnotatedTypeMirror annotatedTypeMirror : ((AnnotatedTypeMirror.AnnotatedIntersectionType)type).directSuperTypes()) {
                        annotatedTypeMirror.replaceAnnotation(inferred);
                    }
                }
            }
        }
    }

    private void removePrimaryTypeVarApplyUpperBound(AnnotatedTypeMirror type, TypeMirror inferredTypeMirror, AnnotationMirror top, AnnotationMirror notInferred) {
        if (inferredTypeMirror.getKind() != TypeKind.TYPEVAR) {
            throw new BugInCF("Inferred value should not be missing annotations: " + inferredTypeMirror);
        }
        TypeVariable typeVar = (TypeVariable)inferredTypeMirror;
        AnnotatedTypeMirror.AnnotatedTypeVariable typeVariableDecl = (AnnotatedTypeMirror.AnnotatedTypeVariable)this.factory.getAnnotatedType(typeVar.asElement());
        AnnotationMirror upperBound = typeVariableDecl.getEffectiveAnnotationInHierarchy(top);
        if (this.omitSubtypingCheck || this.hierarchy.isSubtype(upperBound, notInferred)) {
            type.replaceAnnotation(upperBound);
        }
    }

    private void removePrimaryAnnotationTypeVar(AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVariable, TypeMirror inferredTypeMirror, AnnotationMirror top, AnnotationMirror previousAnnotation) {
        if (inferredTypeMirror.getKind() != TypeKind.TYPEVAR) {
            throw new BugInCF("Missing annos");
        }
        TypeVariable typeVar = (TypeVariable)inferredTypeMirror;
        AnnotatedTypeMirror.AnnotatedTypeVariable typeVariableDecl = (AnnotatedTypeMirror.AnnotatedTypeVariable)this.factory.getAnnotatedType(typeVar.asElement());
        AnnotationMirror upperBound = typeVariableDecl.getEffectiveAnnotationInHierarchy(top);
        if (this.omitSubtypingCheck || this.hierarchy.isSubtype(upperBound, previousAnnotation)) {
            annotatedTypeVariable.removeAnnotationInHierarchy(top);
            AnnotationMirror ub = typeVariableDecl.getUpperBound().getAnnotationInHierarchy(top);
            this.apply(annotatedTypeVariable.getUpperBound(), ub, typeVar.getUpperBound(), top);
            AnnotationMirror lb = typeVariableDecl.getLowerBound().getAnnotationInHierarchy(top);
            this.apply(annotatedTypeVariable.getLowerBound(), lb, typeVar.getLowerBound(), top);
        }
    }
}

