/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.ElementAnnotationApplier;
import org.checkerframework.framework.type.TypeFromTree;
import org.checkerframework.framework.type.TypeFromTreeVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

class TypeFromMemberVisitor
extends TypeFromTreeVisitor {
    TypeFromMemberVisitor() {
    }

    @Override
    public AnnotatedTypeMirror visitVariable(VariableTree node, AnnotatedTypeFactory f) {
        VariableElement elt;
        AnnotatedTypeMirror lambdaParamType;
        AnnotatedTypeMirror result = TypeFromTree.fromTypeTree(f, node.getType());
        List<? extends AnnotationTree> annos = node.getModifiers().getAnnotations();
        if (annos != null && !annos.isEmpty()) {
            List<AnnotationMirror> ams = TreeUtils.annotationsFromTypeAnnotationTrees(annos);
            AnnotatedTypeMirror innerType = AnnotatedTypes.innerMostType(result);
            innerType.addAnnotations(ams);
        }
        if ((lambdaParamType = TypeFromMemberVisitor.inferLambdaParamAnnotations(f, result, elt = TreeUtils.elementFromDeclaration(node))) != null) {
            return lambdaParamType;
        }
        return result;
    }

    @Override
    public AnnotatedTypeMirror visitMethod(MethodTree node, AnnotatedTypeFactory f) {
        ExecutableElement elt = TreeUtils.elementFromDeclaration(node);
        AnnotatedTypeMirror.AnnotatedExecutableType result = (AnnotatedTypeMirror.AnnotatedExecutableType)f.toAnnotatedType(elt.asType(), false);
        result.setElement(elt);
        result.getReturnType();
        ElementAnnotationApplier.apply(result, elt, f);
        return result;
    }

    private static AnnotatedTypeMirror inferLambdaParamAnnotations(AnnotatedTypeFactory f, AnnotatedTypeMirror lambdaParam, Element paramElement) {
        if (paramElement.getKind() != ElementKind.PARAMETER || f.declarationFromElement(paramElement) == null || f.getPath(f.declarationFromElement(paramElement)) == null || f.getPath(f.declarationFromElement(paramElement)).getParentPath() == null) {
            return null;
        }
        Tree declaredInTree = f.getPath(f.declarationFromElement(paramElement)).getParentPath().getLeaf();
        if (declaredInTree.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            LambdaExpressionTree lambdaDecl = (LambdaExpressionTree)declaredInTree;
            int index = lambdaDecl.getParameters().indexOf(f.declarationFromElement(paramElement));
            Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> res = f.getFnInterfaceFromTree(lambdaDecl);
            AnnotatedTypeMirror.AnnotatedExecutableType functionType = (AnnotatedTypeMirror.AnnotatedExecutableType)res.second;
            AnnotatedTypeMirror funcTypeParam = functionType.getParameterTypes().get(index);
            if (TreeUtils.isImplicitlyTypedLambda(declaredInTree)) {
                if (f.types.isSubtype(funcTypeParam.actualType, lambdaParam.actualType)) {
                    return AnnotatedTypes.asSuper(f, funcTypeParam, lambdaParam);
                }
                lambdaParam.addMissingAnnotations(funcTypeParam.getAnnotations());
                return lambdaParam;
            }
            lambdaParam.addMissingAnnotations(funcTypeParam.getAnnotations());
            return lambdaParam;
        }
        return null;
    }
}

