/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.WildcardTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.TypeFromTreeVisitor;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

class TypeFromTypeTreeVisitor
extends TypeFromTreeVisitor {
    private final Map<Tree, AnnotatedTypeMirror> visitedBounds = new HashMap<Tree, AnnotatedTypeMirror>();

    TypeFromTypeTreeVisitor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AnnotatedTypeMirror visitAnnotatedType(AnnotatedTypeTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror type = (AnnotatedTypeMirror)this.visit(node.getUnderlyingType(), f);
        if (type == null) {
            type = f.toAnnotatedType(f.types.getNoType(TypeKind.NONE), false);
        }
        assert (AnnotatedTypeFactory.validAnnotatedType(type));
        List<? extends AnnotationMirror> annos = TreeUtils.annotationsFromTree(node);
        if (type.getKind() == TypeKind.WILDCARD) {
            Type.WildcardType wildcardAttachedToNode = (Type.WildcardType)TreeUtils.typeOf(node);
            Type.WildcardType underlyingWildcard = (Type.WildcardType)type.getUnderlyingType();
            underlyingWildcard.withTypeVar(wildcardAttachedToNode.bound);
            AnnotatedTypeMirror.AnnotatedWildcardType wctype = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
            ExpressionTree underlyingTree = node.getUnderlyingType();
            if (underlyingTree.getKind() == Tree.Kind.UNBOUNDED_WILDCARD) {
                wctype.getExtendsBound().addAnnotations(annos);
                wctype.getSuperBound().addAnnotations(annos);
                return type;
            } else if (underlyingTree.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
                wctype.getSuperBound().addAnnotations(annos);
                return type;
            } else {
                if (underlyingTree.getKind() != Tree.Kind.SUPER_WILDCARD) throw new BugInCF("Unexpected kind for type.  node=" + node + " type=" + type + " kind=" + (Object)((Object)underlyingTree.getKind()));
                wctype.getExtendsBound().addAnnotations(annos);
            }
            return type;
        } else {
            type.addAnnotations(annos);
        }
        return type;
    }

    @Override
    public AnnotatedTypeMirror visitArrayType(ArrayTypeTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror component = (AnnotatedTypeMirror)this.visit(node.getType(), f);
        AnnotatedTypeMirror result = f.type(node);
        assert (result instanceof AnnotatedTypeMirror.AnnotatedArrayType);
        ((AnnotatedTypeMirror.AnnotatedArrayType)result).setComponentType(component);
        return result;
    }

    @Override
    public AnnotatedTypeMirror visitParameterizedType(ParameterizedTypeTree node, AnnotatedTypeFactory f) {
        Symbol.ClassSymbol baseType = (Symbol.ClassSymbol)TreeUtils.elementFromTree(node.getType());
        this.updateWildcardBounds(node.getTypeArguments(), baseType.getTypeParameters());
        ArrayList<AnnotatedTypeMirror> args = new ArrayList<AnnotatedTypeMirror>(node.getTypeArguments().size());
        for (Tree tree : node.getTypeArguments()) {
            args.add((AnnotatedTypeMirror)this.visit(tree, f));
        }
        AnnotatedTypeMirror result = f.type(node);
        AnnotatedTypeMirror annotatedTypeMirror = (AnnotatedTypeMirror)this.visit(node.getType(), f);
        result.addAnnotations(annotatedTypeMirror.getAnnotations());
        if (result instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
            assert (result instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) : node + " --> " + result;
            ((AnnotatedTypeMirror.AnnotatedDeclaredType)result).setTypeArguments(args);
        }
        return result;
    }

    private void updateWildcardBounds(List<? extends Tree> typeArgs, List<Symbol.TypeVariableSymbol> typeParams) {
        if (typeArgs.size() == 0) {
            return;
        }
        assert (typeArgs.size() == typeParams.size());
        Iterator<? extends Tree> typeArgsItr = typeArgs.iterator();
        Iterator<Symbol.TypeVariableSymbol> typeParamsItr = typeParams.iterator();
        while (typeArgsItr.hasNext()) {
            Tree typeArg = typeArgsItr.next();
            Symbol.TypeVariableSymbol typeParam = typeParamsItr.next();
            if (!(typeArg instanceof WildcardTree)) continue;
            Type.TypeVar typeVar = (Type.TypeVar)typeParam.asType();
            Type.WildcardType wcType = (Type.WildcardType)((JCTree.JCWildcard)typeArg).type;
            if (wcType.bound == null || wcType.bound.tsym == null || typeVar.tsym == null || wcType.bound.tsym.owner == typeVar.tsym.owner) continue;
            wcType.withTypeVar(typeVar);
        }
    }

    @Override
    public AnnotatedTypeMirror visitPrimitiveType(PrimitiveTypeTree node, AnnotatedTypeFactory f) {
        return f.type(node);
    }

    @Override
    public AnnotatedTypeMirror visitTypeParameter(TypeParameterTree node, AnnotatedTypeFactory f) {
        ArrayList<AnnotatedTypeMirror> bounds = new ArrayList<AnnotatedTypeMirror>(node.getBounds().size());
        for (Tree tree : node.getBounds()) {
            AnnotatedTypeMirror bound;
            if (this.visitedBounds.containsKey(tree) && f == this.visitedBounds.get((Object)tree).atypeFactory) {
                bound = this.visitedBounds.get(tree);
            } else {
                this.visitedBounds.put(tree, f.type(tree));
                bound = (AnnotatedTypeMirror)this.visit(tree, f);
                this.visitedBounds.remove(tree);
            }
            bounds.add(bound);
        }
        AnnotatedTypeMirror.AnnotatedTypeVariable result = (AnnotatedTypeMirror.AnnotatedTypeVariable)f.type(node);
        List<? extends AnnotationMirror> list = TreeUtils.annotationsFromTree(node);
        result.getLowerBound().addAnnotations(list);
        switch (bounds.size()) {
            case 0: {
                break;
            }
            case 1: {
                result.setUpperBound((AnnotatedTypeMirror)bounds.get(0));
                break;
            }
            default: {
                AnnotatedTypeMirror.AnnotatedIntersectionType upperBound = (AnnotatedTypeMirror.AnnotatedIntersectionType)result.getUpperBound();
                ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> superBounds = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>(bounds.size());
                for (AnnotatedTypeMirror b : bounds) {
                    superBounds.add((AnnotatedTypeMirror.AnnotatedDeclaredType)b);
                }
                upperBound.setDirectSuperTypes(superBounds);
            }
        }
        return result;
    }

    @Override
    public AnnotatedTypeMirror visitWildcard(WildcardTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror bound = (AnnotatedTypeMirror)this.visit(node.getBound(), f);
        AnnotatedTypeMirror result = f.type(node);
        assert (result instanceof AnnotatedTypeMirror.AnnotatedWildcardType);
        if (node.getKind() == Tree.Kind.SUPER_WILDCARD) {
            ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setSuperBound(bound);
        } else if (node.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
            ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setExtendsBound(bound);
        }
        return result;
    }

    private AnnotatedTypeMirror forTypeVariable(AnnotatedTypeMirror type, AnnotatedTypeFactory f) {
        if (type.getKind() != TypeKind.TYPEVAR) {
            throw new BugInCF("TypeFromTree.forTypeVariable: should only be called on type variables");
        }
        TypeVariable typeVar = (TypeVariable)type.getUnderlyingType();
        TypeParameterElement tpe = (TypeParameterElement)typeVar.asElement();
        Element elt = tpe.getGenericElement();
        if (elt instanceof TypeElement) {
            TypeElement typeElt = (TypeElement)elt;
            int idx = typeElt.getTypeParameters().indexOf(tpe);
            ClassTree cls = (ClassTree)f.declarationFromElement(typeElt);
            if (cls != null) {
                AnnotatedTypeMirror result = ((AnnotatedTypeMirror)this.visit(cls.getTypeParameters().get(idx), f)).shallowCopy();
                ((AnnotatedTypeMirror.AnnotatedTypeVariable)result).setDeclaration(false);
                return result;
            }
            return type;
        }
        if (elt instanceof ExecutableElement) {
            ExecutableElement exElt = (ExecutableElement)elt;
            int idx = exElt.getTypeParameters().indexOf(tpe);
            MethodTree meth = (MethodTree)f.declarationFromElement(exElt);
            if (meth != null) {
                AnnotatedTypeMirror result = ((AnnotatedTypeMirror)this.visit(meth.getTypeParameters().get(idx), f)).shallowCopy();
                ((AnnotatedTypeMirror.AnnotatedTypeVariable)result).setDeclaration(false);
                return result;
            }
            return type;
        }
        if (TypesUtils.isCaptured(typeVar)) {
            return type;
        }
        throw new BugInCF("TypeFromTree.forTypeVariable: not a supported element: " + elt);
    }

    @Override
    public AnnotatedTypeMirror visitIdentifier(IdentifierTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror type = f.type(node);
        if (type.getKind() == TypeKind.TYPEVAR) {
            return this.forTypeVariable(type, f).asUse();
        }
        return type;
    }

    @Override
    public AnnotatedTypeMirror visitMemberSelect(MemberSelectTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror type = f.type(node);
        if (type.getKind() == TypeKind.TYPEVAR) {
            return this.forTypeVariable(type, f).asUse();
        }
        return type;
    }

    @Override
    public AnnotatedTypeMirror visitUnionType(UnionTypeTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror type = f.type(node);
        if (type.getKind() == TypeKind.TYPEVAR) {
            return this.forTypeVariable(type, f).asUse();
        }
        return type;
    }

    @Override
    public AnnotatedTypeMirror visitIntersectionType(IntersectionTypeTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror type = f.type(node);
        if (type.getKind() == TypeKind.TYPEVAR) {
            return this.forTypeVariable(type, f).asUse();
        }
        return type;
    }
}

