/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.treeannotator;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.qual.LiteralKind;
import org.checkerframework.framework.qual.QualifierForLiterals;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.BugInCF;

public class LiteralTreeAnnotator
extends TreeAnnotator {
    private final Map<Tree.Kind, Set<AnnotationMirror>> treeKinds = new EnumMap<Tree.Kind, Set<AnnotationMirror>>(Tree.Kind.class);
    private final Map<Class<?>, Set<AnnotationMirror>> treeClasses = new HashMap();
    private final Map<Pattern, Set<AnnotationMirror>> stringPatterns = new IdentityHashMap<Pattern, Set<AnnotationMirror>>();
    protected final QualifierHierarchy qualHierarchy;
    private static final Map<LiteralKind, Tree.Kind> literalKindToTreeKind = new EnumMap<LiteralKind, Tree.Kind>(LiteralKind.class);

    public LiteralTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
        super(atypeFactory);
        this.qualHierarchy = atypeFactory.getQualifierHierarchy();
        Set<Class<? extends Annotation>> quals = atypeFactory.getSupportedTypeQualifiers();
        for (Class<? extends Annotation> qual : quals) {
            QualifierForLiterals forLiterals = qual.getAnnotation(QualifierForLiterals.class);
            if (forLiterals == null) continue;
            AnnotationMirror theQual = AnnotationBuilder.fromClass(atypeFactory.getElementUtils(), qual);
            for (LiteralKind literalKind : forLiterals.value()) {
                this.addLiteralKind(literalKind, theQual);
            }
            for (String string : forLiterals.stringPatterns()) {
                this.addStringPattern(string, theQual);
            }
            if (forLiterals.value().length != 0 || forLiterals.stringPatterns().length != 0) continue;
            this.addLiteralKind(LiteralKind.ALL, theQual);
        }
    }

    public LiteralTreeAnnotator addStandardLiteralQualifiers() {
        if (!this.treeKinds.containsKey((Object)Tree.Kind.NULL_LITERAL)) {
            for (AnnotationMirror annotationMirror : this.qualHierarchy.getBottomAnnotations()) {
                this.addLiteralKind(LiteralKind.NULL, annotationMirror);
            }
            return this;
        }
        Set<? extends AnnotationMirror> tops = this.qualHierarchy.getTopAnnotations();
        Set<AnnotationMirror> set = this.treeKinds.get((Object)Tree.Kind.NULL_LITERAL);
        if (tops.size() == set.size()) {
            return this;
        }
        for (AnnotationMirror annotationMirror : tops) {
            if (this.qualHierarchy.findAnnotationInHierarchy(set, annotationMirror) != null) continue;
            set.add(this.qualHierarchy.getBottomAnnotation(annotationMirror));
        }
        return this;
    }

    public void addLiteralKind(LiteralKind literalKind, AnnotationMirror theQual) {
        if (literalKind == LiteralKind.ALL) {
            for (LiteralKind iterLiteralKind : LiteralKind.allLiteralKinds()) {
                this.addLiteralKind(iterLiteralKind, theQual);
            }
        } else if (literalKind == LiteralKind.PRIMITIVE) {
            for (LiteralKind iterLiteralKind : LiteralKind.primitiveLiteralKinds()) {
                this.addLiteralKind(iterLiteralKind, theQual);
            }
        } else {
            Tree.Kind treeKind = literalKindToTreeKind.get((Object)literalKind);
            if (treeKind != null) {
                this.addTreeKind(treeKind, theQual);
            } else {
                throw new BugInCF("LiteralKind " + (Object)((Object)literalKind) + " is not mapped to a Tree.Kind.");
            }
        }
    }

    private void addTreeKind(Tree.Kind treeKind, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.treeKinds, treeKind, theQual);
        if (!res) {
            throw new BugInCF("LiteralTreeAnnotator: invalid update of treeKinds " + this.treeKinds + " at " + (Object)((Object)treeKind) + " with " + theQual);
        }
    }

    public void addStringPattern(String pattern, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.stringPatterns, Pattern.compile(pattern), theQual);
        if (!res) {
            throw new BugInCF("LiteralTreeAnnotator: invalid update of stringPatterns " + this.stringPatterns + " at " + pattern + " with " + theQual);
        }
    }

    @Override
    public Void defaultAction(Tree tree, AnnotatedTypeMirror type) {
        if (tree == null || type == null) {
            return null;
        }
        if (this.treeKinds.containsKey((Object)tree.getKind())) {
            Set<AnnotationMirror> fnd = this.treeKinds.get((Object)tree.getKind());
            type.addMissingAnnotations(fnd);
        } else if (!this.treeClasses.isEmpty()) {
            Class<?> t = tree.getClass();
            if (this.treeClasses.containsKey(t)) {
                Set<AnnotationMirror> fnd = this.treeClasses.get(t);
                type.addMissingAnnotations(fnd);
            }
            for (Class<?> c : t.getInterfaces()) {
                if (!this.treeClasses.containsKey(c)) continue;
                Set<AnnotationMirror> fnd = this.treeClasses.get(c);
                type.addMissingAnnotations(fnd);
                this.treeClasses.put(t, this.treeClasses.get(c));
            }
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
        if (!this.stringPatterns.isEmpty() && tree.getKind() == Tree.Kind.STRING_LITERAL) {
            ArrayList<Set> matches = new ArrayList<Set>();
            ArrayList<Set> nonMatches = new ArrayList<Set>();
            String string = (String)tree.getValue();
            for (Pattern pattern : this.stringPatterns.keySet()) {
                Set sam = this.stringPatterns.get(pattern);
                if (pattern.matcher(string).matches()) {
                    matches.add(sam);
                    continue;
                }
                nonMatches.add(sam);
            }
            if (!matches.isEmpty()) {
                Set<? extends AnnotationMirror> res = (Set<? extends AnnotationMirror>)matches.get(0);
                for (Set sam : matches) {
                    res = this.qualHierarchy.greatestLowerBounds((Collection<? extends AnnotationMirror>)res, sam);
                }
                for (Set sam : nonMatches) {
                    if (!this.qualHierarchy.isSubtype(res, sam)) continue;
                    throw new BugInCF(String.join((CharSequence)System.lineSeparator(), "Bug in @QualifierForLiterals(stringpatterns=...) in type hierarchy definition:", " inferred type for \"" + string + "\" is " + res, " which is a subtype of " + sam, " but its pattern does not match the string.", "  matches = " + matches, "  nonMatches = " + nonMatches));
                }
                type.addAnnotations((Iterable<? extends AnnotationMirror>)res);
            }
        }
        return (Void)super.visitLiteral(tree, type);
    }

    static {
        literalKindToTreeKind.put(LiteralKind.BOOLEAN, Tree.Kind.BOOLEAN_LITERAL);
        literalKindToTreeKind.put(LiteralKind.CHAR, Tree.Kind.CHAR_LITERAL);
        literalKindToTreeKind.put(LiteralKind.DOUBLE, Tree.Kind.DOUBLE_LITERAL);
        literalKindToTreeKind.put(LiteralKind.FLOAT, Tree.Kind.FLOAT_LITERAL);
        literalKindToTreeKind.put(LiteralKind.INT, Tree.Kind.INT_LITERAL);
        literalKindToTreeKind.put(LiteralKind.LONG, Tree.Kind.LONG_LITERAL);
        literalKindToTreeKind.put(LiteralKind.NULL, Tree.Kind.NULL_LITERAL);
        literalKindToTreeKind.put(LiteralKind.STRING, Tree.Kind.STRING_LITERAL);
    }
}

