/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.typeannotator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import org.checkerframework.framework.qual.DefaultQualifierForUse;
import org.checkerframework.framework.qual.NoDefaultQualifierForUse;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.CollectionUtils;

public class DefaultQualifierForUseTypeAnnotator
extends TypeAnnotator {
    protected Map<Element, Set<AnnotationMirror>> elementToDefaults = CollectionUtils.createLRUCache(100);

    public DefaultQualifierForUseTypeAnnotator(AnnotatedTypeFactory typeFactory) {
        super(typeFactory);
    }

    @Override
    public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void aVoid) {
        Element element = type.getUnderlyingType().asElement();
        Set<AnnotationMirror> annosToApply = this.getDefaultAnnosForUses(element);
        type.addMissingAnnotations(annosToApply);
        return (Void)super.visitDeclared(type, aVoid);
    }

    public void clearCache() {
        this.elementToDefaults.clear();
    }

    protected Set<AnnotationMirror> getDefaultAnnosForUses(Element element) {
        if (this.typeFactory.shouldCache && this.elementToDefaults.containsKey(element)) {
            return this.elementToDefaults.get(element);
        }
        Set<AnnotationMirror> explictAnnos = this.getExplicitAnnos(element);
        Set<AnnotationMirror> defaultAnnos = this.getSupportAnnosFromDefaultQualifierForUses(element);
        Set<AnnotationMirror> noDefaultAnnos = this.getHierarchiesNoDefault(element);
        AnnotationMirrorSet annosToApply = new AnnotationMirrorSet();
        for (AnnotationMirror annotationMirror : this.typeFactory.getQualifierHierarchy().getTopAnnotations()) {
            if (AnnotationUtils.containsSame(noDefaultAnnos, annotationMirror)) continue;
            AnnotationMirror defaultAnno = this.typeFactory.getQualifierHierarchy().findAnnotationInHierarchy(defaultAnnos, annotationMirror);
            if (defaultAnno != null) {
                annosToApply.add(defaultAnno);
                continue;
            }
            AnnotationMirror explict = this.typeFactory.getQualifierHierarchy().findAnnotationInHierarchy(explictAnnos, annotationMirror);
            if (explict == null) continue;
            annosToApply.add(explict);
        }
        if (this.typeFactory.shouldCache) {
            this.elementToDefaults.put(element, annosToApply);
        }
        return annosToApply;
    }

    protected Set<AnnotationMirror> getExplicitAnnos(Element element) {
        AnnotatedTypeMirror explicitAnnoOnDecl = this.typeFactory.fromElement(element);
        return explicitAnnoOnDecl.getAnnotations();
    }

    protected Set<AnnotationMirror> getSupportAnnosFromDefaultQualifierForUses(Element element) {
        AnnotationMirror defaultQualifier = this.typeFactory.getDeclAnnotation(element, DefaultQualifierForUse.class);
        if (defaultQualifier == null) {
            return Collections.emptySet();
        }
        return this.supportedAnnosFromAnnotationMirror(defaultQualifier);
    }

    protected Set<AnnotationMirror> getHierarchiesNoDefault(Element element) {
        AnnotationMirror noDefaultQualifier = this.typeFactory.getDeclAnnotation(element, NoDefaultQualifierForUse.class);
        if (noDefaultQualifier == null) {
            return Collections.emptySet();
        }
        return this.supportedAnnosFromAnnotationMirror(noDefaultQualifier);
    }

    protected final AnnotationMirrorSet supportedAnnosFromAnnotationMirror(AnnotationMirror annotationMirror) {
        List<Name> annoClassNames = AnnotationUtils.getElementValueClassNames(annotationMirror, "value", true);
        AnnotationMirrorSet supportAnnos = new AnnotationMirrorSet();
        for (Name annoName : annoClassNames) {
            AnnotationMirror anno = AnnotationBuilder.fromName(this.typeFactory.getElementUtils(), annoName);
            if (!this.typeFactory.isSupportedQualifier(anno)) continue;
            supportAnnos.add(anno);
        }
        return supportAnnos;
    }
}

