/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.framework.qual.ConditionalPostconditionAnnotation;
import org.checkerframework.framework.qual.EnsuresQualifier;
import org.checkerframework.framework.qual.EnsuresQualifierIf;
import org.checkerframework.framework.qual.EnsuresQualifiers;
import org.checkerframework.framework.qual.EnsuresQualifiersIf;
import org.checkerframework.framework.qual.PostconditionAnnotation;
import org.checkerframework.framework.qual.PreconditionAnnotation;
import org.checkerframework.framework.qual.QualifierArgument;
import org.checkerframework.framework.qual.RequiresQualifier;
import org.checkerframework.framework.qual.RequiresQualifiers;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;

public class ContractsUtils {
    protected static ContractsUtils instance;
    protected GenericAnnotatedTypeFactory<?, ?, ?, ?> factory;

    private ContractsUtils(GenericAnnotatedTypeFactory<?, ?, ?, ?> factory) {
        this.factory = factory;
    }

    public static ContractsUtils getInstance(GenericAnnotatedTypeFactory<?, ?, ?, ?> factory) {
        if (instance == null || ContractsUtils.instance.factory != factory) {
            instance = new ContractsUtils(factory);
        }
        return instance;
    }

    public List<Contract> getContracts(ExecutableElement element) {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        contracts.addAll(this.getPreconditions(element));
        contracts.addAll(this.getPostconditions(element));
        contracts.addAll(this.getConditionalPostconditions(element));
        return contracts;
    }

    public Set<Precondition> getPreconditions(Element element) {
        LinkedHashSet<Precondition> result = new LinkedHashSet<Precondition>();
        AnnotationMirror requiresQualifier = this.factory.getDeclAnnotation(element, RequiresQualifier.class);
        result.addAll(this.getPrecondition(requiresQualifier));
        AnnotationMirror requiresQualifiers = this.factory.getDeclAnnotation(element, RequiresQualifiers.class);
        if (requiresQualifiers != null) {
            List<AnnotationMirror> requiresQualifierList = AnnotationUtils.getElementValueArray(requiresQualifiers, "value", AnnotationMirror.class, false);
            for (AnnotationMirror annotationMirror : requiresQualifierList) {
                result.addAll(this.getPrecondition(annotationMirror));
            }
        }
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(element, PreconditionAnnotation.class);
        for (Pair pair : declAnnotations) {
            AnnotationMirror metaAnno = (AnnotationMirror)pair.second;
            AnnotationMirror anno = (AnnotationMirror)pair.first;
            AnnotationMirror precondAnno = this.getAnnotationMirrorOfContractAnnotation(metaAnno, anno);
            if (precondAnno == null) continue;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            for (String expr : expressions) {
                result.add(new Precondition(expr, precondAnno, anno));
            }
        }
        return result;
    }

    private Set<Precondition> getPrecondition(AnnotationMirror requiresQualifier) {
        if (requiresQualifier == null) {
            return Collections.emptySet();
        }
        AnnotationMirror precondAnno = this.getAnnotationMirrorOfContractAnnotation(requiresQualifier);
        if (precondAnno == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Precondition> result = new LinkedHashSet<Precondition>();
        List<String> expressions = AnnotationUtils.getElementValueArray(requiresQualifier, "expression", String.class, false);
        for (String expr : expressions) {
            result.add(new Precondition(expr, precondAnno, requiresQualifier));
        }
        return result;
    }

    public Set<Postcondition> getPostconditions(ExecutableElement methodElement) {
        LinkedHashSet<Postcondition> result = new LinkedHashSet<Postcondition>();
        AnnotationMirror ensuresQualifier = this.factory.getDeclAnnotation(methodElement, EnsuresQualifier.class);
        result.addAll(this.getPostcondition(ensuresQualifier));
        AnnotationMirror ensuresQualifiers = this.factory.getDeclAnnotation(methodElement, EnsuresQualifiers.class);
        if (ensuresQualifiers != null) {
            List<AnnotationMirror> ensuresQualifiersList = AnnotationUtils.getElementValueArray(ensuresQualifiers, "value", AnnotationMirror.class, false);
            for (AnnotationMirror annotationMirror : ensuresQualifiersList) {
                result.addAll(this.getPostcondition(annotationMirror));
            }
        }
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(methodElement, PostconditionAnnotation.class);
        for (Pair pair : declAnnotations) {
            AnnotationMirror metaAnno = (AnnotationMirror)pair.second;
            AnnotationMirror anno = (AnnotationMirror)pair.first;
            AnnotationMirror postcondAnno = this.getAnnotationMirrorOfContractAnnotation(metaAnno, anno);
            if (postcondAnno == null) continue;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            for (String expr : expressions) {
                result.add(new Postcondition(expr, postcondAnno, anno));
            }
        }
        return result;
    }

    private Set<Postcondition> getPostcondition(AnnotationMirror ensuresQualifier) {
        if (ensuresQualifier == null) {
            return Collections.emptySet();
        }
        AnnotationMirror postcondAnno = this.getAnnotationMirrorOfContractAnnotation(ensuresQualifier);
        if (postcondAnno == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Postcondition> result = new LinkedHashSet<Postcondition>();
        List<String> expressions = AnnotationUtils.getElementValueArray(ensuresQualifier, "expression", String.class, false);
        for (String expr : expressions) {
            result.add(new Postcondition(expr, postcondAnno, ensuresQualifier));
        }
        return result;
    }

    public Set<ConditionalPostcondition> getConditionalPostconditions(ExecutableElement methodElement) {
        LinkedHashSet<ConditionalPostcondition> result = new LinkedHashSet<ConditionalPostcondition>();
        AnnotationMirror ensuresQualifierIf = this.factory.getDeclAnnotation(methodElement, EnsuresQualifierIf.class);
        result.addAll(this.getConditionalPostcondition(ensuresQualifierIf));
        AnnotationMirror ensuresQualifiersIf = this.factory.getDeclAnnotation(methodElement, EnsuresQualifiersIf.class);
        if (ensuresQualifiersIf != null) {
            List<AnnotationMirror> annotations = AnnotationUtils.getElementValueArray(ensuresQualifiersIf, "value", AnnotationMirror.class, false);
            for (AnnotationMirror annotationMirror : annotations) {
                result.addAll(this.getConditionalPostcondition(annotationMirror));
            }
        }
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(methodElement, ConditionalPostconditionAnnotation.class);
        for (Pair pair : declAnnotations) {
            AnnotationMirror metaAnno = (AnnotationMirror)pair.second;
            AnnotationMirror anno = (AnnotationMirror)pair.first;
            AnnotationMirror postcondAnno = this.getAnnotationMirrorOfContractAnnotation(metaAnno, anno);
            if (postcondAnno == null) continue;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "expression", String.class, false);
            boolean annoResult = AnnotationUtils.getElementValue(anno, "result", Boolean.class, false);
            for (String expr : expressions) {
                result.add(new ConditionalPostcondition(expr, annoResult, postcondAnno, anno));
            }
        }
        return result;
    }

    private Set<ConditionalPostcondition> getConditionalPostcondition(AnnotationMirror ensuresQualifierIf) {
        if (ensuresQualifierIf == null) {
            return Collections.emptySet();
        }
        AnnotationMirror postcondAnno = this.getAnnotationMirrorOfContractAnnotation(ensuresQualifierIf);
        if (postcondAnno == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ConditionalPostcondition> result = new LinkedHashSet<ConditionalPostcondition>();
        List<String> expressions = AnnotationUtils.getElementValueArray(ensuresQualifierIf, "expression", String.class, false);
        boolean annoResult = AnnotationUtils.getElementValue(ensuresQualifierIf, "result", Boolean.class, false);
        for (String expr : expressions) {
            result.add(new ConditionalPostcondition(expr, annoResult, postcondAnno, ensuresQualifierIf));
        }
        return result;
    }

    private AnnotationMirror getAnnotationMirrorOfQualifier(AnnotationMirror contractAnno, AnnotationMirror argumentAnno, Map<String, String> argumentRenaming) {
        AnnotationMirror anno;
        Name c = AnnotationUtils.getElementValueClassName(contractAnno, "qualifier", false);
        if (argumentAnno == null || argumentRenaming.isEmpty()) {
            anno = AnnotationBuilder.fromName(this.factory.getElementUtils(), c);
        } else {
            AnnotationBuilder builder = new AnnotationBuilder(this.factory.getProcessingEnv(), c);
            builder.copyRenameElementValuesFromAnnotation(argumentAnno, argumentRenaming);
            anno = builder.build();
        }
        if (this.factory.isSupportedQualifier(anno)) {
            return anno;
        }
        AnnotationMirror aliasedAnno = this.factory.canonicalAnnotation(anno);
        if (this.factory.isSupportedQualifier(aliasedAnno)) {
            return aliasedAnno;
        }
        return null;
    }

    private AnnotationMirror getAnnotationMirrorOfContractAnnotation(AnnotationMirror contractAnno) {
        return this.getAnnotationMirrorOfQualifier(contractAnno, null, null);
    }

    private Map<String, String> makeArgumentRenaming(Element contractAnnoElement) {
        HashMap<String, String> argumentRenaming = new HashMap<String, String>();
        for (ExecutableElement meth : ElementFilter.methodsIn(contractAnnoElement.getEnclosedElements())) {
            AnnotationMirror argumentAnnotation = this.factory.getDeclAnnotation(meth, QualifierArgument.class);
            if (argumentAnnotation == null) continue;
            String sourceName = meth.getSimpleName().toString();
            String targetName = AnnotationUtils.getElementValue(argumentAnnotation, "value", String.class, false);
            if (targetName == null || targetName.isEmpty()) {
                targetName = sourceName;
            }
            argumentRenaming.put(sourceName, targetName);
        }
        return argumentRenaming;
    }

    private AnnotationMirror getAnnotationMirrorOfContractAnnotation(AnnotationMirror contractAnno, AnnotationMirror argumentAnno) {
        Map<String, String> argumentRenaming = this.makeArgumentRenaming(argumentAnno.getAnnotationType().asElement());
        return this.getAnnotationMirrorOfQualifier(contractAnno, argumentAnno, argumentRenaming);
    }

    public static class ConditionalPostcondition
    extends Contract {
        public final boolean annoResult;

        public ConditionalPostcondition(String expression, boolean annoResult, AnnotationMirror annotation, AnnotationMirror contractAnnotation) {
            super(expression, annotation, contractAnnotation, Contract.Kind.CONDITIONALPOSTCONDTION);
            this.annoResult = annoResult;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConditionalPostcondition that = (ConditionalPostcondition)o;
            return this.annoResult == that.annoResult;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.annoResult);
        }
    }

    public static class Postcondition
    extends Contract {
        public Postcondition(String expression, AnnotationMirror annotation, AnnotationMirror contractAnnotation) {
            super(expression, annotation, contractAnnotation, Contract.Kind.POSTCONDTION);
        }
    }

    public static class Precondition
    extends Contract {
        public Precondition(String expression, AnnotationMirror annotation, AnnotationMirror contractAnnotation) {
            super(expression, annotation, contractAnnotation, Contract.Kind.PRECONDITION);
        }
    }

    public static abstract class Contract {
        public final String expression;
        public final AnnotationMirror annotation;
        public final AnnotationMirror contractAnnotation;
        public final Kind kind;

        public Contract(String expression, AnnotationMirror annotation, AnnotationMirror contractAnnotation, Kind kind) {
            this.expression = expression;
            this.annotation = annotation;
            this.contractAnnotation = contractAnnotation;
            this.kind = kind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Contract contract = (Contract)o;
            return Objects.equals(this.expression, contract.expression) && Objects.equals(this.annotation, contract.annotation) && this.kind == contract.kind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.expression, this.annotation, this.kind});
        }

        public static enum Kind {
            PRECONDITION("precondition"),
            POSTCONDTION("postcondition"),
            CONDITIONALPOSTCONDTION("conditional.postcondition");

            public final String errorKey;

            private Kind(String errorKey) {
                this.errorKey = errorKey;
            }
        }
    }
}

