/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil.trees;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.javacutil.trees.DetachedVarSymbol;

public class TreeBuilder {
    protected final Elements elements;
    protected final Types modelTypes;
    protected final com.sun.tools.javac.code.Types javacTypes;
    protected final TreeMaker maker;
    protected final Names names;
    protected final Symtab symtab;
    protected final ProcessingEnvironment env;

    public TreeBuilder(ProcessingEnvironment env) {
        this.env = env;
        Context context = ((JavacProcessingEnvironment)env).getContext();
        this.elements = env.getElementUtils();
        this.modelTypes = env.getTypeUtils();
        this.javacTypes = com.sun.tools.javac.code.Types.instance(context);
        this.maker = TreeMaker.instance(context);
        this.names = Names.instance(context);
        this.symtab = Symtab.instance(context);
    }

    public MemberSelectTree buildIteratorMethodAccess(ExpressionTree iterableExpr) {
        TypeMirror elementType;
        DeclaredType exprType = (DeclaredType)TypesUtils.upperBound(TreeUtils.typeOf(iterableExpr));
        assert (exprType != null) : "expression must be of declared type Iterable<>";
        TypeElement exprElement = (TypeElement)exprType.asElement();
        Symbol.MethodSymbol iteratorMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(this.elements.getAllMembers(exprElement))) {
            Name methodName = method.getSimpleName();
            if (!method.getParameters().isEmpty() || !methodName.contentEquals("iterator")) continue;
            iteratorMethod = (Symbol.MethodSymbol)method;
        }
        assert (iteratorMethod != null) : "no iterator method declared for expression type";
        Type.MethodType methodType = (Type.MethodType)iteratorMethod.asType();
        Symbol.TypeSymbol methodClass = methodType.asElement();
        DeclaredType iteratorType = (DeclaredType)((Object)methodType.getReturnType());
        iteratorType = (DeclaredType)((Object)this.javacTypes.asSuper((Type)((Object)iteratorType), this.symtab.iteratorType.asElement()));
        int numIterTypeArgs = iteratorType.getTypeArguments().size();
        assert (numIterTypeArgs <= 1) : "expected at most one type argument for Iterator";
        if (numIterTypeArgs == 1 && (elementType = iteratorType.getTypeArguments().get(0)) instanceof Type.CapturedType) {
            elementType = ((Type.CapturedType)elementType).wildcard;
            iteratorType = this.modelTypes.getDeclaredType((TypeElement)this.modelTypes.asElement(iteratorType), elementType);
        }
        Type.MethodType updatedMethodType = new Type.MethodType(List.nil(), (Type)((Object)iteratorType), List.nil(), methodClass);
        JCTree.JCFieldAccess iteratorAccess = (JCTree.JCFieldAccess)this.maker.Select((JCTree.JCExpression)iterableExpr, iteratorMethod);
        iteratorAccess.setType(updatedMethodType);
        return iteratorAccess;
    }

    public MemberSelectTree buildHasNextMethodAccess(ExpressionTree iteratorExpr) {
        DeclaredType exprType = (DeclaredType)TreeUtils.typeOf(iteratorExpr);
        assert (exprType != null) : "expression must be of declared type Iterator<>";
        TypeElement exprElement = (TypeElement)exprType.asElement();
        Symbol.MethodSymbol hasNextMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(this.elements.getAllMembers(exprElement))) {
            Name methodName = method.getSimpleName();
            if (!method.getParameters().isEmpty() || !methodName.contentEquals("hasNext")) continue;
            hasNextMethod = (Symbol.MethodSymbol)method;
        }
        assert (hasNextMethod != null) : "no hasNext method declared for expression type";
        JCTree.JCFieldAccess hasNextAccess = (JCTree.JCFieldAccess)this.maker.Select((JCTree.JCExpression)iteratorExpr, hasNextMethod);
        hasNextAccess.setType((Type)hasNextMethod.asType());
        return hasNextAccess;
    }

    public MemberSelectTree buildNextMethodAccess(ExpressionTree iteratorExpr) {
        DeclaredType exprType = (DeclaredType)TreeUtils.typeOf(iteratorExpr);
        assert (exprType != null) : "expression must be of declared type Iterator<>";
        TypeElement exprElement = (TypeElement)exprType.asElement();
        Symbol.MethodSymbol nextMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(this.elements.getAllMembers(exprElement))) {
            Name methodName = method.getSimpleName();
            if (!method.getParameters().isEmpty() || !methodName.contentEquals("next")) continue;
            nextMethod = (Symbol.MethodSymbol)method;
        }
        assert (nextMethod != null) : "no next method declared for expression type";
        Type.MethodType methodType = (Type.MethodType)nextMethod.asType();
        Symbol.TypeSymbol methodClass = methodType.asElement();
        Type elementType = exprType.getTypeArguments().isEmpty() ? this.symtab.objectType : (Type)exprType.getTypeArguments().get(0);
        Type.MethodType updatedMethodType = new Type.MethodType(List.nil(), elementType, List.nil(), methodClass);
        JCTree.JCFieldAccess nextAccess = (JCTree.JCFieldAccess)this.maker.Select((JCTree.JCExpression)iteratorExpr, nextMethod);
        nextAccess.setType(updatedMethodType);
        return nextAccess;
    }

    public MemberSelectTree buildArrayLengthAccess(ExpressionTree expression) {
        return (JCTree.JCFieldAccess)this.maker.Select((JCTree.JCExpression)expression, this.symtab.lengthVar);
    }

    public MethodInvocationTree buildMethodInvocation(ExpressionTree methodExpr) {
        return this.maker.App((JCTree.JCExpression)methodExpr);
    }

    public MethodInvocationTree buildMethodInvocation(ExpressionTree methodExpr, ExpressionTree argExpr) {
        return this.maker.App((JCTree.JCExpression)methodExpr, List.of((JCTree.JCExpression)argExpr));
    }

    public VariableTree buildVariableDecl(TypeMirror type, String name, Element owner, ExpressionTree initializer) {
        DetachedVarSymbol sym = new DetachedVarSymbol(0L, this.names.fromString(name), (Type)type, (Symbol)owner);
        JCTree.JCVariableDecl tree = this.maker.VarDef(sym, (JCTree.JCExpression)initializer);
        sym.setDeclaration(tree);
        return tree;
    }

    public VariableTree buildVariableDecl(Tree type, String name, Element owner, ExpressionTree initializer) {
        Type typeMirror = (Type)TreeUtils.typeOf(type);
        DetachedVarSymbol sym = new DetachedVarSymbol(0L, this.names.fromString(name), typeMirror, (Symbol)owner);
        JCTree.JCModifiers mods = this.maker.Modifiers(0L);
        JCTree.JCVariableDecl decl = this.maker.VarDef(mods, sym.name, (JCTree.JCExpression)type, (JCTree.JCExpression)initializer);
        decl.setType(typeMirror);
        decl.sym = sym;
        sym.setDeclaration(decl);
        return decl;
    }

    public IdentifierTree buildVariableUse(VariableTree decl) {
        return (IdentifierTree)((Object)this.maker.Ident((JCTree.JCVariableDecl)decl));
    }

    public TypeCastTree buildTypeCast(TypeMirror type, ExpressionTree expr) {
        return this.maker.TypeCast((Type)type, (JCTree.JCExpression)expr);
    }

    public StatementTree buildAssignment(VariableTree variable, ExpressionTree expr) {
        return this.maker.Assignment(TreeInfo.symbolFor((JCTree)((Object)variable)), (JCTree.JCExpression)expr);
    }

    public AssignmentTree buildAssignment(ExpressionTree lhs, ExpressionTree rhs) {
        JCTree.JCAssign assign = this.maker.Assign((JCTree.JCExpression)lhs, (JCTree.JCExpression)rhs);
        assign.setType((Type)TreeUtils.typeOf(lhs));
        return assign;
    }

    public LiteralTree buildLiteral(Object value) {
        return this.maker.Literal(value);
    }

    public BinaryTree buildLessThan(ExpressionTree left, ExpressionTree right) {
        JCTree.JCBinary binary = this.maker.Binary(JCTree.Tag.LT, (JCTree.JCExpression)left, (JCTree.JCExpression)right);
        binary.setType((Type)((Object)this.modelTypes.getPrimitiveType(TypeKind.BOOLEAN)));
        return binary;
    }

    public ArrayAccessTree buildArrayAccess(ExpressionTree array, ExpressionTree index) {
        ArrayType arrayType = (ArrayType)TreeUtils.typeOf(array);
        JCTree.JCArrayAccess access = this.maker.Indexed((JCTree.JCExpression)array, (JCTree.JCExpression)index);
        access.setType((Type)arrayType.getComponentType());
        return access;
    }

    public IdentifierTree buildClassUse(Element elt) {
        return this.maker.Ident((Symbol)elt);
    }

    public MemberSelectTree buildValueOfMethodAccess(Tree expr) {
        TypeMirror boxedType = TreeUtils.typeOf(expr);
        assert (TypesUtils.isBoxedPrimitive(boxedType));
        Symbol.MethodSymbol valueOfMethod = TreeBuilder.getValueOfMethod(this.env, boxedType);
        Type.MethodType methodType = (Type.MethodType)valueOfMethod.asType();
        JCTree.JCFieldAccess valueOfAccess = (JCTree.JCFieldAccess)this.maker.Select((JCTree.JCExpression)expr, valueOfMethod);
        valueOfAccess.setType(methodType);
        return valueOfAccess;
    }

    public static Symbol.MethodSymbol getValueOfMethod(ProcessingEnvironment env, TypeMirror boxedType) {
        Symbol.MethodSymbol valueOfMethod = null;
        PrimitiveType unboxedType = env.getTypeUtils().unboxedType(boxedType);
        TypeElement boxedElement = (TypeElement)((DeclaredType)boxedType).asElement();
        for (ExecutableElement method : ElementFilter.methodsIn(env.getElementUtils().getAllMembers(boxedElement))) {
            java.util.List<? extends VariableElement> params;
            Name methodName = method.getSimpleName();
            if (!methodName.contentEquals("valueOf") || (params = method.getParameters()).size() != 1 || !env.getTypeUtils().isSameType(params.get(0).asType(), unboxedType)) continue;
            valueOfMethod = (Symbol.MethodSymbol)method;
        }
        assert (valueOfMethod != null) : "no valueOf method declared for boxed type";
        return valueOfMethod;
    }

    public MemberSelectTree buildPrimValueMethodAccess(Tree expr) {
        TypeMirror boxedType = TreeUtils.typeOf(expr);
        TypeElement boxedElement = (TypeElement)((DeclaredType)boxedType).asElement();
        assert (TypesUtils.isBoxedPrimitive(boxedType));
        PrimitiveType unboxedType = this.modelTypes.unboxedType(boxedType);
        String primValueName = unboxedType.toString() + "Value";
        Symbol.MethodSymbol primValueMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(this.elements.getAllMembers(boxedElement))) {
            Name methodName = method.getSimpleName();
            if (!methodName.contentEquals(primValueName) || !method.getParameters().isEmpty()) continue;
            primValueMethod = (Symbol.MethodSymbol)method;
        }
        assert (primValueMethod != null) : "no *Value method declared for boxed type";
        Type.MethodType methodType = (Type.MethodType)primValueMethod.asType();
        JCTree.JCFieldAccess primValueAccess = (JCTree.JCFieldAccess)this.maker.Select((JCTree.JCExpression)expr, primValueMethod);
        primValueAccess.setType(methodType);
        return primValueAccess;
    }

    public JCTree.Tag kindToTag(Tree.Kind kind) {
        switch (kind) {
            case AND: {
                return JCTree.Tag.BITAND;
            }
            case AND_ASSIGNMENT: {
                return JCTree.Tag.BITAND_ASG;
            }
            case ANNOTATION: {
                return JCTree.Tag.ANNOTATION;
            }
            case ANNOTATION_TYPE: {
                return JCTree.Tag.TYPE_ANNOTATION;
            }
            case ARRAY_ACCESS: {
                return JCTree.Tag.INDEXED;
            }
            case ARRAY_TYPE: {
                return JCTree.Tag.TYPEARRAY;
            }
            case ASSERT: {
                return JCTree.Tag.ASSERT;
            }
            case ASSIGNMENT: {
                return JCTree.Tag.ASSIGN;
            }
            case BITWISE_COMPLEMENT: {
                return JCTree.Tag.COMPL;
            }
            case BLOCK: {
                return JCTree.Tag.BLOCK;
            }
            case BREAK: {
                return JCTree.Tag.BREAK;
            }
            case CASE: {
                return JCTree.Tag.CASE;
            }
            case CATCH: {
                return JCTree.Tag.CATCH;
            }
            case CLASS: {
                return JCTree.Tag.CLASSDEF;
            }
            case CONDITIONAL_AND: {
                return JCTree.Tag.AND;
            }
            case CONDITIONAL_EXPRESSION: {
                return JCTree.Tag.CONDEXPR;
            }
            case CONDITIONAL_OR: {
                return JCTree.Tag.OR;
            }
            case CONTINUE: {
                return JCTree.Tag.CONTINUE;
            }
            case DIVIDE: {
                return JCTree.Tag.DIV;
            }
            case DIVIDE_ASSIGNMENT: {
                return JCTree.Tag.DIV_ASG;
            }
            case DO_WHILE_LOOP: {
                return JCTree.Tag.DOLOOP;
            }
            case ENHANCED_FOR_LOOP: {
                return JCTree.Tag.FOREACHLOOP;
            }
            case EQUAL_TO: {
                return JCTree.Tag.EQ;
            }
            case EXPRESSION_STATEMENT: {
                return JCTree.Tag.EXEC;
            }
            case FOR_LOOP: {
                return JCTree.Tag.FORLOOP;
            }
            case GREATER_THAN: {
                return JCTree.Tag.GT;
            }
            case GREATER_THAN_EQUAL: {
                return JCTree.Tag.GE;
            }
            case IDENTIFIER: {
                return JCTree.Tag.IDENT;
            }
            case IF: {
                return JCTree.Tag.IF;
            }
            case IMPORT: {
                return JCTree.Tag.IMPORT;
            }
            case INSTANCE_OF: {
                return JCTree.Tag.TYPETEST;
            }
            case LABELED_STATEMENT: {
                return JCTree.Tag.LABELLED;
            }
            case LEFT_SHIFT: {
                return JCTree.Tag.SL;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return JCTree.Tag.SL_ASG;
            }
            case LESS_THAN: {
                return JCTree.Tag.LT;
            }
            case LESS_THAN_EQUAL: {
                return JCTree.Tag.LE;
            }
            case LOGICAL_COMPLEMENT: {
                return JCTree.Tag.NOT;
            }
            case MEMBER_SELECT: {
                return JCTree.Tag.SELECT;
            }
            case METHOD: {
                return JCTree.Tag.METHODDEF;
            }
            case METHOD_INVOCATION: {
                return JCTree.Tag.APPLY;
            }
            case MINUS: {
                return JCTree.Tag.MINUS;
            }
            case MINUS_ASSIGNMENT: {
                return JCTree.Tag.MINUS_ASG;
            }
            case MODIFIERS: {
                return JCTree.Tag.MODIFIERS;
            }
            case MULTIPLY: {
                return JCTree.Tag.MUL;
            }
            case MULTIPLY_ASSIGNMENT: {
                return JCTree.Tag.MUL_ASG;
            }
            case NEW_ARRAY: {
                return JCTree.Tag.NEWARRAY;
            }
            case NEW_CLASS: {
                return JCTree.Tag.NEWCLASS;
            }
            case NOT_EQUAL_TO: {
                return JCTree.Tag.NE;
            }
            case OR: {
                return JCTree.Tag.BITOR;
            }
            case OR_ASSIGNMENT: {
                return JCTree.Tag.BITOR_ASG;
            }
            case PARENTHESIZED: {
                return JCTree.Tag.PARENS;
            }
            case PLUS: {
                return JCTree.Tag.PLUS;
            }
            case PLUS_ASSIGNMENT: {
                return JCTree.Tag.PLUS_ASG;
            }
            case POSTFIX_DECREMENT: {
                return JCTree.Tag.POSTDEC;
            }
            case POSTFIX_INCREMENT: {
                return JCTree.Tag.POSTINC;
            }
            case PREFIX_DECREMENT: {
                return JCTree.Tag.PREDEC;
            }
            case PREFIX_INCREMENT: {
                return JCTree.Tag.PREINC;
            }
            case REMAINDER: {
                return JCTree.Tag.MOD;
            }
            case REMAINDER_ASSIGNMENT: {
                return JCTree.Tag.MOD_ASG;
            }
            case RETURN: {
                return JCTree.Tag.RETURN;
            }
            case RIGHT_SHIFT: {
                return JCTree.Tag.SR;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return JCTree.Tag.SR_ASG;
            }
            case SWITCH: {
                return JCTree.Tag.SWITCH;
            }
            case SYNCHRONIZED: {
                return JCTree.Tag.SYNCHRONIZED;
            }
            case THROW: {
                return JCTree.Tag.THROW;
            }
            case TRY: {
                return JCTree.Tag.TRY;
            }
            case TYPE_CAST: {
                return JCTree.Tag.TYPECAST;
            }
            case TYPE_PARAMETER: {
                return JCTree.Tag.TYPEPARAMETER;
            }
            case UNARY_MINUS: {
                return JCTree.Tag.NEG;
            }
            case UNARY_PLUS: {
                return JCTree.Tag.POS;
            }
            case UNION_TYPE: {
                return JCTree.Tag.TYPEUNION;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return JCTree.Tag.USR;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return JCTree.Tag.USR_ASG;
            }
            case VARIABLE: {
                return JCTree.Tag.VARDEF;
            }
            case WHILE_LOOP: {
                return JCTree.Tag.WHILELOOP;
            }
            case XOR: {
                return JCTree.Tag.BITXOR;
            }
            case XOR_ASSIGNMENT: {
                return JCTree.Tag.BITXOR_ASG;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    public BinaryTree buildBinary(TypeMirror type, Tree.Kind op, ExpressionTree left, ExpressionTree right) {
        JCTree.Tag jcOp = this.kindToTag(op);
        JCTree.JCBinary binary = this.maker.Binary(jcOp, (JCTree.JCExpression)left, (JCTree.JCExpression)right);
        binary.setType((Type)type);
        return binary;
    }

    public NewArrayTree buildNewArray(TypeMirror componentType, java.util.List<ExpressionTree> elems) {
        ArrayList<JCTree.JCExpression> exprs = new ArrayList<JCTree.JCExpression>();
        for (ExpressionTree elem : elems) {
            exprs.add((JCTree.JCExpression)elem);
        }
        JCTree.JCNewArray newArray = this.maker.NewArray((JCTree.JCExpression)((Object)this.buildClassUse(((Type)componentType).tsym)), List.nil(), List.from(exprs));
        newArray.setType(this.javacTypes.makeArrayType((Type)componentType));
        return newArray;
    }
}

