/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.apache.bcel.generic;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.org.apache.bcel.Repository;
import org.checkerframework.org.apache.bcel.classfile.JavaClass;
import org.checkerframework.org.apache.bcel.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryName String class_name;

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @ClassGetName String class_name) {
        return new ObjectType(class_name);
    }

    public ObjectType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @ClassGetName String class_name) {
        super((byte)14, "L" + class_name.replace('.', '/') + ";");
        this.class_name = class_name.replace('/', '.');
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryName String getClassName() {
        return this.class_name;
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.class_name.hashCode();
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).class_name.equals(this.class_name) : false;
    }

    @Deprecated
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesClass() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesInterface() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return !jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesClassExact() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return jc.isClass();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesInterfaceExact() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return !jc.isClass();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean subclassOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType superclass) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        if (this.referencesInterfaceExact() || superclass.referencesInterfaceExact()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, superclass.class_name);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean accessibleTo(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType accessor) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.class_name);
        return acc.getPackageName().equals(jc.getPackageName());
    }
}

