/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asmx.xml;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.org.objectweb.asmx.AnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.Attribute;
import org.checkerframework.org.objectweb.asmx.Handle;
import org.checkerframework.org.objectweb.asmx.Label;
import org.checkerframework.org.objectweb.asmx.MethodVisitor;
import org.checkerframework.org.objectweb.asmx.Type;
import org.checkerframework.org.objectweb.asmx.TypeAnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.TypePath;
import org.checkerframework.org.objectweb.asmx.util.AbstractVisitor;
import org.checkerframework.org.objectweb.asmx.xml.SAXAdapter;
import org.checkerframework.org.objectweb.asmx.xml.SAXAnnotationAdapter;
import org.checkerframework.org.objectweb.asmx.xml.SAXClassAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXCodeAdapter
extends SAXAdapter
implements MethodVisitor {
    private Map labelNames = new HashMap();

    public SAXCodeAdapter(ContentHandler h2, int access) {
        super(h2);
        if ((access & 0x700) == 0) {
            this.addStart("code", new AttributesImpl());
        }
    }

    @Override
    public final void visitCode() {
    }

    @Override
    public final void visitInsn(int opcode) {
        this.addElement(AbstractVisitor.OPCODES[opcode], new AttributesImpl());
    }

    @Override
    public final void visitIntInsn(int opcode, int operand) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "value", "value", "", Integer.toString(operand));
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    @Override
    public final void visitVarInsn(int opcode, int var) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "var", "var", "", Integer.toString(var));
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    @Override
    public final void visitTypeInsn(int opcode, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    @Override
    public final void visitFieldInsn(int opcode, String owner, String name, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "owner", "owner", "", owner);
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    @Override
    public final void visitMethodInsn(int opcode, String owner, String name, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "owner", "owner", "", owner);
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        attrs.addAttribute("", "bsm", "bsm", "", SAXClassAdapter.encode(bsm.toString()));
        String o = AbstractVisitor.OPCODES[186];
        this.addStart(o, attrs);
        for (int i = 0; i < bsmArgs.length; ++i) {
            AttributesImpl cattrs = new AttributesImpl();
            cattrs.addAttribute("", "cst", "cst", "", SAXClassAdapter.encode(bsmArgs[i].toString()));
            cattrs.addAttribute("", "desc", "desc", "", Type.getDescriptor(bsmArgs[i].getClass()));
            this.addElement("bsmArg", cattrs);
        }
        this.addEnd(o);
    }

    @Override
    public final void visitJumpInsn(int opcode, Label label) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "label", "label", "", this.getLabel(label));
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    @Override
    public final void visitLabel(Label label) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "", this.getLabel(label));
        this.addElement("Label", attrs);
    }

    @Override
    public final void visitLdcInsn(Object cst) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "cst", "cst", "", SAXClassAdapter.encode(cst.toString()));
        attrs.addAttribute("", "desc", "desc", "", Type.getDescriptor(cst.getClass()));
        this.addElement(AbstractVisitor.OPCODES[18], attrs);
    }

    @Override
    public final void visitIincInsn(int var, int increment) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "var", "var", "", Integer.toString(var));
        attrs.addAttribute("", "inc", "inc", "", Integer.toString(increment));
        this.addElement(AbstractVisitor.OPCODES[132], attrs);
    }

    @Override
    public final void visitTableSwitchInsn(int min2, int max, Label dflt, Label[] labels) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "min", "min", "", Integer.toString(min2));
        attrs.addAttribute("", "max", "max", "", Integer.toString(max));
        attrs.addAttribute("", "dflt", "dflt", "", this.getLabel(dflt));
        String o = AbstractVisitor.OPCODES[170];
        this.addStart(o, attrs);
        for (int i = 0; i < labels.length; ++i) {
            AttributesImpl att2 = new AttributesImpl();
            att2.addAttribute("", "name", "name", "", this.getLabel(labels[i]));
            this.addElement("label", att2);
        }
        this.addEnd(o);
    }

    @Override
    public final void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "dflt", "dflt", "", this.getLabel(dflt));
        String o = AbstractVisitor.OPCODES[171];
        this.addStart(o, att);
        for (int i = 0; i < labels.length; ++i) {
            AttributesImpl att2 = new AttributesImpl();
            att2.addAttribute("", "name", "name", "", this.getLabel(labels[i]));
            att2.addAttribute("", "key", "key", "", Integer.toString(keys[i]));
            this.addElement("label", att2);
        }
        this.addEnd(o);
    }

    @Override
    public final void visitMultiANewArrayInsn(String desc, int dims) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "desc", "desc", "", desc);
        attrs.addAttribute("", "dims", "dims", "", Integer.toString(dims));
        this.addElement(AbstractVisitor.OPCODES[197], attrs);
    }

    @Override
    public final void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        attrs.addAttribute("", "end", "end", "", this.getLabel(end));
        attrs.addAttribute("", "handler", "handler", "", this.getLabel(handler));
        if (type != null) {
            attrs.addAttribute("", "type", "type", "", type);
        }
        this.addElement("TryCatch", attrs);
    }

    @Override
    public final void visitMaxs(int maxStack, int maxLocals) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "maxStack", "maxStack", "", Integer.toString(maxStack));
        attrs.addAttribute("", "maxLocals", "maxLocals", "", Integer.toString(maxLocals));
        this.addElement("Max", attrs);
        this.addEnd("code");
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        if (signature != null) {
            attrs.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(signature));
        }
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        attrs.addAttribute("", "end", "end", "", this.getLabel(end));
        attrs.addAttribute("", "var", "var", "", Integer.toString(index));
        this.addElement("LocalVar", attrs);
    }

    @Override
    public final void visitLineNumber(int line, Label start) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "line", "line", "", Integer.toString(line));
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        this.addElement("LineNumber", attrs);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationDefault", 0, null, null);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotation", visible ? 1 : -1, null, desc);
    }

    @Override
    public TypeAnnotationVisitor visitTypeAnnotation(String desc, boolean visible, boolean inCode) {
        return null;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "parameterAnnotation", visible ? 1 : -1, parameter, desc);
    }

    @Override
    public void visitEnd() {
        this.addEnd("method");
    }

    @Override
    public final void visitAttribute(Attribute attr) {
    }

    private final String getLabel(Label label) {
        String name = (String)this.labelNames.get(label);
        if (name == null) {
            name = Integer.toString(this.labelNames.size());
            this.labelNames.put(label, name);
        }
        return name;
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }
}

